/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.region;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mapwriter.region.BlockColours;
import mapwriter.region.MwChunk;
import mapwriter.region.Region;
import mapwriter.region.RegionFileCache;
import org.apache.logging.log4j.Logger;

public class RegionManager {
    private final LruCache regionMap;
    public final File worldDir;
    public final File imageDir;
    public BlockColours blockColours;
    public static Logger logger;
    public final RegionFileCache regionFileCache;
    public int maxZoom;
    public int minZoom;

    public static void logInfo(String s, Object ... args) {
        if (logger != null) {
            logger.info(String.format(s, args));
        }
    }

    public static void logWarning(String s, Object ... args) {
        if (logger != null) {
            logger.warn(String.format(s, args));
        }
    }

    public static void logError(String s, Object ... args) {
        if (logger != null) {
            logger.error(String.format(s, args));
        }
    }

    public RegionManager(File worldDir, File imageDir, BlockColours blockColours, int minZoom, int maxZoom) {
        this.worldDir = worldDir;
        this.imageDir = imageDir;
        this.blockColours = blockColours;
        this.regionMap = new LruCache();
        this.regionFileCache = new RegionFileCache(worldDir);
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
    }

    public void close() {
        for (Region region : this.regionMap.values()) {
            if (region == null) continue;
            region.close();
        }
        this.regionMap.clear();
        this.regionFileCache.close();
    }

    private static int incrStatsCounter(Map<String, Integer> h, String key) {
        int n = 1;
        if (h.containsKey(key)) {
            n = h.get(key) + 1;
        }
        h.put(key, n);
        return n;
    }

    public void printLoadedRegionStats() {
        RegionManager.logInfo("loaded region listing:", new Object[0]);
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        for (Region region : this.regionMap.values()) {
            RegionManager.logInfo("  %s", region);
            RegionManager.incrStatsCounter(stats, String.format("dim%d", region.dimension));
            RegionManager.incrStatsCounter(stats, String.format("zoom%d", region.zoomLevel));
            RegionManager.incrStatsCounter(stats, "total");
        }
        RegionManager.logInfo("loaded region stats:", new Object[0]);
        for (Map.Entry entry : stats.entrySet()) {
            RegionManager.logInfo("  %s: %d", entry.getKey(), entry.getValue());
        }
    }

    public Region getRegion(int x, int z, int zoomLevel, int dimension) {
        Region region = (Region)this.regionMap.get(Region.getKey(x, z, zoomLevel, dimension));
        if (region == null) {
            region = new Region(this, x, z, zoomLevel, dimension);
            this.regionMap.put(region.key, region);
        }
        return region;
    }

    public void updateChunk(MwChunk chunk) {
        Region region = this.getRegion(chunk.x << 4, chunk.z << 4, 0, chunk.dimension);
        region.updateChunk(chunk);
    }

    public void rebuildRegions(int xStart, int zStart, int w, int h, int dimension) {
        int xBeg = xStart & 0xFFFFFE00;
        int zBeg = zStart & 0xFFFFFE00;
        int xEnd = xStart + w - 1 + 512 & 0xFFFFFE00;
        int zEnd = zStart + h - 1 + 512 & 0xFFFFFE00;
        RegionManager.logInfo("rebuilding regions from [%d, %d] to (%d, %d)", xBeg, zBeg, xEnd, zEnd);
        for (int rX = xBeg; rX < xEnd; rX += 512) {
            for (int rZ = zBeg; rZ < zEnd; rZ += 512) {
                Region region = this.getRegion(rX, rZ, 0, dimension);
                if (this.regionFileCache.regionFileExists(rX, rZ, dimension)) {
                    region.clear();
                    for (int cz = 0; cz < 32; ++cz) {
                        for (int cx = 0; cx < 32; ++cx) {
                            MwChunk chunk = MwChunk.read((region.x >> 4) + cx, (region.z >> 4) + cz, region.dimension, this.regionFileCache);
                            region.updateChunk(chunk);
                        }
                    }
                }
                region.updateZoomLevels();
            }
        }
    }

    class LruCache
    extends LinkedHashMap<Long, Region> {
        private static final long serialVersionUID = 1L;
        private static final int MAX_LOADED_REGIONS = 64;

        public LruCache() {
            super(128, 0.5f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, Region> entry) {
            boolean ret = false;
            if (this.size() > 64) {
                Region region = entry.getValue();
                region.close();
                ret = true;
            }
            return ret;
        }
    }
}

