/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.MinimapRadar;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.MinimapSafeModeRenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public abstract class MinimapRenderer {
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    protected IXaeroMinimap modMain;
    protected Minecraft mc;
    protected MinimapInterface minimapInterface;
    protected MinimapRendererHelper helper;
    protected WaypointsGuiRenderer waypointsGuiRenderer;
    private int lastMinimapSize;
    private ArrayList<String> underText;
    protected double zoom = 1.0;

    public MinimapRenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface) {
        this.modMain = modMain;
        this.mc = mc;
        this.waypointsGuiRenderer = waypointsGuiRenderer;
        this.minimapInterface = minimapInterface;
        this.underText = new ArrayList();
        this.helper = new MinimapRendererHelper();
    }

    public float getEntityYaw(Entity e, float partial) {
        if (e == this.mc.field_71439_g) {
            return e.field_70177_z;
        }
        if (e instanceof EntityLivingBase) {
            return ((EntityLivingBase)e).field_70758_at + (((EntityLivingBase)e).field_70759_as - ((EntityLivingBase)e).field_70758_at) * partial;
        }
        return e.field_70126_B + (e.field_70177_z - e.field_70126_B) * partial;
    }

    public double getRenderAngle(boolean lockedNorth) {
        if (lockedNorth) {
            return 90.0;
        }
        return this.getActualAngle();
    }

    private double getActualAngle() {
        double rotation = Math.toDegrees(Misc.getYawRadians());
        return -90.0 - rotation;
    }

    protected abstract void renderChunks(XaeroMinimapSession var1, MinimapProcessor var2, int var3, int var4, float var5, float var6, int var7, boolean var8, boolean var9, int var10, double var11, double var13, boolean var15, boolean var16, ModSettings var17);

    public void renderMinimap(XaeroMinimapSession minimapSession, MinimapProcessor minimap, int x, int y, int width, int height, int scale, int size, float partial) {
        boolean crosshairDisplayed;
        int specW;
        int frameTextureX;
        boolean renderFrame;
        ModSettings settings = this.modMain.getSettings();
        if (settings.getMinimapSize(scale) != this.lastMinimapSize) {
            this.lastMinimapSize = settings.getMinimapSize(scale);
            minimap.setToResetImage(true);
        }
        minimap.getEntityRadar().setLastRenderViewEntity((Entity)this.mc.field_71451_h);
        ArrayList<String> underText = this.underText;
        int mapSize = minimapSession.getMinimapProcessor().getMinimapSize(scale);
        int bufferSize = minimapSession.getMinimapProcessor().getMinimapBufferSize(mapSize);
        if (this.minimapInterface.usingFBO()) {
            bufferSize = minimap.getFBOBufferSize();
        }
        float minimapScale = settings.getMinimapScale(scale);
        float mapScale = (float)scale / minimapScale;
        minimap.updateZoom();
        this.zoom = minimap.getMinimapZoom();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPixelStorei((int)3317, (int)4);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glPixelStorei((int)3314, (int)0);
        float sizeFix = (float)bufferSize / 512.0f;
        int shape = settings.minimapShape;
        boolean lockedNorth = settings.getLockNorth(mapSize / 2, shape);
        double angle = Math.toRadians(this.getRenderAngle(lockedNorth));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        boolean useWorldMap = this.modMain.getSupportMods().shouldUseWorldMapChunks() && minimap.getMinimapWriter().getLoadedCaving() == -1 && minimap.getMinimapWriter().loadedLightOverlayType <= 0;
        int lightLevel = (int)((1.0f - Math.min(1.0f, this.getSunBrightness())) * (float)(minimap.getMinimapWriter().getLoadedLevels() - 1));
        boolean cave = !useWorldMap && minimap.getMinimapWriter().getLoadedCaving() != -1;
        boolean circleShape = shape == 1;
        this.renderChunks(minimapSession, minimap, mapSize, bufferSize, sizeFix, partial, lightLevel, useWorldMap, lockedNorth, shape, ps, pc, cave, circleShape, settings);
        if (this.minimapInterface.usingFBO()) {
            sizeFix = 1.0f;
        }
        GL11.glEnable((int)3042);
        GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
        int scaledX = (int)((float)x * mapScale);
        int scaledY = (int)((float)y * mapScale);
        int minimapFrameSize = (int)((float)(mapSize / 2) / sizeFix);
        int circleSides = Math.max(32, (int)Math.ceil(Math.PI * (double)(minimapFrameSize + 8) / 8.0));
        if (!circleShape) {
            this.helper.drawMyTexturedModalRect((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, minimapFrameSize, 256.0f);
        } else {
            this.helper.drawTexturedElipseInsideRectangle(circleSides, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, 256.0f);
        }
        if (!this.minimapInterface.usingFBO()) {
            GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        int frameType = settings.minimapFrame;
        boolean bl = renderFrame = frameType < ModSettings.FRAME_OPTIONS.length - 1;
        int n = frameType == 0 ? 0 : (frameTextureX = frameType == 1 ? 76 : 93);
        if (frameType > 0) {
            int frameColor = ModSettings.COLORS[settings.minimapFrameColor];
            GL11.glColor4f((float)((float)(frameColor >> 16 & 0xFF) / 255.0f), (float)((float)(frameColor >> 8 & 0xFF) / 255.0f), (float)((float)(frameColor & 0xFF) / 255.0f), (float)1.0f);
        }
        if (renderFrame && !circleShape) {
            int rightCornerStartX = scaledX + 9 + mapSize / 2 + 4 - 17;
            int bottomCornerStartY = scaledY + 9 + mapSize / 2 + 4 - 15;
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4, frameTextureX, 0, 17, 15);
            this.mc.field_71456_v.func_73729_b(rightCornerStartX, scaledY + 9 - 4, frameTextureX, 15, 17, 15);
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, bottomCornerStartY, frameTextureX, 30, 17, 15);
            this.mc.field_71456_v.func_73729_b(rightCornerStartX, bottomCornerStartY, frameTextureX, 45, 17, 15);
            int horLineStartX = scaledX + 9 - 4 + 17;
            int horLineWidth = rightCornerStartX - horLineStartX;
            int horLineLength = (int)Math.ceil((double)horLineWidth / 16.0);
            for (int i = 0; i < horLineLength; ++i) {
                int lineX = scaledX + 9 - 4 + 17 + i * 16;
                int lineW = 16;
                if (i == horLineLength - 1 && lineX + lineW > rightCornerStartX) {
                    lineW = rightCornerStartX - lineX;
                }
                this.mc.field_71456_v.func_73729_b(lineX, scaledY + 9 - 4, frameTextureX, 60, lineW, 4);
                this.mc.field_71456_v.func_73729_b(lineX, scaledY + 9 - 4 + mapSize / 2 + 9 - 5, frameTextureX, 64, lineW, 4);
            }
            int verLineStartY = scaledY + 9 - 4 + 15;
            int verLineHeight = bottomCornerStartY - verLineStartY;
            int vertLineLength = (int)Math.ceil((double)verLineHeight / 5.0);
            for (int i = 0; i < vertLineLength; ++i) {
                int lineY = scaledY + 9 - 4 + 15 + i * 5;
                int lineH = 5;
                if (i == vertLineLength - 1 && lineY + lineH > bottomCornerStartY) {
                    lineH = bottomCornerStartY - lineY;
                }
                this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, lineY, frameTextureX, 68, 4, lineH);
                this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapSize / 2 + 9 - 5, lineY, frameTextureX, 73, 4, lineH);
            }
        } else if (renderFrame) {
            this.helper.drawTexturedElipseInsideRectangleFrame(circleSides, 4.0f, scaledX + 9, scaledY + 9, frameTextureX + 1, 60, mapSize / 2, 4.0f, 256.0f);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
        GL11.glScalef((float)(1.0f / minimapScale), (float)(1.0f / minimapScale), (float)1.0f);
        int halfFrame = (int)((float)mapSize * minimapScale / 2.0f / 2.0f);
        GL11.glTranslatef((float)halfFrame, (float)halfFrame, (float)0.0f);
        int specH = specW = halfFrame + (int)(3.0f * minimapScale);
        boolean safeMode = this instanceof MinimapSafeModeRenderer;
        double playerX = minimap.getEntityRadar().getEntityX((Entity)this.mc.field_71451_h, partial);
        double playerZ = minimap.getEntityRadar().getEntityZ((Entity)this.mc.field_71451_h, partial);
        this.waypointsGuiRenderer.render(minimapSession, this.helper, playerX, playerZ, specW, specH, ps, pc, partial, this.zoom * (double)minimapScale / 2.0, circleShape, minimapScale, safeMode);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glEnable((int)3042);
        boolean bl2 = crosshairDisplayed = settings.mainEntityAs == 0 && !lockedNorth;
        if (crosshairDisplayed) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            GL11.glDisable((int)3553);
            GL11.glTranslatef((float)(mapSize / 2), (float)(mapSize / 2), (float)0.0f);
            GL14.glBlendFuncSeparate((int)775, (int)0, (int)1, (int)0);
            this.helper.drawMyColoredRect(-5.0f, -1.0f, 5.0f, 1.0f);
            this.helper.drawMyColoredRect(-1.0f, 3.0f, 1.0f, 5.0f);
            this.helper.drawMyColoredRect(-1.0f, -5.0f, 1.0f, -3.0f);
            GL11.glBlendFunc((int)770, (int)771);
            int crosshairColor = minimap.getEntityRadar().getEntityColour((EntityPlayer)this.mc.field_71439_g, (Entity)this.mc.field_71451_h, 0.0f, false, settings);
            GL11.glColor4f((float)((float)(crosshairColor >> 16 & 0xFF) / 255.0f), (float)((float)(crosshairColor >> 8 & 0xFF) / 255.0f), (float)((float)(crosshairColor & 0xFF) / 255.0f), (float)1.0f);
            this.helper.drawMyColoredRect(1.0f, -1.0f, 3.0f, 1.0f);
            this.helper.drawMyColoredRect(-3.0f, -1.0f, -1.0f, 1.0f);
            this.helper.drawMyColoredRect(-1.0f, 1.0f, 1.0f, 3.0f);
            this.helper.drawMyColoredRect(-1.0f, -3.0f, 1.0f, -1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glPopMatrix();
        }
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        double centerX = 2 * scaledX + 18 + mapSize / 2;
        double centerY = 2 * scaledY + 18 + mapSize / 2;
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)centerX, (double)centerY, (double)0.0);
        if (!safeMode && !crosshairDisplayed) {
            EntityLivingBase mainEntity = this.mc.field_71451_h;
            MinimapRadar radar = minimap.getEntityRadar();
            this.minimapInterface.getMinimapFBORenderer().renderMainEntityDot(minimap, (EntityPlayer)this.mc.field_71439_g, (Entity)mainEntity, ps, pc, radar.getEntityX((Entity)mainEntity, partial), radar.getEntityZ((Entity)mainEntity, partial), partial, radar, lockedNorth, settings.getDotsStyle(), true, settings.debugEntityIcons, cave, settings.getDotNameScale(), settings);
        }
        if (lockedNorth || settings.mainEntityAs == 2) {
            float a;
            float b;
            float g;
            float r;
            float arrowAngle = lockedNorth ? this.getEntityYaw((Entity)this.mc.field_71451_h, partial) : 180.0f;
            float arrowOpacity = (float)settings.playerArrowOpacity / 100.0f;
            if (arrowOpacity == 1.0f) {
                this.drawArrow(arrowAngle, 0.0, 1.0, 0.0f, 0.0f, 0.0f, 0.5f, settings);
            }
            if (settings.arrowColour != -1) {
                float[] c = settings.arrowColours[settings.arrowColour];
                r = c[0];
                g = c[1];
                b = c[2];
                a = c[3];
            } else {
                int rgb = minimap.getEntityRadar().getPlayerTeamColour((EntityPlayer)this.mc.field_71439_g);
                if (rgb != -1) {
                    r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    b = (float)(rgb & 0xFF) / 255.0f;
                    a = 1.0f;
                } else {
                    float[] c = settings.arrowColours[0];
                    r = c[0];
                    g = c[1];
                    b = c[2];
                    a = c[3];
                }
            }
            this.drawArrow(arrowAngle, 0.0, 0.0, r, g, b, a *= arrowOpacity, settings);
        }
        GL11.glPopMatrix();
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        int playerBlockX = OptimizedMath.myFloor(this.mc.field_71451_h.field_70165_t);
        int playerBlockY = OptimizedMath.myFloor(Misc.getEntityY((Entity)this.mc.field_71451_h));
        int playerBlockZ = OptimizedMath.myFloor(this.mc.field_71451_h.field_70161_v);
        int depthClearerX = scaledX - 25;
        int depthClearerY = scaledY - 25;
        int depthClearerW = 18 + mapSize / 2 + 50;
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)519);
        GL11.glDepthMask((boolean)true);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        Gui.func_73734_a((int)depthClearerX, (int)depthClearerY, (int)(depthClearerX + depthClearerW), (int)(depthClearerY + depthClearerW), (int)-16777216);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthFunc((int)515);
        if (settings.getShowCoords()) {
            int interfaceSize = size;
            String coords = playerBlockX + ", " + playerBlockY + ", " + playerBlockZ;
            if (this.mc.field_71466_p.func_78256_a(coords) >= interfaceSize) {
                String stringLevel = "" + playerBlockY;
                coords = playerBlockX + ", " + playerBlockZ;
                underText.add(coords);
                underText.add(stringLevel);
            } else {
                underText.add(coords);
            }
        }
        Chunk chunk = this.mc.field_71441_e.func_72938_d(playerBlockX, playerBlockZ);
        if (settings.showDimensionName) {
            int dimensionId = this.mc.field_71441_e.field_73011_w.field_76574_g;
            String dimensionType = this.mc.field_71441_e.field_73011_w.func_80007_l();
            if (dimensionType != null) {
                String dimensionName = String.format("%s (%d)", dimensionType, dimensionId);
                underText.add(dimensionName);
            }
        }
        if (settings.showBiome) {
            BiomeGenBase biome = chunk.func_76591_a(playerBlockX & 0xF, playerBlockZ & 0xF, this.mc.field_71441_e.func_72959_q());
            String biomeText = biome == null ? I18n.func_135052_a((String)"gui.xaero_unknown_biome", (Object[])new Object[0]) : biome.field_76791_y;
            this.addLineWordsUnderMinimap(underText, size, biomeText);
        }
        if (settings.showLightLevel > 0) {
            boolean lightFetchable;
            int playerBlockLightLevel = 0;
            int playerSkyLightLevel = 0;
            boolean bl3 = lightFetchable = playerBlockY >= 0 && playerBlockY < 256;
            if (settings.showLightLevel == 1 || settings.showLightLevel == 3) {
                int n2 = playerBlockLightLevel = lightFetchable ? chunk.func_76614_a(EnumSkyBlock.Block, playerBlockX & 0xF, playerBlockY, playerBlockZ & 0xF) : 0;
            }
            if (settings.showLightLevel == 2 || settings.showLightLevel == 3) {
                playerSkyLightLevel = lightFetchable ? chunk.func_76614_a(EnumSkyBlock.Sky, playerBlockX & 0xF, playerBlockY, playerBlockZ & 0xF) : 15;
            }
            underText.add(I18n.func_135052_a((String)"gui.xaero_light_value", (Object[])new Object[]{Math.max(playerBlockLightLevel, playerSkyLightLevel)}));
        }
        if (settings.showTime != 0) {
            long totalTime = 6000L + this.mc.field_71441_e.func_72820_D();
            int dayNumber = (int)(totalTime / 24000L) + 1;
            int dayTimeSinceMidnight = (int)(totalTime % 24000L);
            int timeHours = dayTimeSinceMidnight / 1000;
            int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
            if ((settings.showTime - 1) % 2 == 0) {
                if (settings.showTime < 3) {
                    underText.add(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes));
                } else {
                    underText.add(String.format("%02d:%02d", timeHours, minutes));
                }
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                if (settings.showTime < 3) {
                    underText.add(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
                } else {
                    underText.add(String.format("%02d:%02d %s", timeHours, minutes, half));
                }
            }
        }
        if (minimap.getMinimapWriter().debugTotalTime) {
            underText.add(String.format("Min Time %d", minimap.getMinimapWriter().minTimeDebug));
            underText.add(String.format("Average %d", minimap.getMinimapWriter().averageTimeDebug));
            underText.add(String.format("Max Time %d", minimap.getMinimapWriter().maxTimeDebug));
        }
        if (settings.showAngles) {
            underText.add(String.format("%.1f / %.1f", Float.valueOf(MathHelper.func_76142_g((float)this.mc.field_71451_h.field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)this.mc.field_71451_h.field_70125_A))));
        }
        if (settings.lightOverlayType > 0) {
            underText.add(I18n.func_135052_a((String)"gui.xaero_light_overlay_status", (Object[])new Object[0]));
        }
        this.drawTextUnderMinimap(underText, scaledX, scaledY, height, size, mapScale, settings);
        GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
    }

    private void addLineWordsUnderMinimap(ArrayList<String> underText, int size, String line) {
        if (this.mc.field_71466_p.func_78256_a(line) <= size) {
            underText.add(line);
        } else {
            String[] words = line.split(" ");
            StringBuilder lineBuilder = new StringBuilder();
            for (int i = 0; i < words.length; ++i) {
                int lineWidth;
                int wordStart = lineBuilder.length();
                if (i > 0) {
                    lineBuilder.append(' ');
                }
                lineBuilder.append(words[i]);
                if (i == 0 || (lineWidth = this.mc.field_71466_p.func_78256_a(lineBuilder.toString())) <= size) continue;
                lineBuilder.delete(wordStart, lineBuilder.length());
                underText.add(lineBuilder.toString());
                lineBuilder.delete(0, lineBuilder.length());
                lineBuilder.append(words[i]);
            }
            underText.add(lineBuilder.toString());
        }
    }

    private void drawArrow(float angle, double arrowX, double arrowY, float r, float g, float b, float a, ModSettings settings) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)arrowX, (double)arrowY, (double)0.0);
        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)(0.5 * settings.arrowScale), (double)(0.5 * settings.arrowScale), (double)1.0);
        int offsetY = -6;
        int h = 28;
        int ty = 0;
        GL11.glTranslated((double)-13.0, (double)offsetY, (double)0.0);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        this.mc.field_71456_v.func_73729_b(0, 0, 49, ty, 26, h);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawTextUnderMinimap(ArrayList<String> underText, int scaledX, int scaledY, int height, int size, float mapScale, ModSettings settings) {
        int interfaceSize = size;
        int scaledHeight = (int)((float)height * mapScale);
        GL11.glDisable((int)2929);
        int align = settings.minimapTextAlign;
        for (int i = 0; i < underText.size(); ++i) {
            String s = underText.get(i);
            int stringWidth = this.mc.field_71466_p.func_78256_a(s);
            boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
            int stringY = scaledY + (under ? interfaceSize : -9) + i * 10 * (under ? 1 : -1);
            int stringX = scaledX + (align == 0 ? interfaceSize / 2 - stringWidth / 2 : (align == 1 ? 6 : interfaceSize - 6 - stringWidth));
            Minecraft.func_71410_x().field_71466_p.func_78261_a(s, stringX, stringY, -1);
        }
        underText.clear();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    private float getSunBrightness() {
        return MathHelper.func_76131_a((float)this.mc.field_71441_e.getSunBrightnessFactor(1.0f), (float)0.0f, (float)1.0f);
    }
}

