/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.world;

import codechicken.lib.world.WorldExtension;
import codechicken.lib.world.WorldExtensionInstantiator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WorldExtensionManager {
    private static boolean initialised;
    private static final ArrayList<WorldExtensionInstantiator> extensionIntialisers;
    private static final HashMap<Integer, WorldExtension[]> worldMap;
    private static final WorldExtension[] empty;

    public static void registerWorldExtension(WorldExtensionInstantiator init) {
        if (!initialised) {
            WorldExtensionManager.init();
        }
        init.instantiatorID = extensionIntialisers.size();
        extensionIntialisers.add(init);
    }

    private static void init() {
        initialised = true;
        MinecraftForge.EVENT_BUS.register((Object)new WorldExtensionEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new WorldExtensionEventHandler());
    }

    private static WorldExtension[] getExtensions(World world) {
        if (world != null && WorldExtensionManager.hasExtensions(world)) {
            return worldMap.get(world.field_73011_w.field_76574_g);
        }
        return empty;
    }

    public static WorldExtension getWorldExtension(World world, int instantiatorID) {
        return WorldExtensionManager.getExtensions(world)[instantiatorID];
    }

    private static boolean hasExtensions(World world) {
        return world == null || worldMap.containsKey(world.field_73011_w.field_76574_g);
    }

    private static void onWorldLoad(World world) {
        WorldExtension[] extensions = new WorldExtension[extensionIntialisers.size()];
        for (int i = 0; i < extensions.length; ++i) {
            extensions[i] = extensionIntialisers.get(i).createWorldExtension(world);
        }
        worldMap.put(world.field_73011_w.field_76574_g, extensions);
        for (WorldExtension extension : extensions) {
            extension.load();
        }
    }

    private static void createChunkExtension(World world, Chunk chunk) {
        WorldExtension[] extensions = WorldExtensionManager.getExtensions(world);
        for (int i = 0; i < extensionIntialisers.size(); ++i) {
            if (extensions[i].containsChunk(chunk)) continue;
            extensions[i].addChunk(extensionIntialisers.get(i).createChunkExtension(chunk, extensions[i]));
        }
    }

    private static void removeChunk(World world, Chunk chunk) {
        for (WorldExtension extension : WorldExtensionManager.getExtensions(world)) {
            extension.remChunk(chunk);
        }
    }

    private static void preTick(World world) {
        for (WorldExtension extension : WorldExtensionManager.getExtensions(world)) {
            extension.preTick();
        }
    }

    private static void postTick(World world) {
        for (WorldExtension extension : WorldExtensionManager.getExtensions(world)) {
            extension.postTick();
        }
    }

    static {
        extensionIntialisers = new ArrayList();
        worldMap = new HashMap();
        empty = new WorldExtension[0];
    }

    public static class WorldExtensionEventHandler {
        @SubscribeEvent
        public void onChunkDataLoad(ChunkDataEvent.Load event) {
            if (!WorldExtensionManager.hasExtensions(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            WorldExtensionManager.createChunkExtension(event.world, event.getChunk());
            for (WorldExtension extension : WorldExtensionManager.getExtensions(event.world)) {
                extension.loadChunkData(event.getChunk(), event.getData());
            }
        }

        @SubscribeEvent
        public void onChunkDataSave(ChunkDataEvent.Save event) {
            for (WorldExtension extension : WorldExtensionManager.getExtensions(event.world)) {
                extension.saveChunkData(event.getChunk(), event.getData());
            }
            if (!event.getChunk().field_76636_d) {
                WorldExtensionManager.removeChunk(event.world, event.getChunk());
            }
        }

        @SubscribeEvent
        public void onChunkLoad(ChunkEvent.Load event) {
            if (!WorldExtensionManager.hasExtensions(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            WorldExtensionManager.createChunkExtension(event.world, event.getChunk());
            for (WorldExtension extension : WorldExtensionManager.getExtensions(event.world)) {
                extension.loadChunk(event.getChunk());
            }
        }

        @SubscribeEvent
        public void onChunkUnLoad(ChunkEvent.Unload event) {
            if (event.getChunk() instanceof EmptyChunk) {
                return;
            }
            for (WorldExtension extension : WorldExtensionManager.getExtensions(event.world)) {
                extension.unloadChunk(event.getChunk());
            }
            if (event.world.field_72995_K) {
                WorldExtensionManager.removeChunk(event.world, event.getChunk());
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (WorldExtensionManager.hasExtensions(event.world)) {
                for (WorldExtension extension : WorldExtensionManager.getExtensions(event.world)) {
                    extension.save();
                }
            }
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (!WorldExtensionManager.hasExtensions(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
        }

        @SubscribeEvent
        public void onWorldUnLoad(WorldEvent.Unload event) {
            if (WorldExtensionManager.hasExtensions(event.world)) {
                for (WorldExtension extension : (WorldExtension[])worldMap.remove(event.world.field_73011_w.field_76574_g)) {
                    extension.unload();
                }
            }
        }

        @SubscribeEvent
        public void onChunkWatch(ChunkWatchEvent.Watch event) {
            Chunk chunk = event.player.field_70170_p.func_72964_e(event.chunk.field_77276_a, event.chunk.field_77275_b);
            for (WorldExtension extension : WorldExtensionManager.getExtensions(event.player.field_70170_p)) {
                extension.watchChunk(chunk, event.player);
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onChunkUnWatch(ChunkWatchEvent.UnWatch event) {
            Chunk chunk = event.player.field_70170_p.func_72964_e(event.chunk.field_77276_a, event.chunk.field_77275_b);
            for (WorldExtension extension : WorldExtensionManager.getExtensions(event.player.field_70170_p)) {
                extension.unwatchChunk(chunk, event.player);
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void clientTick(TickEvent.ClientTickEvent event) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (WorldExtensionManager.hasExtensions((World)world)) {
                if (event.phase == TickEvent.Phase.START) {
                    WorldExtensionManager.preTick((World)world);
                } else {
                    WorldExtensionManager.postTick((World)world);
                }
            }
        }

        @SubscribeEvent
        public void serverTick(TickEvent.WorldTickEvent event) {
            if (!WorldExtensionManager.hasExtensions(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            if (event.phase == TickEvent.Phase.START) {
                WorldExtensionManager.preTick(event.world);
            } else {
                WorldExtensionManager.postTick(event.world);
            }
        }
    }
}

