/*
 * Decompiled with CFR 0.152.
 */
package ru.stepan1404.dailyrewards.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import ru.stepan1404.dailyrewards.client.event.JoinToServerEvent;
import ru.stepan1404.dailyrewards.client.gui.GuiReward;
import ru.stepan1404.dailyrewards.client.key.KeyBindings;
import ru.stepan1404.dailyrewards.client.util.OperationController;
import ru.stepan1404.dailyrewards.client.util.RenderUtils;

public class GuiIngameNotification
extends Gui {
    private static GuiIngameNotification instance;
    private final int border;
    private int y1;
    private int y2;
    private boolean isRenderNotification;
    private NotificationType type;
    private Thread controller;

    public GuiIngameNotification() {
        this.border = 5;
        this.y1 = -32 + this.border;
        this.y2 = this.border;
        this.isRenderNotification = false;
        this.type = NotificationType.NEW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GuiIngameNotification getInstance() {
        GuiIngameNotification localInstance = instance;
        if (localInstance != null) return localInstance;
        Class<GuiIngameNotification> clazz = GuiIngameNotification.class;
        synchronized (GuiIngameNotification.class) {
            localInstance = instance;
            if (localInstance != null) return localInstance;
            instance = new GuiIngameNotification();
            return instance;
        }
    }

    public boolean hasController() {
        return this.controller != null && this.controller.isAlive();
    }

    public void initController() {
        if (this.controller == null || !this.controller.isAlive()) {
            this.controller = new Thread((Runnable)new GuiIngameNotificationController(instance), "Notification Controller");
            this.controller.start();
        }
    }

    public boolean isHide() {
        return this.y2 == 0;
    }

    public void setRenderNotification(boolean flag) {
        this.isRenderNotification = flag;
    }

    public boolean isRenderNotification() {
        return this.isRenderNotification;
    }

    public void setNotificationType(NotificationType type) {
        this.type = type;
    }

    public NotificationType getNotificationType() {
        return this.type;
    }

    public void showStep() {
        if (this.y2 < 32 + this.border) {
            ++this.y1;
            ++this.y2;
        }
    }

    public void draw() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledResolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        Color color = new Color(0, 0, 0, 150);
        int x1 = scaledResolution.func_78326_a() - this.border - mc.field_71466_p.func_78256_a(this.type.toString()) - 16 - 18;
        int x2 = scaledResolution.func_78326_a() - this.border;
        this.func_146258_c();
        RenderUtils.drawColorRect(x1, this.y1, x2, this.y2, color);
        int height = this.y2 - this.y1;
        int itemX = height / 2 - 9;
        int itemY = this.y1 + (height / 2 - 9);
        RenderUtils.drawItemStackAndOverlayTexture(this.type.getItemStack(), x1 + itemX, itemY);
        int textX = x1 + itemX + 16 + 4;
        int textY = itemY + 8 - mc.field_71466_p.field_78288_b / 2 + 1;
        color = new Color(0, 0, 0, 255);
        RenderUtils.drawString(this.type.toString(), textX, textY, 1.0f, color);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
    }

    public void hideStep() {
        if (this.y2 > 0) {
            --this.y1;
            --this.y2;
        }
    }

    private void func_146258_c() {
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glViewport((int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.func_78326_a(), (double)scaledresolution.func_78328_b(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
    }

    public static enum NotificationType {
        NEW(new ItemStack(Items.field_151045_i), ""),
        STOP(new ItemStack(Items.field_151132_bS), "");

        private final ItemStack item;
        private String message;

        private NotificationType(ItemStack item, String message) {
            this.item = item;
            this.message = message;
        }

        public ItemStack getItemStack() {
            return this.item;
        }

        public String toString() {
            return this.message;
        }

        public void setMessage(String value) {
            this.message = value;
        }

        public static void reloadMessages() {
            String keyName;
            int code = KeyBindings.getStartKey().func_151463_i();
            String msg = "dailyrewards.notification.new";
            boolean founded = false;
            for (KeyBinding bind : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
                if (bind.func_151463_i() != code) continue;
                if (!founded) {
                    founded = true;
                    continue;
                }
                msg = "dailyrewards.notification.new_change";
                break;
            }
            try {
                keyName = GameSettings.func_74298_c((int)code);
            }
            catch (Throwable t) {
                keyName = "<UNKNOWN>";
            }
            NEW.setMessage(StatCollector.func_74837_a((String)msg, (Object[])new Object[]{keyName}));
            STOP.setMessage(StatCollector.func_74838_a((String)"dailyrewards.notification.stop"));
        }
    }

    private static class GuiIngameNotificationController
    implements Runnable {
        private final GuiIngameNotification gui;
        private final Minecraft mc;

        public GuiIngameNotificationController(GuiIngameNotification gui) {
            this.gui = gui;
            this.mc = Minecraft.func_71410_x();
        }

        @Override
        public void run() {
            OperationController controller = new OperationController(60);
            while (this.gui.isRenderNotification()) {
                controller.updateLastTickTime();
                if (Minecraft.func_71382_s()) {
                    if (JoinToServerEvent.isRewardAvailable()) {
                        switch (JoinToServerEvent.getRenderType()) {
                            case FIRST: {
                                if (!this.mc.field_71415_G) {
                                    this.gui.hideStep();
                                    break;
                                }
                                if (this.gui.isRenderNotification()) {
                                    this.gui.showStep();
                                    break;
                                }
                                this.gui.hideStep();
                            }
                        }
                    }
                    if (instance.getNotificationType() == NotificationType.STOP) {
                        if (this.mc.field_71462_r instanceof GuiReward) {
                            if (GuiReward.isRenderReward()) {
                                this.gui.showStep();
                            } else {
                                this.gui.hideStep();
                                if (this.gui.isHide()) {
                                    this.gui.setRenderNotification(false);
                                }
                            }
                        } else {
                            this.gui.hideStep();
                            if (this.gui.isHide()) {
                                this.gui.setRenderNotification(false);
                            }
                        }
                    }
                }
                try {
                    long i = controller.calculateSleepTime();
                    if (i < 0L) continue;
                    Thread.sleep(i);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

