/*
 * Decompiled with CFR 0.152.
 */
package ru.stepan1404.dailyrewards.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import ru.stepan1404.dailyrewards.client.event.JoinToServerEvent;
import ru.stepan1404.dailyrewards.client.gui.GuiIngameNotification;
import ru.stepan1404.dailyrewards.client.gui.GuiReward;
import ru.stepan1404.dailyrewards.client.gui.RenderType;
import ru.stepan1404.dailyrewards.client.util.RewardUtilsClient;

public class RewardMessage
implements IMessage {
    private byte renderType;
    private List<ItemStack> items = new ArrayList<ItemStack>();
    private byte totalDays;
    private Map<Integer, ItemStack> stats = new HashMap<Integer, ItemStack>();
    private List<RewardUtilsClient.Rarity> raritiesClient = new ArrayList<RewardUtilsClient.Rarity>();

    public void fromBytes(ByteBuf buf) {
        int i;
        for (RewardUtilsClient.Rarity rarity : RewardUtilsClient.Rarity.values()) {
            int minBound = buf.readInt();
            rarity.setMinBound(minBound);
        }
        this.renderType = buf.readByte();
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.items.add(ByteBufUtils.readItemStack((ByteBuf)buf));
        }
        for (i = 0; i < size; ++i) {
            String rarityName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.raritiesClient.add(RewardUtilsClient.Rarity.valueOf(rarityName));
        }
        this.totalDays = buf.readByte();
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            int day = buf.readInt();
            ItemStack item = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.stats.put(day, item);
        }
    }

    public void toBytes(ByteBuf buf) {
    }

    public static class Handler
    implements IMessageHandler<RewardMessage, IMessage> {
        public IMessage onMessage(RewardMessage message, MessageContext ctx) {
            RenderType type = RenderType.values()[message.renderType];
            JoinToServerEvent.setRenderType(type);
            if (JoinToServerEvent.getRenderType() == RenderType.FIRST) {
                GuiIngameNotification.getInstance().setNotificationType(GuiIngameNotification.NotificationType.NEW);
                GuiIngameNotification.getInstance().setRenderNotification(true);
                GuiIngameNotification.getInstance().initController();
            }
            JoinToServerEvent.setRewardAvailable(true);
            GuiReward.setItems(message.items);
            GuiReward.setRarities(message.raritiesClient);
            GuiReward.setTotalDays(message.totalDays);
            GuiReward.setStats(message.stats);
            return null;
        }
    }
}

