/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.grimoire.common.api;

import com.google.common.collect.ImmutableList;
import io.github.crucible.grimoire.common.GrimoireCore;
import io.github.crucible.grimoire.common.api.eventbus.CoreEventBus;
import io.github.crucible.grimoire.common.api.events.GrimoireEvent;
import io.github.crucible.grimoire.common.api.grimmix.IGrimmix;
import io.github.crucible.grimoire.common.api.grimmix.lifecycle.LoadingStage;
import io.github.crucible.grimoire.common.api.integration.IModIntegrationRegistry;
import io.github.crucible.grimoire.common.api.lib.Environment;
import io.github.crucible.grimoire.common.api.mixin.ConfigurationType;
import io.github.crucible.grimoire.common.api.mixin.IMixinConfiguration;
import io.github.crucible.grimoire.common.core.GrimmixLoader;
import io.github.crucible.grimoire.common.core.MixinConfiguration;
import io.github.crucible.grimoire.common.core.VersionHandler;
import io.github.crucible.grimoire.common.integration.ModIntegrationRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class GrimoireAPI {
    public static final CoreEventBus<GrimoireEvent> EVENT_BUS = CoreEventBus.create(GrimoireEvent.class, "GrimoireMainBus");

    private GrimoireAPI() {
    }

    public static IMixinConfiguration registerMixinConfiguration(String classpath, ConfigurationType type) {
        return new MixinConfiguration(null, type, classpath, false);
    }

    public static List<IMixinConfiguration> registerMixinConfigurations(ConfigurationType type, String ... classpaths) {
        ArrayList<IMixinConfiguration> list = new ArrayList<IMixinConfiguration>();
        for (String path : classpaths) {
            list.add(GrimoireAPI.registerMixinConfiguration(path, type));
        }
        return list;
    }

    public static boolean isGrimmixLoaded(String id) {
        for (IGrimmix grimmix : GrimmixLoader.INSTANCE.getAllActiveContainers()) {
            if (!grimmix.getID().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static Optional<IGrimmix> getGrimmix(String id) {
        for (IGrimmix grimmix : GrimmixLoader.INSTANCE.getAllActiveContainers()) {
            if (!grimmix.getID().equals(id)) continue;
            return Optional.of(grimmix);
        }
        return Optional.empty();
    }

    public static List<IGrimmix> getLoadedGrimmixes() {
        return GrimmixLoader.INSTANCE.getAllActiveContainers();
    }

    public static List<IMixinConfiguration> getUnclaimedConfigurations() {
        return MixinConfiguration.getUnclaimedConfigurations();
    }

    public static List<IMixinConfiguration> getAllConfigurations(ConfigurationType ofType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        GrimoireAPI.getUnclaimedConfigurations().forEach(configuration -> {
            if (configuration.getConfigurationType() == ofType) {
                builder.add(configuration);
            }
        });
        for (IGrimmix grimmix : GrimoireAPI.getLoadedGrimmixes()) {
            grimmix.getOwnedConfigurations().forEach(configuration -> {
                if (configuration.getConfigurationType() == ofType) {
                    builder.add(configuration);
                }
            });
        }
        return builder.build();
    }

    public static List<IMixinConfiguration> getAllConfigurations() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(GrimoireAPI.getUnclaimedConfigurations());
        for (IGrimmix grimmix : GrimoireAPI.getLoadedGrimmixes()) {
            builder.addAll(grimmix.getOwnedConfigurations());
        }
        return builder.build();
    }

    public static boolean isModLoaded(String modID) {
        if (GrimmixLoader.INSTANCE.getInternalStage() != LoadingStage.FINAL) {
            return false;
        }
        return VersionHandler.instance().isModLoaded(modID);
    }

    public static IModIntegrationRegistry getModIntegrationRegistry() {
        return ModIntegrationRegistry.INSTANCE;
    }

    public static Environment getEnvironment() {
        return GrimoireCore.INSTANCE.getEnvironment();
    }

    public static boolean isDevEnvironment() {
        return GrimoireCore.INSTANCE.isDevEnvironment();
    }

    public static boolean isObfuscatedEnvironment() {
        return !GrimoireCore.INSTANCE.isDevEnvironment();
    }

    public static String getMinecraftVersion() {
        return GrimoireCore.INSTANCE.getMCVersion();
    }

    public static File getMinecraftFolder() {
        return GrimoireCore.INSTANCE.getMCLocation();
    }

    public static File getModFolder() {
        return GrimoireCore.INSTANCE.getModFolder();
    }

    public static File getVersionedModFolder() {
        return GrimoireCore.INSTANCE.getVersionedModFolder();
    }

    public static File getDataFolder() {
        return GrimoireCore.INSTANCE.getDataFolder();
    }

    public static LaunchClassLoader getLaunchClassloader() {
        return GrimoireCore.INSTANCE.getClassLoader();
    }

    public static void loadClass(Class<?> theClass) {
        try {
            Class.forName(theClass.getName());
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

