/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.CustomFont;

import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import ru.vizzi.Utils.CustomFont.StringCache;

public class FontContainer {
    private StringCache textFont = null;
    public boolean useCustomFont = true;

    private FontContainer() {
    }

    public FontContainer(String fontType, int fontSize) {
        this(fontType, fontSize, null);
    }

    public FontContainer(String fontType, int fontSize, ResourceLocation resLoc) {
        this.textFont = new StringCache();
        this.textFont.setDefaultFont("Arial", fontSize, true);
        this.useCustomFont = !fontType.equalsIgnoreCase("minecraft");
        try {
            if (!this.useCustomFont || fontType.isEmpty() || fontType.equalsIgnoreCase("default") || resLoc == null) {
                this.textFont.setDefaultFont(fontType, fontSize, true);
            } else {
                this.textFont.setCustomFont(resLoc, fontSize, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public float height() {
        if (this.useCustomFont) {
            return this.textFont.fontHeight;
        }
        return Minecraft.func_71410_x().field_71466_p.field_78288_b;
    }

    public float width(String text) {
        if (this.useCustomFont) {
            return this.textFont.getStringWidth(text);
        }
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
    }

    public FontContainer copy() {
        FontContainer font = new FontContainer();
        font.textFont = this.textFont;
        font.useCustomFont = this.useCustomFont;
        return font;
    }

    public float drawStringWithShadow(String text, float x, float y, int color) {
        float l;
        if (this.useCustomFont) {
            l = this.textFont.renderString(text, x + 1.0f, y + 1.0f, color, true);
            l = Math.max(l, this.textFont.renderString(text, x, y, color, false));
        } else {
            l = Minecraft.func_71410_x().field_71466_p.func_78261_a(text, (int)x, (int)y, color);
        }
        return l;
    }

    public float drawString(String text, float x, float y, int color) {
        if (this.useCustomFont) {
            return this.textFont.renderString(text, x, y, color, false);
        }
        return Minecraft.func_71410_x().field_71466_p.func_78261_a(text, (int)x, (int)y, color);
    }

    public float drawStringShadow(String text, float x, float y, int color, boolean shadowFlag) {
        return this.textFont.renderString(text, x, y, color, shadowFlag);
    }

    public String getName() {
        if (!this.useCustomFont) {
            return "Minecraft";
        }
        return this.textFont.usedFont().getFontName();
    }

    public StringCache getTextFont() {
        return this.textFont;
    }
}

