/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.Validate;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;
import ru.vizzi.Utils.EventLoadResource;
import ru.vizzi.Utils.LibrariesConfig;
import ru.vizzi.Utils.Logger;
import ru.vizzi.Utils.SyncResultHandler;
import ru.vizzi.Utils.databases.DatabaseManager;
import ru.vizzi.Utils.eventhandler.EventLoader;
import ru.vizzi.Utils.obf.IgnoreObf;
import ru.vizzi.Utils.resouces.CoreAPI;
import ru.vizzi.Utils.resouces.TextureLoader;

@IgnoreObf
@Mod(modid="LibrariesCore", name="LibrariesCore", version="1.0.0")
public class LibrariesCore {
    @Mod.Instance(value="LibrariesCore")
    public static LibrariesCore instance;
    @GradleSideOnly(value={GradleSide.CLIENT})
    public TextureLoader textureLoader;
    public static final String MODID = "LibrariesCore";
    public static final String MODNAME = "LibrariesCore";
    public static final String VERSION = "1.0.0";
    private boolean isClient = FMLCommonHandler.instance().getSide().isClient();
    public static final Logger logger;
    private final Thread currentThread = Thread.currentThread();
    private final Queue queue = Queues.newArrayDeque();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LibrariesConfig config = LibrariesConfig.getInstance();
        config.load();
        if (config.DEBUG) {
            logger.setDebug(true);
        }
        SyncResultHandler.setMainThreadExecutor(this::runUsingMainThread);
        if (this.isClient) {
            this.textureLoader = new TextureLoader();
            CoreAPI.init();
        }
        EventLoader eventLoader = new EventLoader();
        eventLoader.onPreInit(event);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (this.isClient) {
            MinecraftForge.EVENT_BUS.post((Event)new EventLoadResource());
        }
        try {
            Class.forName("com.mysql.jdbc.Driver");
            DatabaseManager.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void serverUpdate(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            Queue queue = this.queue;
            synchronized (queue) {
                while (!this.queue.isEmpty()) {
                    ((FutureTask)this.queue.poll()).run();
                }
            }
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent e) {
    }

    @Mod.EventHandler
    public void stopServer(FMLServerStoppingEvent e) {
        if (DatabaseManager.isInit()) {
            DatabaseManager.shutdown();
        }
    }

    public <T> ListenableFuture<T> runUsingMainThread(Runnable runnable) {
        if (this.isClient) {
            return Minecraft.func_71410_x().func_152344_a(runnable);
        }
        return this.runUsingMainThreadServer(runnable);
    }

    public <T> ListenableFuture<T> runUsingMainThread(Callable<T> runnable) {
        if (this.isClient) {
            return Minecraft.func_71410_x().func_152343_a(runnable);
        }
        return this.runUsingMainThreadServer(runnable);
    }

    public boolean getCurrentThread() {
        return Thread.currentThread() == this.currentThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture runUsingMainThreadServer(Callable callable) {
        Validate.notNull((Object)callable);
        if (!this.getCurrentThread()) {
            ListenableFutureTask listenablefuturetask = ListenableFutureTask.create((Callable)callable);
            Queue queue = this.queue;
            synchronized (queue) {
                this.queue.add(listenablefuturetask);
                return listenablefuturetask;
            }
        }
        try {
            return Futures.immediateFuture(callable.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    private ListenableFuture runUsingMainThreadServer(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this.runUsingMainThreadServer(Executors.callable(runnable));
    }

    static {
        logger = new Logger("LibrariesCore");
    }
}

