/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.config.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.json.JSONStringer;
import org.json.JSONWriter;

public class JsonConfigBuilder {
    private final Map<String, Object> map;
    private final Map<String, String> comments;
    private final File file;
    private final boolean rewritePretty;

    public JsonConfigBuilder(File file, Map<String, Object> map, Map<String, String> comments, boolean rewritePretty) {
        this.file = file;
        this.map = map;
        this.comments = comments;
        this.rewritePretty = rewritePretty;
    }

    public void write() {
        try {
            if (!this.file.exists()) {
                this.file.getParentFile().mkdirs();
                if (!this.file.createNewFile()) {
                    return;
                }
            }
            FileWriter writer = new FileWriter(this.file);
            JSONWriter jsonWriter = new JSONWriter(writer).object().key("config").array();
            for (String key : this.map.keySet()) {
                jsonWriter = this.writeElement(jsonWriter, key, this.map.get(key));
            }
            jsonWriter.endArray().endObject();
            ((Writer)writer).flush();
            ((Writer)writer).close();
            if (this.rewritePretty) {
                this.rewritePretty();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JSONWriter writeElement(JSONWriter jsonWriter, String key, Object object) {
        boolean hasComment = this.comments.containsKey(key);
        if (hasComment) {
            jsonWriter = jsonWriter.array();
        }
        if (object instanceof Map) {
            jsonWriter = jsonWriter.object().key(key).array();
            for (Object k : ((Map)object).keySet()) {
                if (!(k instanceof String)) continue;
                jsonWriter = jsonWriter.object().key((String)k).value(((Map)object).get(k)).endObject();
            }
            jsonWriter.endArray().endObject();
        } else {
            jsonWriter = jsonWriter.object().key(key).value(object).endObject();
        }
        if (hasComment) {
            jsonWriter = jsonWriter.object().key("comment").value(JsonConfigBuilder.convertToJson(this.comments.get(key), true)).endObject().endArray();
        }
        return jsonWriter;
    }

    private void rewritePretty() throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
        String json = "";
        while ((line = bufferedReader.readLine()) != null) {
            json = json.concat(line);
        }
        bufferedReader.close();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonElement = jsonParser.parse(json);
        String prettyJsonString = gson.toJson(jsonElement);
        FileWriter writer = new FileWriter(this.file);
        writer.write(prettyJsonString);
        ((Writer)writer).close();
    }

    private static String getPrettyJSON(String json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonElement = jsonParser.parse(json);
        return gson.toJson(jsonElement);
    }

    public static String convertToJson(String string, boolean pretty) {
        JSONWriter jsonWriter = new JSONStringer().object().key("config").array();
        jsonWriter.object().key("").value(string).endObject();
        jsonWriter.endArray().endObject();
        return pretty ? JsonConfigBuilder.getPrettyJSON(jsonWriter.toString()) : jsonWriter.toString();
    }
}

