/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.eventhandler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import ru.vizzi.Utils.LibrariesCore;
import ru.vizzi.Utils.eventhandler.RegistryEvent;

public class EventLoader {
    public void onPreInit(FMLPreInitializationEvent event) {
        for (ASMDataTable.ASMData data : event.getAsmData().getAll(RegistryEvent.class.getName())) {
            try {
                Object obj = Class.forName(data.getClassName()).newInstance();
                boolean hasOreGenEvent = false;
                boolean hasTerrainGenEvent = false;
                boolean hasMinecraftForgeEvent = false;
                boolean hasFMLEvent = false;
                for (String className : this.getEvents(obj)) {
                    if (className.startsWith("net.minecraftforge.event.terraingen")) {
                        if (className.startsWith("net.minecraftforge.event.terraingen.OreGenEvent")) {
                            hasOreGenEvent = true;
                            continue;
                        }
                        if (!className.startsWith("net.minecraftforge.event.terraingen.PopulateChunkEvent")) continue;
                        if (className.equals("net.minecraftforge.event.terraingen.PopulateChunkEvent$PopulateChunkEvent.Populate")) {
                            hasTerrainGenEvent = true;
                            continue;
                        }
                        hasMinecraftForgeEvent = true;
                        continue;
                    }
                    if (className.startsWith("cpw.mods.fml.common")) {
                        hasFMLEvent = true;
                        continue;
                    }
                    hasMinecraftForgeEvent = true;
                }
                if (hasOreGenEvent) {
                    MinecraftForge.ORE_GEN_BUS.register(obj);
                    LibrariesCore.logger.debug("Class %s successful registered in MinecraftForge.ORE_GEN_BUS event bus", data.getClassName());
                }
                if (hasTerrainGenEvent) {
                    MinecraftForge.TERRAIN_GEN_BUS.register(obj);
                    LibrariesCore.logger.debug("Class %s successful registered in MinecraftForge.TERRAIN_GEN_BUS event bus", data.getClassName());
                }
                if (hasMinecraftForgeEvent) {
                    MinecraftForge.EVENT_BUS.register(obj);
                    LibrariesCore.logger.debug("Class %s successful registered in MinecraftForge.EVENT_BUS event bus", data.getClassName());
                }
                if (!hasFMLEvent) continue;
                FMLCommonHandler.instance().bus().register(obj);
                LibrariesCore.logger.debug("Class %s successful registered in FMLCommonHandler.instance().bus() event bus", data.getClassName());
            }
            catch (Exception error) {
                LibrariesCore.logger.debug("Cannot register event listener for %s class:\n%s", data.getClassName(), error.getStackTrace());
            }
        }
    }

    private ArrayList<String> getEvents(Object handler) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Class<?> error = handler.getClass();
            for (Method method : error.getDeclaredMethods()) {
                Parameter param;
                if (!method.isAnnotationPresent(SubscribeEvent.class) || method.getParameterCount() != 1 || !Event.class.isAssignableFrom((param = method.getParameters()[0]).getType())) continue;
                result.add(param.getType().getName());
            }
        }
        catch (Exception var9) {
            var9.printStackTrace();
        }
        return result;
    }
}

