/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;
import ru.vizzi.Utils.CustomFont.FontContainer;
import ru.vizzi.Utils.gui.drawmodule.GuiUtils;

@SideOnly(value=Side.CLIENT)
public class GuiTextFieldV
extends Gui {
    public float xPosition;
    public float yPosition;
    public float width;
    public float height;
    public String text = "";
    public String backgroundText;
    public int maxStringLength;
    public float maxSplitLength;
    public int colorBackground;
    public int colorText;
    public int colorTextActive;
    public float scaleText;
    private boolean focused;
    public FontContainer font;
    private boolean visible = true;
    private boolean enabled = true;

    public GuiTextFieldV(float x, float y, float w, float h) {
        this.xPosition = x;
        this.yPosition = y;
        this.width = w;
        this.height = h;
    }

    public void render() {
        GuiUtils.drawRectS(this.xPosition, this.yPosition, this.width, this.height, this.colorBackground, 1.0);
        if (this.text.equals("")) {
            String renderText = this.backgroundText;
            int renderColor = this.colorText;
        } else {
            String renderText = this.text + "_";
            int renderColor = this.colorTextActive;
        }
    }

    public void writeText(String text, int key) {
        if (this.focused) {
            switch (key) {
                case 14: {
                    this.deleteWord(1);
                    break;
                }
                default: {
                    if (this.text.length() >= this.maxStringLength) break;
                    this.text = this.text + ChatAllowedCharacters.func_71565_a((String)text);
                }
            }
        }
    }

    public void deleteWord(int size) {
        if (Keyboard.isKeyDown((int)42)) {
            this.text = "";
            return;
        }
        if (this.text.length() > 0) {
            String s;
            this.text = s = this.text.substring(0, this.text.length() - size);
        }
    }

    public void setText(String text) {
        this.text = text.length() > this.maxStringLength ? text.substring(0, this.maxStringLength) : text;
    }

    public void setBackgroundText(String text) {
        this.backgroundText = text;
    }

    public void mouseClicked(int x, int y, int button) {
        if (button == 0) {
            this.focused = this.enabled && this.visible && (float)x >= this.xPosition && (float)y >= this.yPosition && (float)x < this.xPosition + this.width && (float)y < this.yPosition + this.height;
        }
    }

    public float getXPosition() {
        return this.xPosition;
    }

    public float getYPosition() {
        return this.yPosition;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public String getText() {
        return this.text;
    }

    public String getBackgroundText() {
        return this.backgroundText;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public float getMaxSplitLength() {
        return this.maxSplitLength;
    }

    public int getColorBackground() {
        return this.colorBackground;
    }

    public int getColorText() {
        return this.colorText;
    }

    public int getColorTextActive() {
        return this.colorTextActive;
    }

    public float getScaleText() {
        return this.scaleText;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public FontContainer getFont() {
        return this.font;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setXPosition(float xPosition) {
        this.xPosition = xPosition;
    }

    public void setYPosition(float yPosition) {
        this.yPosition = yPosition;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public void setMaxSplitLength(float maxSplitLength) {
        this.maxSplitLength = maxSplitLength;
    }

    public void setColorBackground(int colorBackground) {
        this.colorBackground = colorBackground;
    }

    public void setColorText(int colorText) {
        this.colorText = colorText;
    }

    public void setColorTextActive(int colorTextActive) {
        this.colorTextActive = colorTextActive;
    }

    public void setScaleText(float scaleText) {
        this.scaleText = scaleText;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public void setFont(FontContainer font) {
        this.font = font;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

