/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.gui.drawmodule;

public class AnimationHelper {
    private static float animSpeed;
    private static double oldTime;

    public static void updateAnimationSpeed() {
        double newTime = (double)System.nanoTime() / 1.0E9;
        double delta = newTime - oldTime;
        if (oldTime != 0.0) {
            animSpeed = (float)(delta * 40.0);
        }
        oldTime = newTime;
    }

    public static float getAnimationSpeed() {
        return animSpeed;
    }

    public static float updateAnim(float value, float maxValue, float speed) {
        if (value < maxValue) {
            if ((value += animSpeed * speed) > maxValue) {
                value = maxValue;
            }
        } else if (value > maxValue && (value += animSpeed * speed) < maxValue) {
            value = maxValue;
        }
        return value;
    }

    public static float updateSlowEndAnim(float value, float maxValue, float speed, float minSpeed) {
        if (speed > 0.0f) {
            if (value < maxValue) {
                float speed1 = maxValue - value;
                if (speed1 < minSpeed) {
                    speed1 = minSpeed;
                }
                if ((value += animSpeed * speed * speed1) > maxValue) {
                    value = maxValue;
                }
            }
        } else if (value > maxValue) {
            float speed1 = value - maxValue;
            if (speed1 < minSpeed) {
                speed1 = minSpeed;
            }
            if ((value += animSpeed * speed * speed1) < maxValue) {
                value = maxValue;
            }
        }
        return value;
    }

    public static float updateSlowStartAnim(float value, float maxValue, float speed, float minSpeed) {
        if (speed > 0.0f) {
            if (value < maxValue) {
                float speed1 = maxValue - (1.0f - value);
                if (speed1 < minSpeed) {
                    speed1 = minSpeed;
                }
                if ((value += animSpeed * speed * speed1) > maxValue) {
                    value = maxValue;
                }
            }
        } else if (value > maxValue) {
            float speed1 = -(1.0f - value);
            if (speed1 < -minSpeed) {
                speed1 = minSpeed;
            }
            if ((value -= animSpeed * speed * speed1) < maxValue) {
                value = maxValue;
            }
        }
        return value;
    }

    public static float getSlowAnim(float value, float minValue, float maxValue, float speed, float minSpeed) {
        float halfAnim = (maxValue + minValue) / 2.0f;
        float percentage = (value - minValue) / (maxValue - minValue);
        float baseSpeed = speed;
        speed = value > halfAnim ? (speed *= 1.0f - percentage) : (speed *= percentage);
        if (baseSpeed > 0.0f) {
            if (speed < minSpeed) {
                speed = minSpeed;
            }
        } else if (speed > minSpeed) {
            speed = minSpeed;
        }
        if ((value += speed) > maxValue) {
            value = maxValue;
        } else if (value < minValue) {
            value = minValue;
        }
        return value;
    }

    static {
        oldTime = 0.0;
    }
}

