/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.gui.drawmodule;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import ru.vizzi.Utils.CustomFont.EnumStringRenderType;
import ru.vizzi.Utils.CustomFont.FontContainer;
import ru.vizzi.Utils.CustomFont.StringCache;
import ru.vizzi.Utils.gui.drawmodule.GuiUtils;
import ru.vizzi.Utils.gui.drawmodule.ScaleGui;
import ru.vizzi.Utils.resouces.CoreAPI;

public class GuiDrawUtils {
    public static final float DPI = (float)Math.PI * 2;
    private static final Tessellator tessellator = Tessellator.field_78398_a;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final RenderItem renderItem = RenderItem.getInstance();
    private static final List<String> tempList = new ArrayList<String>();
    private static final List<String> tempSplitted = new ArrayList<String>();

    public static void drawRoundedRect(float x, float y, float width, float height, float radius, int color, double aplha) {
        float radiusY = radius;
        float radiusX = radius;
        GL11.glPushMatrix();
        GuiDrawUtils.drawFilledCircle(x + radiusX, y + radiusY, radius, color, aplha);
        GuiDrawUtils.drawRect(x + radiusX, y, x + width - radiusX, y + height, color, aplha);
        GuiDrawUtils.drawRect(x, y + radiusY, x + radiusX, y + height - radiusY, color, aplha);
        GuiDrawUtils.drawFilledCircle(x + radiusX, y + height - radiusY, radius, color, aplha);
        GuiDrawUtils.drawFilledCircle(x + width - radiusX, y + radiusY, radius, color, aplha);
        GuiDrawUtils.drawRect(x + width - radiusX, y + radiusY, x + radiusX, y + height - radiusY, color, aplha);
        GuiDrawUtils.drawRect(x + width - radiusX, y + radiusY, x + width, y + height - radiusY, color, aplha);
        GuiDrawUtils.drawFilledCircle(x + width - radiusX, y + height - radiusY, radius, color, aplha);
        GL11.glPopMatrix();
    }

    public static void drawRect(ResourceLocation textureLocation, double x, double y, double width, double height, float r, float g, float b, float a) {
        CoreAPI.bindTexture(textureLocation);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(r, g, b, a);
        tessellator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawRect(ResourceLocation textureLocation, double x, double y, double width, double height) {
        CoreAPI.bindTexture(textureLocation);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawFilledCircle(float x, float y, float radius, int color, double alpha) {
        float f2 = (float)(color & 0xFF) / 255.0f;
        int triangleAmount = 50;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GuiUtils.renderColor(color, alpha);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(6);
        tessellator.func_78377_a((double)x, (double)y, 0.0);
        for (int i = 0; i <= triangleAmount; ++i) {
            float angle = (float)((double)((float)Math.PI * 2 * (float)i / (float)triangleAmount) + Math.toRadians(180.0));
            tessellator.func_78377_a((double)(x + MathHelper.func_76126_a((float)angle) * radius), (double)(y + MathHelper.func_76134_b((float)angle) * radius), 0.0);
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private static void drawRect(double x, double y, double width, double height, int color, double alpha) {
        double j1;
        if (x < width) {
            j1 = x;
            x = width;
            width = j1;
        }
        if (y < height) {
            j1 = y;
            y = height;
            height = j1;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GuiUtils.renderColor(color, alpha);
        tessellator.func_78382_b();
        tessellator.func_78377_a(x, height, 0.0);
        tessellator.func_78377_a(width, height, 0.0);
        tessellator.func_78377_a(width, y, 0.0);
        tessellator.func_78377_a(x, y, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawString(FontContainer fontType, String string, float x, float y, float scale, int color) {
        GuiDrawUtils.drawStringNoScale(fontType, string, ScaleGui.get(x), ScaleGui.get(y), ScaleGui.get(scale), color);
    }

    public static void drawStringNoScaleGui(FontContainer fontType, String string, float x, float y, float scale, int color) {
        GuiDrawUtils.drawStringNoScale(fontType, string, x, y, scale, color);
    }

    public static void drawCenteredString(FontContainer fontType, String string, float x, float y, float scale, int color) {
        FontContainer fontContainer = fontType;
        scale = ScaleGui.get(scale);
        GuiDrawUtils.drawStringNoScale(fontContainer, string, ScaleGui.get(x) - fontContainer.width(string) * scale / 2.0f, ScaleGui.get(y), scale, color);
    }

    public static void drawStringNoXYScale(FontContainer fontType, String string, float x, float y, float scale, int color) {
        scale = ScaleGui.get(scale);
        GuiDrawUtils.drawStringNoScale(fontType, string, x, y, scale, color);
    }

    public static void drawRightStringNoXYScale(FontContainer fontType, String string, float x, float y, float scale, int color) {
        FontContainer fontContainer = fontType;
        scale = ScaleGui.get(scale);
        GuiDrawUtils.drawStringNoScale(fontContainer, string, x - fontContainer.width(string) * scale, y, scale, color);
    }

    public static void drawCenteredStringNoXYScale(FontContainer fontType, String string, float x, float y, float scale, int color) {
        FontContainer fontContainer = fontType;
        scale = ScaleGui.get(scale);
        GuiDrawUtils.drawStringNoScale(fontContainer, string, x - fontContainer.width(string) * scale / 2.0f, y, scale, color);
    }

    public static void drawCenteredStringCenterX(FontContainer fontContainer, String string, float x, float y, float scale, int color) {
        scale = ScaleGui.get(scale);
        GuiDrawUtils.drawStringNoScale(fontContainer, string, ScaleGui.getCenterX(x) - fontContainer.width(string) * scale / 2.0f, ScaleGui.get(y), scale, color);
    }

    public static void drawCenteredStringCenter(FontContainer fontContainer, String string, float x, float y, float scale, int color) {
        scale = ScaleGui.get(scale);
        GuiDrawUtils.drawStringNoScale(fontContainer, string, ScaleGui.getCenterX(x) - fontContainer.width(string) * scale / 2.0f, ScaleGui.getCenterY(y), scale, color);
    }

    public static void drawStringCenter(FontContainer fontType, String string, float x, float y, float scale, int color) {
        GuiDrawUtils.drawStringNoScale(fontType, string, ScaleGui.getCenterX(x), ScaleGui.getCenterY(y), ScaleGui.get(scale), color);
    }

    public static void drawStringCenterX(FontContainer fontType, String string, float x, float y, float scale, int color) {
        GuiDrawUtils.drawStringNoScale(fontType, string, ScaleGui.getCenterX(x), ScaleGui.get(y), ScaleGui.get(scale), color);
    }

    public static void drawStringCenterYRight(FontContainer fontType, String string, float x, float y, float scale, int color) {
        GuiDrawUtils.drawStringNoScale(fontType, string, ScaleGui.getRight(x), ScaleGui.getCenterY(y), ScaleGui.get(scale), color);
    }

    public static void drawRightStringCenter(FontContainer fontContainer, String string, float x, float y, float scale, int color) {
        scale = ScaleGui.get(scale);
        GuiDrawUtils.drawStringNoScale(fontContainer, string, ScaleGui.getCenterX(x) - fontContainer.width(string) * scale, ScaleGui.getCenterY(y), scale, color);
    }

    public static void drawRightString(FontContainer fontContainer, String string, float x, float y, float scale, int color) {
        scale = ScaleGui.get(scale);
        GuiDrawUtils.drawStringNoScale(fontContainer, string, ScaleGui.get(x) - fontContainer.width(string) * scale, ScaleGui.get(y), scale, color);
    }

    public static void drawStringCenterXBot(FontContainer fontType, String string, float x, float y, float scale, int color) {
        GuiDrawUtils.drawStringNoScale(fontType, string, ScaleGui.getCenterX(x), ScaleGui.getBot(y), ScaleGui.get(scale), color);
    }

    public static void drawRightStringCenterXBot(FontContainer fontContainer, String string, float x, float y, float scale, int color) {
        scale = ScaleGui.get(scale);
        GuiDrawUtils.drawStringNoScale(fontContainer, string, ScaleGui.getCenterX(x) - fontContainer.width(string) * scale, ScaleGui.getBot(y), scale, color);
    }

    public static void drawRightStringRightBot(FontContainer fontContainer, String string, float x, float y, float scale, int color) {
        scale = ScaleGui.get(scale);
        GuiDrawUtils.drawStringNoScale(fontContainer, string, ScaleGui.getRight(x) - fontContainer.width(string) * scale, ScaleGui.getBot(y), scale, color);
    }

    public static float drawSplittedStringCenter(FontContainer font, String text, float x, float y, float scale, float width, float heightLimit, int color, EnumStringRenderType renderType) {
        return GuiDrawUtils.drawSplittedString(font, text, ScaleGui.getCenterX(x), ScaleGui.getCenterY(y), ScaleGui.get(scale), width, heightLimit, color, renderType);
    }

    public static float drawSplittedStringRightBot(FontContainer font, String text, float x, float y, float scale, float width, float heightLimit, int color, EnumStringRenderType renderType) {
        return GuiDrawUtils.drawSplittedString(font, text, ScaleGui.getRight(x), ScaleGui.getBot(y), ScaleGui.get(scale), width, heightLimit, color, renderType);
    }

    public static float drawSplittedStringCenterXBot(FontContainer font, String text, float x, float y, float scale, float width, float heightLimit, int color) {
        return GuiDrawUtils.drawSplittedString(font, text, ScaleGui.getCenterX(x), ScaleGui.getBot(y), ScaleGui.get(scale), width, heightLimit, color, EnumStringRenderType.DEFAULT);
    }

    public static float drawSplittedRightStringCenterXBot(FontContainer font, String text, float x, float y, float scale, float width, float heightLimit, int color) {
        return GuiDrawUtils.drawSplittedString(font, text, ScaleGui.getCenterX(x), ScaleGui.getBot(y), ScaleGui.get(scale), width, heightLimit, color, EnumStringRenderType.RIGHT);
    }

    public static float drawSplittedStringNoScale(FontContainer font, String text, float x, float y, float scale, float width, float heightLimit, int color, EnumStringRenderType type) {
        return GuiDrawUtils.drawSplittedString(font, text, x, y, ScaleGui.get(scale), width, heightLimit, color, type);
    }

    public static float drawSplittedString(FontContainer fontContainer, String text, float x, float y, float scale, float width, float heightLimit, int color, EnumStringRenderType type) {
        String defaultColor;
        if (text == null) {
            return 0.0f;
        }
        StringCache textFont = fontContainer.getTextFont();
        text = text.replaceAll(String.valueOf('\u00a0'), " ");
        tempList.clear();
        String preColor = defaultColor = "";
        int offset = 0;
        while (text.contains("\n")) {
            int index = text.indexOf("\n");
            String temp = text.substring(offset, index);
            int lastColorIndex = temp.lastIndexOf("\u00a7");
            tempList.add(preColor + temp);
            if (lastColorIndex != -1) {
                preColor = temp.substring(lastColorIndex, lastColorIndex + 2);
            }
            text = preColor + text.replaceFirst("\n", "");
            offset = index;
        }
        tempList.add(preColor + text.substring(offset));
        tempSplitted.clear();
        preColor = defaultColor;
        for (String s : tempList) {
            if (s.length() == 0) {
                tempSplitted.add("");
                continue;
            }
            String string = s;
            while (string.length() > 0) {
                String temp = textFont.trimStringToWidthSaveWords(string, width / scale, false);
                tempSplitted.add(preColor + temp);
                int lastColorIndex = temp.lastIndexOf("\u00a7");
                if (lastColorIndex != -1) {
                    preColor = temp.substring(lastColorIndex, lastColorIndex + 2);
                }
                string = string.replace(temp, "");
            }
        }
        int height = 0;
        for (String s : tempSplitted) {
            GuiDrawUtils.drawStringNoScale(fontContainer, s, x - (type == EnumStringRenderType.DEFAULT ? 0.0f : (type == EnumStringRenderType.RIGHT ? fontContainer.width(s) * scale : fontContainer.width(s) * scale / 2.0f)), y + (float)height, scale, color);
            height = (int)((float)height + fontContainer.height() / 1.25f * scale);
            if (heightLimit == -1.0f || !((float)height >= heightLimit)) continue;
            return height;
        }
        return height;
    }

    public static void drawStringNoScale(FontContainer fontContainer, String string, float x, float y, float scale, int color) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        fontContainer.drawString(string, 0.0f, 0.0f, color);
        GL11.glPopMatrix();
    }

    public static void drawStringNoScaleShadow(FontContainer fontContainer, String string, float x, float y, float scale, int color, boolean shadowFlag) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        fontContainer.drawStringShadow(string, 0.0f, 0.0f, color, shadowFlag);
        GL11.glPopMatrix();
    }

    public static void clearMaskBuffer(float x, float y, float width, float height) {
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL14.glBlendFuncSeparate((int)0, (int)1, (int)0, (int)0);
        GuiDrawUtils.drawRect(x, y, width, height);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
    }

    public static void drawRectXY(double x1, double y1, double x2, double y2) {
        tessellator.func_78382_b();
        tessellator.func_78374_a(x1, y2, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x2, y2, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x2, y1, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(x1, y1, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawRect(double x, double y, double width, double height, float r, float g, float b, float a) {
        tessellator.func_78382_b();
        tessellator.func_78369_a(r, g, b, a);
        tessellator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawRect(double x, double y, double width, double height) {
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawRect(double x, double y, double x1, double y1, double x2, double y2, double x3, double y3, float r, float g, float b, float a) {
        tessellator.func_78382_b();
        tessellator.func_78369_a(r, g, b, a);
        tessellator.func_78374_a(x, y, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x1, y1, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x2, y2, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(x3, y3, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawRecLines(float x, float y, float width, float height) {
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glVertex2f((float)x, (float)y);
        GL11.glEnd();
    }
}

