/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.gui.drawmodule;

import java.awt.Color;
import java.awt.Dimension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import ru.vizzi.Utils.gui.drawmodule.RenderItemNew;
import ru.vizzi.Utils.resouces.CoreAPI;

public class GuiUtils {
    private static Tessellator tessellator = Tessellator.field_78398_a;
    private static RenderItem itemRenderer = new RenderItem();
    private static RenderItemNew itemRendererNew = new RenderItemNew();
    private static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;

    public static <T> void drawCenteredText(double posX, double posY, double scale, int color, T text) {
        GuiUtils.drawText(posX - GuiUtils.getTextWidth(String.valueOf(text), scale) / 2.0, posY, scale, color, text);
    }

    public static <T> void drawCenteredTextWithAlpha(double posX, double posY, double scale, int color, double alpha, T text) {
        GuiUtils.drawTextWithAlpha(posX - GuiUtils.getTextWidth(String.valueOf(text), scale) / 2.0, posY, scale, color, alpha, text);
    }

    public static <T> void drawText(double posX, double posY, double scale, int color, T text) {
        GL11.glPushMatrix();
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        fontRenderer.func_78276_b(String.valueOf(text), (int)(posX / scale), (int)(posY / scale), color);
        GL11.glPopMatrix();
    }

    public static <T> void drawTextWithShadow(double posX, double posY, double scale, int color, T text) {
        GL11.glPushMatrix();
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        fontRenderer.func_78261_a(String.valueOf(text), (int)(posX / scale), (int)(posY / scale), color);
        GL11.glPopMatrix();
    }

    public static <T> void drawSplitText(double posX, double posY, int wrapWidth, double scale, int color, T text) {
        GL11.glPushMatrix();
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        fontRenderer.func_78279_b(String.valueOf(text), (int)(posX / scale), (int)(posY / scale), wrapWidth, color);
        GL11.glPopMatrix();
    }

    public static <T> void drawTextWithAlpha(double posX, double posY, double scale, int color, double alpha, T text) {
        int alphaF = (int)(234.0 * alpha);
        if (alphaF > 234) {
            alphaF = 234;
        }
        if (alphaF < 0) {
            alphaF = 0;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        fontRenderer.func_78276_b(String.valueOf(text), (int)(posX / scale), (int)(posY / scale), color | alphaF + 25 << 24);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static <T> double getTextWidth(T text, double textScale) {
        return (float)fontRenderer.func_78256_a(String.valueOf(text)) * (float)textScale;
    }

    public static double getTextHeight(double textScale) {
        return (float)GuiUtils.fontRenderer.field_78288_b * (float)textScale;
    }

    public static void drawLine(double startX, double startY, double endX, double endY, double lineWidth, int zLevel, int color, double alpha) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glLineWidth((float)((float)lineWidth));
        GuiUtils.renderColor(color, alpha);
        tessellator.func_78371_b(1);
        tessellator.func_78377_a(startX, startY, (double)zLevel);
        tessellator.func_78377_a(endX, endY, (double)zLevel);
        tessellator.func_78381_a();
        GuiUtils.renderColor(0xFFFFFF, 1.0);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawGradientLine(double startX, double startY, double endX, double endY, double lineWidth, int zLevel, int color1, int color2, double alpha, double alpha2) {
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(color2 & 0xFF) / 255.0f;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glLineWidth((float)((float)lineWidth));
        tessellator.func_78371_b(1);
        tessellator.func_78369_a(f1, f2, f3, (float)alpha);
        tessellator.func_78377_a(startX, startY, (double)zLevel);
        tessellator.func_78369_a(f4, f5, f6, (float)alpha2);
        tessellator.func_78377_a(endX, endY, (double)zLevel);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawRectS(double posX, double posY, double endX, double endY, int color, double alpha) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        GuiUtils.renderColor(color, alpha);
        tessellator.func_78382_b();
        tessellator.func_78377_a(posX, posY + endY, 0.0);
        tessellator.func_78377_a(posX + endX, posY + endY, 0.0);
        tessellator.func_78377_a(posX + endX, posY, 0.0);
        tessellator.func_78377_a(posX, posY, 0.0);
        tessellator.func_78381_a();
        GuiUtils.renderColor(0xFFFFFF, 1.0);
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawRectS(double posX, double posY, double posX1, double posX2, double posY2, double posX3, int color, double alpha) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        GuiUtils.renderColor(color, alpha);
        tessellator.func_78382_b();
        tessellator.func_78377_a(posX2, posY2, 0.0);
        tessellator.func_78377_a(posX3, posY2, 0.0);
        tessellator.func_78377_a(posX1, posY, 0.0);
        tessellator.func_78377_a(posX, posY, 0.0);
        tessellator.func_78381_a();
        GuiUtils.renderColor(0xFFFFFF, 1.0);
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawGradientRectS(double posX, double posY, double endX, double endY, int color1, int color2, double alpha, double alpha2) {
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(color2 & 0xFF) / 255.0f;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, (float)alpha);
        tessellator.func_78377_a(posX, posY + endY, 0.0);
        tessellator.func_78377_a(posX + endX, posY + endY, 0.0);
        tessellator.func_78369_a(f4, f5, f6, (float)alpha2);
        tessellator.func_78377_a(posX + endX, posY, 0.0);
        tessellator.func_78377_a(posX, posY, 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawCircle(double posX, double posY, double radius, int color, double alpha) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2881);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glHint((int)3155, (int)4354);
        GuiUtils.renderColor(color, alpha);
        tessellator.func_78371_b(9);
        for (int i = 0; i <= 360; ++i) {
            double x = Math.sin((double)i * 3.141526 / 180.0) * radius;
            double y = Math.cos((double)i * 3.141526 / 180.0) * radius;
            tessellator.func_78377_a(posX + x, posY + y, 0.0);
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)2881);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawGradientCircle(double posX, double posY, double radius, int color1, int color2, double alpha) {
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2881);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glHint((int)3155, (int)4354);
        GL11.glShadeModel((int)7425);
        tessellator.func_78371_b(9);
        tessellator.func_78369_a(f, f1, f2, (float)alpha);
        tessellator.func_78377_a(posX, posY, 0.0);
        tessellator.func_78369_a(f3, f4, f5, (float)alpha);
        for (int i = 1; i <= 361; ++i) {
            double x = Math.sin((double)i * 3.141526 / 180.0) * radius;
            double y = Math.cos((double)i * 3.141526 / 180.0) * radius;
            tessellator.func_78377_a(posX + x, posY + y, 0.0);
        }
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)2881);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawCircleLine(double posX, double posY, double radius, int color, double alpha) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2881);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glHint((int)3155, (int)4354);
        GuiUtils.renderColor(color, alpha);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(2);
        for (int i = 0; i <= 360; ++i) {
            double x = Math.sin((double)i * Math.PI / 180.0) * radius;
            double y = Math.cos((double)i * Math.PI / 180.0) * radius;
            tessellator.func_78377_a(posX + x, posY + y, 0.0);
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)2881);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawWedge(double posX, double posY, double rotation, double radius, double size, int color, double alpha) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2881);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glHint((int)3155, (int)4354);
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        GL11.glRotated((double)rotation, (double)0.0, (double)0.0, (double)1.0);
        GuiUtils.renderColor(color, alpha);
        tessellator.func_78371_b(9);
        tessellator.func_78377_a(0.0, 0.0, 0.0);
        int i = 0;
        while ((double)i <= size) {
            double x = Math.sin((double)i * 3.141526 / 180.0) * radius;
            double y = Math.cos((double)i * 3.141526 / 180.0) * radius;
            tessellator.func_78377_a(x, y, 0.0);
            ++i;
        }
        tessellator.func_78381_a();
        GL11.glRotated((double)(-rotation), (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(-posX), (double)(-posY), (double)0.0);
        GL11.glDisable((int)2881);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void glScissor(int posX, int posY, int endX, int endY, boolean test) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int scale = resolution.func_78325_e();
        int scissorWidth = endX * scale;
        int scissorHeight = endY * scale;
        int scissorX = posX * scale;
        int scissorY = mc.field_71440_d - scissorHeight - posY * scale;
        if (test) {
            GuiUtils.drawRectS(scissorX, scissorY, scissorWidth, scissorHeight, 0xFFFFFF, 0.3);
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
    }

    public static void glScissorNoScale(int posX, int posY, int endX, int endY, boolean test) {
        if (test) {
            GuiUtils.drawRectS(posX, posY, endX, endY, 0xFFFFFF, 0.3);
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)posX, (int)posY, (int)endX, (int)endY);
    }

    public static void drawItemStackIntoGUI(ItemStack itemstack, int posX, int posY, double scale) {
        if (itemstack != null) {
            GL11.glPushMatrix();
            GL11.glEnable((int)2896);
            GL11.glScaled((double)scale, (double)scale, (double)0.0);
            itemRenderer.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), itemstack, (int)((double)posX / scale), (int)((double)posY / scale));
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
        }
    }

    public static void drawItemStackIntoGUINew(ItemStack itemStack, float posX, float posY, double scale) {
        if (itemStack != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)scale, (double)scale, (double)0.0);
            GL11.glPushAttrib((int)1048575);
            RenderHelper.func_74520_c();
            itemRendererNew.renderItemAndEffectIntoGUINew(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), itemStack, (float)((double)posX / scale), (float)((double)posY / scale));
            RenderHelper.func_74518_a();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    public static boolean isInBox(double posX, double posY, double endX, double endY, double checkX, double checkY) {
        return checkX >= posX && checkY >= posY && checkX <= posX + endX && checkY <= posY + endY;
    }

    public static void renderColor(int color, double alpha) {
        Color color1 = Color.decode("" + color);
        float red = (float)color1.getRed() / 255.0f;
        float green = (float)color1.getGreen() / 255.0f;
        float blue = (float)color1.getBlue() / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)((float)alpha));
    }

    public static int getRGBA(int r, int g, int b, int a) {
        return (r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public static int getRGB(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int toHex(int r, int g, int b) {
        int h = 0;
        int hex = h | r << 16;
        hex |= g << 8;
        return hex |= b;
    }

    public static double getDistanceAtoB(double startX, double startY, double endX, double endY) {
        double x = startX - endX;
        double y = startY - endY;
        return Math.sqrt(x * x + y * y);
    }

    public static void disableGlScissor() {
        GL11.glDisable((int)3089);
    }

    public static void drawImage(ResourceLocation image, double posX, double posY, double endX, double endY, double scale) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GuiUtils.renderColor(0xFFFFFF, 1.0);
        tessellator.func_78382_b();
        tessellator.func_78374_a(posX / scale, posY / scale + endY, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(posX / scale + endX, posY / scale + endY, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(posX / scale + endX, posY / scale, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(posX / scale, posY / scale, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
        GL11.glEnable((int)3008);
        GL11.glPopMatrix();
    }

    public static void drawImageNew(ResourceLocation image, double posX, double posY, double endX, double endY, double scale) {
        CoreAPI.bindTexture(image);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GuiUtils.renderColor(0xFFFFFF, 1.0);
        tessellator.func_78382_b();
        tessellator.func_78374_a(posX / scale, posY / scale + endY, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(posX / scale + endX, posY / scale + endY, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(posX / scale + endX, posY / scale, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(posX / scale, posY / scale, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
        GL11.glEnable((int)3008);
        GL11.glPopMatrix();
    }

    public static void drawImageNew(ResourceLocation textureLocation, double x, double y, double width, double height) {
        CoreAPI.bindTexture(textureLocation);
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawRect(double x, double y, double width, double height) {
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y + height, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(x, y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawImageColor(ResourceLocation image, double posX, double posY, double endX, double endY, int color, double scale) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GuiUtils.renderColor(color, 1.0);
        tessellator.func_78382_b();
        tessellator.func_78374_a(posX / scale, posY / scale + endY, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(posX / scale + endX, posY / scale + endY, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(posX / scale + endX, posY / scale, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(posX / scale, posY / scale, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
        GL11.glPopMatrix();
    }

    public static void drawImageColorWithAlpha(ResourceLocation image, double posX, double posY, double endX, double endY, int color, double alpha, double scale) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GuiUtils.renderColor(color, alpha);
        tessellator.func_78382_b();
        tessellator.func_78374_a(posX / scale, posY / scale + endY, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(posX / scale + endX, posY / scale + endY, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(posX / scale + endX, posY / scale, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(posX / scale, posY / scale, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
        GL11.glPopMatrix();
    }

    private Dimension getTextureSize(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        GL11.glBindTexture((int)3553, (int)0);
        return new Dimension(width, height);
    }
}

