/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.player;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import ru.vizzi.Utils.eventhandler.RegistryEvent;
import ru.vizzi.Utils.player.AbstractExtendedPlayer;
import ru.vizzi.Utils.player.RegistryExtended;

@RegistryEvent
public class ExtendedManager {
    private static ExtendedManager instance;
    private static HashMap<String, AbstractExtendedPlayer> hashExtended;

    private Set<Class<?>> scanClasses() {
        Reflections reflections = new Reflections("ru.vizzi", new TypeAnnotationsScanner(), new SubTypesScanner());
        return reflections.getTypesAnnotatedWith(RegistryExtended.class);
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        for (AbstractExtendedPlayer extended : hashExtended.values()) {
            extended.get(event.entityPlayer).copyNBT(extended.get(event.original));
        }
    }

    @SubscribeEvent
    public void onPlayerConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            for (AbstractExtendedPlayer extended : hashExtended.values()) {
                if (player.getExtendedProperties(extended.getExtendedName()) != null) continue;
                player.registerExtendedProperties(extended.getExtendedName(), (IExtendedEntityProperties)extended.getClass().getConstructor(EntityPlayer.class).newInstance(player));
            }
        }
    }

    public static ExtendedManager getInstances() {
        if (instance == null) {
            instance = new ExtendedManager();
        }
        return instance;
    }

    static {
        hashExtended = new HashMap();
    }
}

