/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.resouces;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ru.vizzi.Utils.resouces.IResourceLoader;

public class ZipResourceLoader
implements IResourceLoader {
    public static final String TARGET_DIR = "..\\resources";
    private final File[] files;
    private final ZipFile[] zipFiles;

    public ZipResourceLoader() {
        String[] zipNames = new String[]{"resources0.zip"};
        ZipFile[] zipFiles = new ZipFile[]{};
        File[] files = new File[]{};
        for (int i = 0; i < zipNames.length; ++i) {
            File file = new File(zipNames[i]);
            if (!file.exists()) continue;
            files = Arrays.copyOf(files, files.length + 1);
            zipFiles = Arrays.copyOf(zipFiles, zipFiles.length + 1);
            files[i] = file;
            try {
                zipFiles[i] = new ZipFile(file);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.files = files;
        this.zipFiles = zipFiles;
    }

    @Override
    public InputStream getResourceInputStream(String path) throws IOException {
        for (ZipFile zipFile : this.zipFiles) {
            ZipEntry zipEntry;
            if (zipFile == null || (zipEntry = zipFile.getEntry("assets/" + path)) == null) continue;
            return zipFile.getInputStream(zipEntry);
        }
        return null;
    }

    public File[] getFiles() {
        return this.files;
    }
}

