/*
 * Decompiled with CFR 0.152.
 */
package ml.luxinfine.randompatcher;

import java.util.Random;

public class ImproveRandom
extends Random {
    public static final Random INSTANCE = new ImproveRandom();
    private static final long serialVersionUID = 6208727693524452904L;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    boolean haveNextNextGaussian = false;
    double nextNextGaussian = 0.0;
    private long seed;
    private long last;

    public static double random() {
        return INSTANCE.nextDouble();
    }

    public ImproveRandom() {
        this(System.nanoTime());
    }

    public ImproveRandom(long seed) {
        this.seed = seed;
    }

    @Override
    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }

    public synchronized long getSeed() {
        return this.seed;
    }

    @Override
    public synchronized void setSeed(long seed) {
        this.seed = seed;
    }

    public ImproveRandom clone() {
        return new ImproveRandom(this.getSeed());
    }

    @Override
    public int next(int nbits) {
        long x = this.seed;
        x ^= x << 21;
        x ^= x >>> 35;
        x ^= x << 4;
        this.seed = x;
        return (int)(x &= (1L << nbits) - 1L);
    }

    @Override
    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    @Override
    public int nextInt(int _bound) {
        int bound = _bound <= 0 ? 1 : _bound;
        this.last = this.seed ^ this.seed << 21;
        this.last ^= this.last >>> 35;
        this.last ^= this.last << 4;
        this.seed = this.last;
        int out = (int)this.last % bound;
        return out < 0 ? -out : out;
    }

    @Override
    public int nextInt() {
        return this.next(32);
    }

    @Override
    public float nextFloat() {
        return (float)this.next(24) * 5.9604645E-8f;
    }

    @Override
    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    @Override
    public void nextBytes(byte[] bytes_arr) {
        int iba = 0;
        int lenba = bytes_arr.length;
        while (iba < lenba) {
            int rndba = this.nextInt();
            int nba = Math.min(lenba - iba, 4);
            while (nba-- > 0) {
                bytes_arr[iba++] = (byte)rndba;
                rndba >>= 8;
            }
        }
    }
}

