/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.uniform;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.optifine.entity.model.anim.ConstantFloat;
import net.optifine.entity.model.anim.IExpression;
import net.optifine.entity.model.anim.IExpressionResolver;
import shadersmod.common.SMCLog;
import shadersmod.uniform.ShaderParameterBool;
import shadersmod.uniform.ShaderParameterFloat;

public class ShaderExpressionResolver
implements IExpressionResolver {
    private Map<String, IExpression> mapExpressions = new HashMap<String, IExpression>();

    public ShaderExpressionResolver(Map<String, IExpression> map) {
        this.registerExpressions();
        Set<String> keys = map.keySet();
        for (String name : keys) {
            IExpression expr = map.get(name);
            this.registerExpression(name, expr);
        }
    }

    private void registerExpressions() {
        ShaderParameterFloat[] spfs = ShaderParameterFloat.values();
        for (int i = 0; i < spfs.length; ++i) {
            ShaderParameterFloat spf = spfs[i];
            this.mapExpressions.put(spf.getName(), spf);
        }
        ShaderParameterBool[] spbs = ShaderParameterBool.values();
        for (int i = 0; i < spbs.length; ++i) {
            ShaderParameterBool spb = spbs[i];
            this.mapExpressions.put(spb.getName(), spb);
        }
        ahu[] biomeList = ahu.n();
        for (int i = 0; i < biomeList.length; ++i) {
            ahu biome = biomeList[i];
            if (biome == null) continue;
            String name = biome.af.trim();
            name = "BIOME_" + name.toUpperCase().replace(' ', '_');
            int id = biome.ay;
            ConstantFloat expr = new ConstantFloat(id);
            this.registerExpression(name, expr);
        }
    }

    public boolean registerExpression(String name, IExpression expr) {
        if (this.mapExpressions.containsKey(name)) {
            SMCLog.warning("Expression already defined: " + name);
            return false;
        }
        this.mapExpressions.put(name, expr);
        return true;
    }

    @Override
    public IExpression getExpression(String name) {
        return this.mapExpressions.get(name);
    }

    public boolean hasExpression(String name) {
        return this.mapExpressions.containsKey(name);
    }
}

