/*
 * Decompiled with CFR 0.152.
 */
package ru.samopis.photon.bloader.displayer;

import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import ru.samopis.photon.bloader.displayer.MinecraftDisplayer;
import ru.samopis.photon.bloader.displayer.MinecraftDisplayerWrapper;

public class ProgressDisplayer {
    public static boolean playSound;
    public static File coreModLocation;
    public static ModContainer modContainer;
    private static IDisplayer displayer;
    private static int clientState;
    private static boolean hasInitRL;

    public static boolean isClient() {
        if (clientState != -1) {
            return clientState == 1;
        }
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().startsWith("cpw.mods.fml.relauncher.ServerLaunchWrapper")) continue;
            clientState = 0;
            return false;
        }
        clientState = 1;
        return true;
    }

    private static void loadResourceLoader() {
        try {
            Class<?> resLoaderClass = Class.forName("lumien.resourceloader.ResourceLoader");
            Object instance = resLoaderClass.newInstance();
            resLoaderClass.getField("INSTANCE").set(null, instance);
            Method m = resLoaderClass.getMethod("preInit", FMLPreInitializationEvent.class);
            m.invoke(instance, new Object[]{null});
            LogManager.getLogger(MinecraftDisplayer.class).log(Level.INFO, "Resource loader loaded early succssessfully :)");
        }
        catch (ClassNotFoundException ex) {
            LogManager.getLogger(MinecraftDisplayer.class).log(Level.ERROR, "Resource loader not loaded, not initialising early");
        }
        catch (Throwable t) {
            LogManager.getLogger(MinecraftDisplayer.class).log(Level.ERROR, "Resource Loader Compat FAILED!");
            t.printStackTrace();
        }
    }

    public static void start(File coremodLocation) {
        coreModLocation = coremodLocation;
        if (coreModLocation == null) {
            coreModLocation = new File("./../bin/");
        }
        ModMetadata md = new ModMetadata();
        md.name = "Better Loading Screen";
        md.modId = "betterloadingscreen";
        modContainer = new DummyModContainer(md){

            public Class<?> getCustomResourcePackClass() {
                return FMLFileResourcePack.class;
            }

            public File getSource() {
                return coreModLocation;
            }

            public String getModId() {
                return "betterloadingscreen";
            }
        };
        playSound = true;
        displayer = new MinecraftDisplayerWrapper();
        displayer.start();
    }

    public static void displayProgress(String text, float percent) {
        if (!hasInitRL) {
            ProgressDisplayer.loadResourceLoader();
            ProgressDisplayer.overrideForgeSplashProgress();
            hasInitRL = true;
        }
        displayer.displayProgress(text, percent);
    }

    public static void close() {
        if (displayer == null) {
            return;
        }
        displayer.close();
        displayer = null;
        if (ProgressDisplayer.isClient() && playSound) {
            new Thread(() -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MinecraftDisplayerWrapper.playFinishedSound();
            }).start();
        }
    }

    private static void overrideForgeSplashProgress() {
        Class<?> cl = null;
        Field fi = null;
        try {
            cl = Class.forName("cpw.mods.fml.client.SplashProgress");
            fi = cl.getDeclaredField("enabled");
            fi.setAccessible(true);
            fi.set(null, false);
            fi = cl.getDeclaredField("done");
            fi.setAccessible(true);
            fi.set(null, true);
        }
        catch (Throwable t) {
            LogManager.getLogger(MinecraftDisplayer.class).log(Level.ERROR, "Could not override forge's splash screen for some reason...");
            LogManager.getLogger(MinecraftDisplayer.class).log(Level.ERROR, "class = " + cl);
            LogManager.getLogger(MinecraftDisplayer.class).log(Level.ERROR, "field = " + fi);
            t.printStackTrace();
        }
    }

    public static void minecraftDisplayFirstProgress() {
        ProgressDisplayer.displayProgress("\u0417\u0430\u043f\u0443\u0441\u043a \u0438\u0433\u0440\u044b", 0.0f);
    }

    static {
        clientState = -1;
        hasInitRL = false;
    }

    public static interface IDisplayer {
        public void start();

        public void displayProgress(String var1, float var2);

        public void close();
    }
}

