/*
 * Decompiled with CFR 0.152.
 */
package ru.samopis.photon.bloader.displayer.item;

import org.lwjgl.opengl.GL11;
import ru.samopis.photon.bloader.displayer.item.DisplayedItem;
import ru.samopis.photon.bloader.util.RenderUtils;
import ru.samopis.photon.bloader.util.Texture;
import ru.samopis.photon.bloader.util.TextureRegistry;

public class Image
extends DisplayedItem {
    private int x2;
    private final int y2;
    private final ImageType imageType;
    private float u;
    private final float v;
    private final String path;

    public Image(String path, ImageType imageType, int x1, int y1, int width, int height) {
        super(DisplayedItem.RenderType.IMAGE, x1, y1);
        this.path = path;
        this.u = 1.0f;
        this.v = 1.0f;
        this.x2 = width;
        this.y2 = height;
        this.imageType = imageType;
        Texture texture = new Texture(path);
        TextureRegistry.registerTexture(path, texture);
    }

    public void setDynamicWidth(int x2, float percent) {
        this.x2 = x2;
        this.u = percent;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    @Override
    public void draw() {
        Texture texture = (Texture)TextureRegistry.getTexture(this.path);
        int textureID = texture.func_110552_b();
        GL11.glBindTexture((int)3553, (int)textureID);
        switch (this.imageType) {
            case DYNAMIC: {
                RenderUtils.drawRectWithUV(this.x, this.y, this.x2, this.y2, this.u, this.v);
                break;
            }
            case STATIC: {
                RenderUtils.drawRect(this.x, this.y, this.x2, this.y2);
            }
        }
    }

    public static enum ImageType {
        STATIC,
        DYNAMIC;

    }
}

