/*
 * Decompiled with CFR 0.152.
 */
package ru.samopis.photon.bloader.truetyper;

import cpw.mods.fml.common.FMLCommonHandler;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class TrueTypeFont {
    private final Map<Character, FloatObject> characterMap = new HashMap<Character, FloatObject>();
    private final int textureHeight;
    protected Font font;
    private float fontSize = 0.0f;
    private float fontHeight = 0.0f;
    private int fontTextureID;
    private final int textureWidth;
    private FontMetrics fontMetrics;

    public TrueTypeFont(Font font) {
        this.textureWidth = 1024;
        this.textureHeight = 1024;
        this.font = font;
        this.fontSize = font.getSize() + 3;
        this.createSet(" !\\\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0401\u0451\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f".toCharArray());
        System.out.println("TrueTypeFont loaded: " + font + " - AntiAlias");
        this.fontHeight -= 1.0f;
        if (this.fontHeight <= 0.0f) {
            this.fontHeight = 1.0f;
        }
    }

    public static int loadImage(BufferedImage bufferedImage) {
        try {
            ByteBuffer byteBuffer;
            short width = (short)bufferedImage.getWidth();
            short height = (short)bufferedImage.getHeight();
            byte bpp = (byte)bufferedImage.getColorModel().getPixelSize();
            DataBuffer db = bufferedImage.getData().getDataBuffer();
            if (db instanceof DataBufferInt) {
                int[] intI = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
                byte[] newI = new byte[intI.length * 4];
                for (int i = 0; i < intI.length; ++i) {
                    byte[] b = TrueTypeFont.intToByteArray(intI[i]);
                    int newIndex = i * 4;
                    newI[newIndex] = b[1];
                    newI[newIndex + 1] = b[2];
                    newI[newIndex + 2] = b[3];
                    newI[newIndex + 3] = b[0];
                }
                byteBuffer = ByteBuffer.allocateDirect(width * height * (bpp / 8)).order(ByteOrder.nativeOrder()).put(newI);
            } else {
                byteBuffer = ByteBuffer.allocateDirect(width * height * (bpp / 8)).order(ByteOrder.nativeOrder()).put(((DataBufferByte)bufferedImage.getData().getDataBuffer()).getData());
            }
            byteBuffer.flip();
            int internalFormat = 32856;
            int format = 6408;
            IntBuffer textureId = BufferUtils.createIntBuffer((int)1);
            GL11.glGenTextures((IntBuffer)textureId);
            GL11.glBindTexture((int)3553, (int)textureId.get(0));
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexEnvf((int)8960, (int)8704, (float)8448.0f);
            GLU.gluBuild2DMipmaps((int)3553, (int)internalFormat, (int)width, (int)height, (int)format, (int)5121, (ByteBuffer)byteBuffer);
            return textureId.get(0);
        }
        catch (Exception var11) {
            var11.printStackTrace();
            FMLCommonHandler.instance().exitJava(-1, false);
            return -1;
        }
    }

    public static boolean isSupported(String fontname) {
        Font[] font = TrueTypeFont.getFonts();
        for (int i = font.length - 1; i >= 0; --i) {
            if (!font[i].getName().equalsIgnoreCase(fontname)) continue;
            return true;
        }
        return false;
    }

    public static Font[] getFonts() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    }

    public static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public String trimStringToWidth(String p_78269_1_, int p_78269_2_) {
        return this.trimStringToWidth(p_78269_1_, p_78269_2_, false);
    }

    public String trimStringToWidth(String p_78262_1_, int p_78262_2_, boolean p_78262_3_) {
        StringBuilder stringbuilder = new StringBuilder();
        float j = 0.0f;
        int k = p_78262_3_ ? p_78262_1_.length() - 1 : 0;
        int l = p_78262_3_ ? -1 : 1;
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i1 = k; i1 >= 0 && i1 < p_78262_1_.length() && j < (float)p_78262_2_; i1 += l) {
            char c0 = p_78262_1_.charAt(i1);
            float j1 = this.getWidth(String.valueOf(c0));
            if (flag1) {
                flag1 = false;
                if (c0 != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag2 = false;
                    }
                } else {
                    flag2 = true;
                }
            } else if (j1 < 0.0f) {
                flag1 = true;
            } else {
                j += j1;
                if (flag2) {
                    j += 1.0f;
                }
            }
            if (j > (float)p_78262_2_) break;
            if (p_78262_3_) {
                stringbuilder.insert(0, c0);
                continue;
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.toString();
    }

    private BufferedImage getFontImage(char ch) {
        float charheight;
        BufferedImage tempfontImage = new BufferedImage(1, 1, 2);
        Graphics2D g = (Graphics2D)tempfontImage.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(this.font);
        this.fontMetrics = g.getFontMetrics();
        float charwidth = this.fontMetrics.charWidth(ch) + 8;
        if (charwidth <= 0.0f) {
            charwidth = 7.0f;
        }
        if ((charheight = (float)(this.fontMetrics.getHeight() + 3)) <= 0.0f) {
            charheight = this.fontSize;
        }
        BufferedImage fontImage = new BufferedImage((int)charwidth, (int)charheight, 2);
        Graphics2D gt = (Graphics2D)fontImage.getGraphics();
        gt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gt.setFont(this.font);
        gt.setColor(Color.WHITE);
        int charx = 3;
        int chary = 1;
        gt.drawString(String.valueOf(ch), charx, chary + this.fontMetrics.getAscent());
        return fontImage;
    }

    private void createSet(char[] chars) {
        try {
            BufferedImage imgTemp = new BufferedImage(this.textureWidth, this.textureHeight, 2);
            Graphics2D g = (Graphics2D)imgTemp.getGraphics();
            g.setColor(new Color(0, 0, 0, 1));
            g.fillRect(0, 0, this.textureWidth, this.textureHeight);
            float rowHeight = 0.0f;
            float positionX = 0.0f;
            float positionY = 0.0f;
            for (char ch : chars) {
                BufferedImage fontImage = this.getFontImage(ch);
                FloatObject newIntObject = new FloatObject();
                newIntObject.width = fontImage.getWidth();
                newIntObject.height = fontImage.getHeight();
                if (positionX + newIntObject.width >= (float)this.textureWidth) {
                    positionX = 0.0f;
                    positionY += rowHeight;
                    rowHeight = 0.0f;
                }
                newIntObject.storedX = positionX;
                newIntObject.storedY = positionY;
                if (newIntObject.height > this.fontHeight) {
                    this.fontHeight = newIntObject.height;
                }
                if (newIntObject.height > rowHeight) {
                    rowHeight = newIntObject.height;
                }
                g.drawImage((Image)fontImage, (int)positionX, (int)positionY, null);
                positionX += newIntObject.width;
                this.characterMap.put(Character.valueOf(ch), newIntObject);
            }
            this.fontTextureID = TrueTypeFont.loadImage(imgTemp);
        }
        catch (Exception var12) {
            System.err.println("Failed to create font.");
            var12.printStackTrace();
        }
    }

    private void drawQuad(float drawX, float drawY, float drawX2, float drawY2, float srcX, float srcY, float srcX2, float srcY2) {
        float DrawWidth = drawX2 - drawX;
        float DrawHeight = drawY2 - drawY;
        float TextureSrcX = srcX / (float)this.textureWidth;
        float TextureSrcY = srcY / (float)this.textureHeight;
        float SrcWidth = srcX2 - srcX;
        float SrcHeight = srcY2 - srcY;
        float RenderWidth = SrcWidth / (float)this.textureWidth;
        float RenderHeight = SrcHeight / (float)this.textureHeight;
        GL11.glTexCoord2f((float)TextureSrcX, (float)TextureSrcY);
        GL11.glVertex2f((float)drawX, (float)drawY);
        GL11.glTexCoord2f((float)TextureSrcX, (float)(TextureSrcY + RenderHeight));
        GL11.glVertex2f((float)drawX, (float)(drawY + DrawHeight));
        GL11.glTexCoord2f((float)(TextureSrcX + RenderWidth), (float)(TextureSrcY + RenderHeight));
        GL11.glVertex2f((float)(drawX + DrawWidth), (float)(drawY + DrawHeight));
        GL11.glTexCoord2f((float)(TextureSrcX + RenderWidth), (float)TextureSrcY);
        GL11.glVertex2f((float)(drawX + DrawWidth), (float)drawY);
    }

    public float getWidth(String whatchars) {
        float totalwidth = 0.0f;
        for (int i = 0; i < whatchars.length(); ++i) {
            char currentChar = whatchars.charAt(i);
            FloatObject floatObject = this.characterMap.get(Character.valueOf(currentChar));
            if (floatObject == null) continue;
            totalwidth += floatObject.width / 2.0f;
        }
        return this.fontMetrics.stringWidth(whatchars);
    }

    public float getHeight() {
        return this.fontHeight;
    }

    public float getHeight(String HeightString) {
        return this.fontHeight;
    }

    public float getLineHeight() {
        return this.fontHeight;
    }

    public void drawString(String string, int color) {
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float blue = (float)(color >> 8 & 0xFF) / 255.0f;
        float green = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float totalwidth = 0.0f;
        float startY = 0.0f;
        GL11.glBindTexture((int)3553, (int)this.fontTextureID);
        GL11.glBegin((int)7);
        GL11.glColor4f((float)red, (float)blue, (float)green, (float)alpha);
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char charCurrent = string.charAt(i);
            FloatObject floatObject = this.characterMap.get(Character.valueOf(charCurrent));
            if (floatObject == null) continue;
            if (charCurrent == '\n') {
                startY -= this.fontHeight;
                totalwidth = 0.0f;
                continue;
            }
            this.drawQuad(totalwidth + floatObject.width, startY, totalwidth, startY + floatObject.height, floatObject.storedX + floatObject.width, floatObject.storedY + floatObject.height, floatObject.storedX, floatObject.storedY);
            totalwidth += floatObject.width - 8.0f;
        }
        GL11.glEnd();
    }

    public void destroy() {
        IntBuffer scratch = BufferUtils.createIntBuffer((int)1);
        scratch.put(0, this.fontTextureID);
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glDeleteTextures((IntBuffer)scratch);
    }

    private class FloatObject {
        public float width;
        public float height;
        public float storedX;
        public float storedY;

        private FloatObject() {
        }
    }
}

