/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.crashguard;

import com.falsepattern.crashguard.CrashGuard;
import com.falsepattern.crashguard.gui.GuiCrash;
import com.falsepattern.crashguard.util.GlUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;

@SideOnly(value=Side.CLIENT)
public class CrashHandler {
    public static final List<Class<? extends TileEntitySpecialRenderer>> bannedTESRs = new ArrayList<Class<? extends TileEntitySpecialRenderer>>();

    public static void attemptRecoveryFromCrash(boolean serverCrash, Throwable t) {
        CrashHandler.freeMemory();
        CrashGuard.LOG.fatal("Unreported exception thrown!", t);
        CrashReport crashReport = new CrashReport("Unexpected error", t);
        CrashHandler.internalCrashHandler(serverCrash, crashReport);
    }

    public static void attemptRecoveryFromCrash(boolean serverCrash, ReportedException reportedException) {
        CrashHandler.freeMemory();
        CrashGuard.LOG.fatal("Reported exception thrown!", (Throwable)reportedException);
        CrashHandler.internalCrashHandler(serverCrash, reportedException.func_71575_a());
    }

    private static void freeMemory() {
        if (!CrashGuard.softCrash) {
            Minecraft.func_71410_x().func_71398_f();
        }
    }

    private static void internalCrashHandler(boolean serverCrash, CrashReport crashReport) {
        GlUtil.resetState();
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCrash(CrashGuard.softCrash, serverCrash, crashReport, CrashHandler.logCrash(crashReport)));
        CrashGuard.softCrash = false;
    }

    private static File logCrash(CrashReport crashReport) {
        File file1 = new File(Minecraft.func_71410_x().field_71412_D, "crash-reports");
        File file2 = new File(file1, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        System.out.println(crashReport.func_71502_e());
        if (crashReport.func_71497_f() != null) {
            System.out.println("#@!@# Game crashed! Crash report saved to: #@!@# " + crashReport.func_71497_f());
            return crashReport.func_71497_f();
        }
        if (crashReport.func_147149_a(file2)) {
            System.out.println("#@!@# Game crashed! Crash report saved to: #@!@# " + file2.getAbsolutePath());
            return file2;
        }
        System.out.println("#@?@# Game crashed! Crash report could not be saved. #@?@#");
        return null;
    }
}

