/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.crashguard.mixin.mixinplugin;

import com.falsepattern.crashguard.mixin.mixinplugin.TargetedMod;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum Mixin {
    ClientMinecraftMixin(Mixin.builder(Side.CLIENT).mixin("MinecraftMixin")),
    TessellatorMixin(Mixin.builder(Side.CLIENT).mixin("TessellatorMixin")),
    TileEntityRendererDispatcherMixin(Mixin.builder(Side.CLIENT).mixin("TileEntityRendererDispatcherMixin"));

    public final String mixin;
    public final Set<TargetedMod> targetedMods;
    private final Side side;

    private Mixin(Builder builder) {
        this.mixin = builder.mixin;
        this.targetedMods = builder.targetedMods;
        this.side = builder.side;
    }

    public boolean shouldLoad(List<TargetedMod> loadedMods) {
        return (this.side == Side.COMMON || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient()) && loadedMods.containsAll(this.targetedMods);
    }

    private static Builder builder(Side side) {
        return new Builder(side);
    }

    private static enum Side {
        COMMON,
        CLIENT,
        SERVER;

    }

    private static class Builder {
        public String mixin;
        public Side side;
        public Set<TargetedMod> targetedMods = new HashSet<TargetedMod>();

        public Builder(Side side) {
            this.side = side;
        }

        public Builder mixin(String mixinClass) {
            this.mixin = this.side.name().toLowerCase() + "." + mixinClass;
            return this;
        }

        public Builder target(TargetedMod mod) {
            this.targetedMods.add(mod);
            return this;
        }
    }
}

