/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.storage.DBEntry;
import betterquesting.commands.QuestCommandBase;
import betterquesting.questing.QuestDatabase;
import betterquesting.storage.NameCache;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class QuestCommandCheckCompletion
extends QuestCommandBase {
    @Override
    public String getUsageSuffix() {
        return "<username|uuid> <quest_id>";
    }

    @Override
    public boolean validArgs(String[] args) {
        return args.length == 3;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])NameCache.INSTANCE.getAllNames().toArray(new String[0]));
        }
        if (args.length == 3) {
            for (DBEntry i : QuestDatabase.INSTANCE.getEntries()) {
                list.add(Integer.toString(i.getID()));
            }
        }
        return list;
    }

    @Override
    public String getCommand() {
        return "check";
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) throws CommandException {
        UUID uuid = this.findPlayerID(server, sender, args[1]);
        if (uuid == null) {
            throw this.getException(command);
        }
        String pName = NameCache.INSTANCE.getName(uuid);
        int id = Integer.parseInt(args[2].trim());
        IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(id);
        if (quest == null) {
            throw this.getException(command);
        }
        sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.check." + quest.isComplete(uuid), new Object[]{pName, new ChatComponentTranslation(quest.getProperty(NativeProps.NAME), new Object[0])}));
    }

    @Override
    public boolean isArgUsername(String[] args, int index) {
        return index == 1;
    }
}

