/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.machines;

import ic2.api.recipe.IFluidHeatManager;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.ic2.FluidHeatGenerator")
@ModOnly(value={"IC2"})
public class FluidHeatGenerator {
    @ZenMethod
    public static void addFluid(ILiquidStack liquidPerTick, int heatPerTick) {
        MineTweakerAPI.apply(new AddFluidAction(liquidPerTick.getName(), liquidPerTick.getAmount(), heatPerTick));
    }

    @ZenMethod
    public static boolean accepts(ILiquidStack liquid) {
        return Recipes.FluidHeatGenerator.acceptsFluid(FluidRegistry.getFluid((String)liquid.getName()));
    }

    @ZenMethod
    public static void removeFluid(ILiquidStack fluid) {
        MineTweakerAPI.apply(fluid == null ? null : new HeatFluidRemover(fluid.getName()));
    }

    private static class AddFluidAction
    implements IUndoableAction {
        private final String name;
        private final int liquidPerTick;
        private final int heatPerTick;
        private IFluidHeatManager.BurnProperty replacedRecipe;

        public AddFluidAction(String name, int liquidPerTick, int heatPerTick) {
            this.name = name;
            this.liquidPerTick = liquidPerTick;
            this.heatPerTick = heatPerTick;
        }

        @Override
        public void apply() {
            this.replacedRecipe = Recipes.FluidHeatGenerator.getBurnProperties().put(this.name, new IFluidHeatManager.BurnProperty(this.liquidPerTick, this.heatPerTick));
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Iterator it = Recipes.FluidHeatGenerator.getBurnProperties().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry r = it.next();
                if (!((String)r.getKey()).equals(this.name)) continue;
                it.remove();
                break;
            }
            if (this.replacedRecipe != null) {
                Recipes.FluidHeatGenerator.getBurnProperties().put(this.name, this.replacedRecipe);
            }
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public String describe() {
            return "Adding liquid " + this.name + " as fluid heat generator fuel";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 47 * hash + this.liquidPerTick;
            hash = 47 * hash + this.heatPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddFluidAction other = (AddFluidAction)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.liquidPerTick != other.liquidPerTick) {
                return false;
            }
            return this.heatPerTick == other.heatPerTick;
        }
    }

    private static class HeatFluidRemover
    implements IUndoableAction {
        private final String name;
        private final List<Map.Entry<String, IFluidHeatManager.BurnProperty>> removedRecipes = new ArrayList<Map.Entry<String, IFluidHeatManager.BurnProperty>>();

        public HeatFluidRemover(String fluidName) {
            this.name = fluidName;
        }

        @Override
        public void apply() {
            Iterator it = Recipes.FluidHeatGenerator.getBurnProperties().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry r = it.next();
                if (this.name != null && !((String)r.getKey()).equals(this.name)) continue;
                it.remove();
                this.removedRecipes.add(r);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Map recipes = Recipes.FluidHeatGenerator.getBurnProperties();
            this.removedRecipes.forEach(entry -> {
                IFluidHeatManager.BurnProperty cfr_ignored_0 = (IFluidHeatManager.BurnProperty)recipes.put(entry.getKey(), entry.getValue());
            });
        }

        @Override
        public String describe() {
            return "Removing FluidHeatGenerator fluid " + (this.name == null ? "ALL" : this.name);
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

