/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import stanhebben.zenscript.parser.CharStream;
import stanhebben.zenscript.parser.DFA;
import stanhebben.zenscript.parser.HashSetI;
import stanhebben.zenscript.parser.IteratorI;

public class NFA {
    public static final int NOFINAL = Integer.MIN_VALUE;
    public static final int EPSILON = -2147483647;
    public static final int UNICODE_ESCAPE = 256;
    private final NFAState initial;
    private HashMap<NodeSet, DFA.DFAState> converted;

    public NFA(NFAState initial) {
        this.initial = initial;
    }

    public NFA(String regexp) {
        Partial main = this.processRegExp(new CharStream(regexp));
        this.initial = new NFAState();
        this.initial.addTransition(main.tailLabel, main.tail);
        main.head.setFinal(1);
    }

    public NFA(String[] regexp, int[] finals) {
        this.initial = new NFAState();
        Partial[] partials = new Partial[regexp.length];
        for (int i = 0; i < regexp.length; ++i) {
            partials[i] = this.processRegExp(new CharStream(regexp[i]));
            partials[i].head.setFinal(finals[i]);
            this.initial.addTransition(partials[i].tailLabel, partials[i].tail);
        }
    }

    public DFA toDFA() {
        this.converted = new HashMap();
        HashSet<NFAState> closure = new HashSet<NFAState>();
        this.initial.closure(closure);
        DFA.DFAState init = this.convert(new NodeSet(closure));
        return new DFA(init);
    }

    /*
     * WARNING - void declaration
     */
    private DFA.DFAState convert(NodeSet nodes) {
        if (!this.converted.containsKey(nodes)) {
            void var7_15;
            DFA.DFAState node = new DFA.DFAState();
            this.converted.put(nodes, node);
            HashSet edgeSet = new HashSet();
            for (NFAState nFAState : nodes.nodes) {
                nFAState.alphabet(edgeSet);
            }
            Iterator iterator = edgeSet.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                HashSet<NFAState> edge = new HashSet<NFAState>();
                for (NFAState n : nodes.nodes) {
                    n.edge(i, edge);
                }
                NodeSet nodeSet = new NodeSet(edge);
                node.addTransition(i, this.convert(nodeSet));
            }
            int finalCode = Integer.MIN_VALUE;
            NFAState[] nFAStateArray = nodes.nodes;
            int n = nFAStateArray.length;
            boolean bl = false;
            while (var7_15 < n) {
                NFAState n2 = nFAStateArray[var7_15];
                if (n2.finalCode != Integer.MIN_VALUE) {
                    finalCode = finalCode != Integer.MIN_VALUE ? Math.min(n2.finalCode, finalCode) : n2.finalCode;
                }
                ++var7_15;
            }
            node.setFinal(finalCode);
            return node;
        }
        return this.converted.get(nodes);
    }

    private Partial processRegExp(CharStream stream) {
        Partial partial = this.processRegExp0(stream);
        if (stream.optional('|')) {
            ArrayList<Partial> partials = new ArrayList<Partial>();
            partials.add(partial);
            partials.add(this.processRegExp0(stream));
            while (stream.optional('|')) {
                partials.add(this.processRegExp0(stream));
            }
            NFAState head = new NFAState();
            NFAState tail = new NFAState();
            for (Partial p : partials) {
                tail.addTransition(p.tailLabel, p.tail);
                p.head.addTransition(-2147483647, head);
            }
            return new Partial(-2147483647, tail, head);
        }
        return partial;
    }

    private Partial processRegExp0(CharStream stream) {
        Partial partial = this.processRegExp1(stream);
        while (!stream.peek(')') && !stream.peek('|') && stream.hasMore()) {
            Partial partial2 = this.processRegExp1(stream);
            partial.head.addTransition(partial2.tailLabel, partial2.tail);
            partial = new Partial(partial.tailLabel, partial.tail, partial2.head);
        }
        return partial;
    }

    private Partial processRegExp1(CharStream stream) {
        Partial partial = this.processPartial(stream);
        if (stream.optional('*')) {
            NFAState node = new NFAState();
            partial.head.addTransition(-2147483647, node);
            node.addTransition(partial.tailLabel, partial.tail);
            return new Partial(-2147483647, node, node);
        }
        if (stream.optional('+')) {
            NFAState node = new NFAState();
            partial.head.addTransition(-2147483647, node);
            node.addTransition(partial.tailLabel, partial.tail);
            return new Partial(partial.tailLabel, partial.tail, node);
        }
        if (stream.optional('?')) {
            NFAState node = new NFAState();
            node.addTransition(-2147483647, partial.head);
            node.addTransition(partial.tailLabel, partial.tail);
            return new Partial(-2147483647, node, partial.head);
        }
        if (stream.optional('{')) {
            int i;
            int amount = this.processInt(stream);
            if (amount < 0) {
                throw new IllegalArgumentException("Repitition count expected");
            }
            if (stream.optional(',')) {
                int i2;
                int amount2 = this.processInt(stream);
                stream.required('}');
                if (amount2 < 0) {
                    int i3;
                    Partial[] duplicates = new Partial[amount];
                    for (i3 = 0; i3 < duplicates.length - 1; ++i3) {
                        duplicates[i3] = partial.duplicate();
                    }
                    duplicates[amount - 1] = partial;
                    for (i3 = 0; i3 < duplicates.length - 1; ++i3) {
                        duplicates[i3].head.addTransition(duplicates[i3 + 1].tailLabel, duplicates[i3 + 1].tail);
                    }
                    duplicates[amount - 1].head.addTransition(duplicates[amount - 1].tailLabel, duplicates[amount - 1].tail);
                    return new Partial(duplicates[0].tailLabel, duplicates[0].tail, duplicates[amount - 1].head);
                }
                Partial[] duplicates = new Partial[amount2];
                for (i2 = 0; i2 < duplicates.length - 1; ++i2) {
                    duplicates[i2] = partial.duplicate();
                }
                duplicates[amount2 - 1] = partial;
                for (i2 = 0; i2 < duplicates.length - 1; ++i2) {
                    duplicates[i2].head.addTransition(duplicates[i2 + 1].tailLabel, duplicates[i2 + 1].tail);
                }
                for (i2 = amount; i2 < amount2; ++i2) {
                    if (i2 == 0) {
                        NFAState additional = new NFAState();
                        additional.addTransition(duplicates[0].tailLabel, duplicates[0].tail);
                        additional.addTransition(-2147483647, duplicates[amount2 - 1].head);
                        duplicates[0].tailLabel = -2147483647;
                        duplicates[0].tail = additional;
                        continue;
                    }
                    duplicates[i2 - 1].head.addTransition(-2147483647, duplicates[amount2 - 1].head);
                }
                return new Partial(duplicates[0].tailLabel, duplicates[0].tail, duplicates[amount2 - 1].head);
            }
            stream.required('}');
            Partial[] duplicates = new Partial[amount];
            for (i = 0; i < duplicates.length - 1; ++i) {
                duplicates[i] = partial.duplicate();
            }
            duplicates[amount - 1] = partial;
            for (i = 0; i < duplicates.length - 1; ++i) {
                duplicates[i].head.addTransition(duplicates[i + 1].tailLabel, duplicates[i + 1].tail);
            }
            return new Partial(duplicates[0].tailLabel, duplicates[0].tail, duplicates[amount - 1].head);
        }
        return partial;
    }

    private Partial processPartial(CharStream stream) {
        if (stream.optional('(')) {
            Partial result = this.processRegExp(stream);
            stream.required(')');
            return result;
        }
        if (stream.optional('[')) {
            NFAState head = new NFAState();
            NFAState tail = new NFAState();
            IteratorI iter = this.processCharList(stream).iterator();
            while (iter.hasNext()) {
                tail.addTransition(iter.next(), head);
            }
            stream.required(']');
            return new Partial(-2147483647, tail, head);
        }
        if (stream.optional('.')) {
            NFAState head = new NFAState();
            NFAState tail = new NFAState();
            for (int i = 0; i <= 256; ++i) {
                tail.addTransition(i, head);
            }
            return new Partial(-2147483647, tail, head);
        }
        NFAState node = new NFAState();
        return new Partial(this.processChar(stream), node, node);
    }

    private HashSetI processCharList(CharStream stream) {
        boolean invert = stream.optional('^');
        HashSetI base = new HashSetI();
        do {
            this.processCharPartial(base, stream);
        } while (!stream.peek(']'));
        if (invert) {
            HashSetI result = new HashSetI();
            for (int i = 0; i <= 256; ++i) {
                if (base.contains(i)) continue;
                result.add(i);
            }
            return result;
        }
        return base;
    }

    private void processCharPartial(HashSetI out, CharStream stream) {
        if (stream.optional('.')) {
            for (int i = 0; i <= 256; ++i) {
                out.add(i);
            }
        } else {
            int from = this.processChar(stream);
            if (stream.optional('-')) {
                int to = this.processChar(stream);
                for (int i = from; i <= to; ++i) {
                    out.add(i);
                }
            } else {
                out.add(from);
            }
        }
    }

    private int processChar(CharStream stream) {
        if (stream.optional('\\')) {
            if (stream.optional('u')) {
                return 256;
            }
            if (stream.optional('e')) {
                return -1;
            }
            if (stream.optional('r')) {
                return 13;
            }
            if (stream.optional('n')) {
                return 10;
            }
            if (stream.optional('t')) {
                return 9;
            }
            if (stream.optional('[')) {
                return 91;
            }
            if (stream.optional(']')) {
                return 93;
            }
            if (stream.optional('(')) {
                return 40;
            }
            if (stream.optional(')')) {
                return 41;
            }
            if (stream.optional('.')) {
                return 46;
            }
            if (stream.optional('+')) {
                return 43;
            }
            if (stream.optional('-')) {
                return 45;
            }
            if (stream.optional('\\')) {
                return 92;
            }
            if (stream.optional('{')) {
                return 123;
            }
            if (stream.optional('}')) {
                return 125;
            }
            if (stream.optional('?')) {
                return 63;
            }
            if (stream.optional('*')) {
                return 42;
            }
            if (stream.optional('~')) {
                return 126;
            }
            if (stream.optional('|')) {
                return 124;
            }
            if (stream.optional('^')) {
                return 94;
            }
            throw new IllegalArgumentException("Invalid character: " + stream.next());
        }
        if (stream.peek('[') || stream.peek(']') || stream.peek('(') || stream.peek(')') || stream.peek('{') || stream.peek('}') || stream.peek('.') || stream.peek('-') || stream.peek('+') || stream.peek('?') || stream.peek('*')) {
            throw new IllegalArgumentException("Invalid character: " + stream.next());
        }
        return stream.next();
    }

    private int processInt(CharStream stream) {
        int data = stream.optional('0', '9') - 48;
        if (data < 0) {
            return -1;
        }
        char ch = stream.optional('0', '9');
        while (ch != '\u0000') {
            data = data * 10 + (ch - 48);
            ch = stream.optional('0', '9');
        }
        return data;
    }

    private class NodeSet {
        private NFAState[] nodes;

        public NodeSet(HashSet<NFAState> nodes) {
            this.nodes = new NFAState[nodes.size()];
            int i = 0;
            for (NFAState node : nodes) {
                this.nodes[i++] = node;
            }
            Arrays.sort(this.nodes, Comparator.comparingInt(o -> ((NFAState)o).index));
        }

        public int hashCode() {
            return Arrays.hashCode(this.nodes);
        }

        public boolean equals(Object other) {
            return other.getClass() == NodeSet.class && Arrays.equals(this.nodes, ((NodeSet)other).nodes);
        }
    }

    private static class Partial {
        private int tailLabel;
        private NFAState tail;
        private NFAState head;

        public Partial(int tailLabel, NFAState tail, NFAState head) {
            this.tailLabel = tailLabel;
            this.tail = tail;
            this.head = head;
        }

        public Partial duplicate() {
            HashMap<NFAState, NFAState> nodes = new HashMap<NFAState, NFAState>();
            LinkedList<NFAState> todo = new LinkedList<NFAState>();
            todo.add(this.tail);
            nodes.put(this.tail, new NFAState());
            while (!todo.isEmpty()) {
                NFAState node = (NFAState)todo.poll();
                for (NFAState.Transition t : node.transitions) {
                    if (!nodes.containsKey(t.next)) {
                        nodes.put(t.next, new NFAState());
                        todo.add(t.next);
                    }
                    ((NFAState)nodes.get(node)).addTransition(t.label, (NFAState)nodes.get(t.next));
                }
            }
            return new Partial(this.tailLabel, (NFAState)nodes.get(this.tail), (NFAState)nodes.get(this.head));
        }
    }

    public static class NFAState {
        private static int counter = 1;
        private ArrayList<Transition> transitions;
        private ArrayList<NFAState> closure;
        private int index;
        private int finalCode = Integer.MIN_VALUE;

        public NFAState() {
            this.transitions = new ArrayList();
            this.index = counter++;
        }

        public void addTransition(int label, NFAState next) {
            this.transitions.add(new Transition(label, next));
        }

        public void setFinal(int finalCode) {
            if (this.finalCode == finalCode) {
                return;
            }
            this.finalCode = finalCode;
            this.transitions.stream().filter(t -> ((Transition)t).label == -2147483647).forEach(t -> ((Transition)t).next.setFinal(finalCode));
        }

        private void closure(HashSet<NFAState> output) {
            output.addAll(this.closure());
        }

        private ArrayList<NFAState> closure() {
            if (this.closure == null) {
                HashSet<NFAState> tmp = new HashSet<NFAState>();
                tmp.add(this);
                for (Transition transition : this.transitions) {
                    if (transition.label != -2147483647 || tmp.contains(transition.next)) continue;
                    tmp.add(transition.next);
                    transition.next.closure(tmp);
                }
                this.closure = new ArrayList();
                this.closure.addAll(tmp);
            }
            return this.closure;
        }

        private void edge(int label, HashSet<NFAState> output) {
            this.transitions.stream().filter(transition -> ((Transition)transition).label == label).filter(transition -> !output.contains(((Transition)transition).next)).forEach(transition -> {
                output.add(((Transition)transition).next);
                ((Transition)transition).next.closure(output);
            });
        }

        private void alphabet(HashSet<Integer> output) {
            for (NFAState node : this.closure()) {
                for (Transition t : node.transitions) {
                    if (t.label == -2147483647) continue;
                    output.add(t.label);
                }
            }
        }

        private class Transition {
            private int label;
            private NFAState next;

            public Transition(int input, NFAState next) {
                this.label = input;
                this.next = next;
            }
        }
    }
}

