/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Config;

import CustomOreGen.Config.ParserException;
import CustomOreGen.Config.ValidatorNode;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import org.w3c.dom.Node;

public class ValidatorBlockDescriptor
extends ValidatorNode {
    public String blocks = null;
    public float weight = 1.0f;
    public NBTTagCompound nbt;

    protected ValidatorBlockDescriptor(ValidatorNode parent, Node node) {
        super(parent, node);
    }

    @Override
    protected boolean validateChildren() throws ParserException {
        super.validateChildren();
        this.blocks = this.validateRequiredAttribute(String.class, "Block", true);
        this.weight = this.validateNamedAttribute(Float.class, "Weight", Float.valueOf(this.weight), true).floatValue();
        String nbtJson = this.validateNamedAttribute(String.class, "NBT", null, true);
        if (nbtJson != null) {
            try {
                NBTBase base = JsonToNBT.func_150315_a((String)nbtJson);
                if (!(base instanceof NBTTagCompound)) {
                    throw new ParserException("NBT is not a compound tag");
                }
                this.nbt = (NBTTagCompound)base;
            }
            catch (NBTException e) {
                throw new ParserException("Failed to parse JSON", (Exception)((Object)e));
            }
        }
        return true;
    }

    public static class Factory
    implements ValidatorNode.IValidatorFactory<ValidatorBlockDescriptor> {
        @Override
        public ValidatorBlockDescriptor createValidator(ValidatorNode parent, Node node) {
            return new ValidatorBlockDescriptor(parent, node);
        }
    }
}

