/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Config;

import CustomOreGen.Config.LineAwareSAXHandler;
import CustomOreGen.Config.ParserException;
import CustomOreGen.Config.ValidatorNode;
import CustomOreGen.Config.ValidatorUnchecked;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

public class ValidatorImport
extends ValidatorNode {
    protected boolean required = true;

    protected ValidatorImport(ValidatorNode parent, Node node, boolean required) {
        super(parent, node);
        this.required = required;
    }

    @Override
    protected boolean validateChildren() throws ParserException {
        super.validateChildren();
        File currentFile = (File)this.getNode().getOwnerDocument().getUserData("value");
        File baseDirectory = currentFile.getParentFile();
        String fileName = this.validateRequiredAttribute(String.class, "file", true);
        List<File> files = ValidatorImport.getMatchingFiles(baseDirectory, fileName);
        this.getNode().setUserData("validated", true, null);
        this.checkChildrenValid();
        if (files.isEmpty()) {
            if (this.required) {
                throw new ParserException("No files found matching '" + fileName + "'.", this.getNode());
            }
            this.replaceWithNode(new Node[0]);
        } else {
            ArrayList<Element> contents = new ArrayList<Element>(files.size());
            for (File file : files) {
                Element importRoot = this.getNode().getOwnerDocument().createElement("ImportedDoc");
                this.getNode().appendChild(importRoot);
                importRoot.setUserData("value", file, null);
                try {
                    this.getParser().saxParser.parse(file, (DefaultHandler)new LineAwareSAXHandler(importRoot));
                }
                catch (Exception var10) {
                    throw new ParserException(var10.getMessage(), this.getNode(), var10);
                }
                new ValidatorUnchecked(this, (Node)importRoot).validate();
                contents.add(importRoot);
            }
            this.replaceWithNodeContents(contents.toArray(new Node[contents.size()]));
        }
        return false;
    }

    private static List<File> getMatchingFiles(File baseDir, String relPath) {
        List<File> files = Arrays.asList((baseDir == null ? new File("") : baseDir).getAbsoluteFile());
        Stack<String> subPaths = new Stack<String>();
        for (File subPath = new File(relPath); subPath != null; subPath = subPath.getParentFile()) {
            subPaths.push(subPath.getName());
        }
        while (!subPaths.isEmpty()) {
            String var12 = (String)subPaths.pop();
            LinkedList<File> nextFiles = new LinkedList<File>();
            for (File dir : files) {
                File[] file;
                if (!var12.contains("*") && !var12.contains("?")) {
                    File var13 = new File(dir, var12);
                    if (!var13.exists()) continue;
                    nextFiles.add(var13);
                    continue;
                }
                if (!dir.isDirectory()) continue;
                for (File file1 : file = dir.listFiles(new WildcardFileFilter(var12))) {
                    if (!file1.exists()) continue;
                    nextFiles.add(file1);
                }
            }
            files = nextFiles;
        }
        return files;
    }

    private static class WildcardFileFilter
    implements FilenameFilter {
        private Pattern _pattern;

        public WildcardFileFilter(String pattern) {
            this._pattern = Pattern.compile("\\Q" + pattern.replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q") + "\\E");
        }

        @Override
        public boolean accept(File dir, String fileName) {
            return this._pattern.matcher(fileName).matches();
        }
    }

    public static class Factory
    implements ValidatorNode.IValidatorFactory<ValidatorImport> {
        private final boolean _required;

        public Factory(boolean required) {
            this._required = required;
        }

        @Override
        public ValidatorImport createValidator(ValidatorNode parent, Node node) {
            return new ValidatorImport(parent, node, this._required);
        }
    }
}

