/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen;

import CustomOreGen.Client.ClientState;
import CustomOreGen.CustomPacketPayload;
import CustomOreGen.GeometryData;
import CustomOreGen.GeometryRequestData;
import CustomOreGen.Server.ServerState;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.Serializable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class CustomPacketPayloadHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientCustomPayload(FMLNetworkEvent.ClientCustomPacketEvent event) {
        CustomPacketPayload payload;
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (mc.field_71441_e != null && ClientState.hasWorldChanged((World)mc.field_71441_e)) {
            ClientState.onWorldChanged((World)mc.field_71441_e);
        }
        if ((payload = CustomPacketPayload.decodePacket(event.packet)) != null) {
            switch (payload.type) {
                case DebuggingGeometryData: {
                    ClientState.addDebuggingGeometry((GeometryData)payload.data);
                    break;
                }
                case DebuggingGeometryRenderMode: {
                    String strMode = (String)((Object)payload.data);
                    if ("_DISABLE_".equals(strMode)) {
                        ClientState.dgEnabled = false;
                        return;
                    }
                    if (strMode != null) {
                        ClientState.WireframeRenderMode idx = null;
                        for (ClientState.WireframeRenderMode mode : ClientState.WireframeRenderMode.values()) {
                            if (!mode.name().equalsIgnoreCase(strMode)) continue;
                            idx = mode;
                            break;
                        }
                        if (idx != null) {
                            ClientState.dgRenderingMode = idx;
                        } else {
                            player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7cError: Invalid wireframe mode '" + strMode + "'"));
                        }
                    } else {
                        int var11 = ClientState.dgRenderingMode == null ? 0 : ClientState.dgRenderingMode.ordinal();
                        var11 = (var11 + 1) % ClientState.WireframeRenderMode.values().length;
                        ClientState.dgRenderingMode = ClientState.WireframeRenderMode.values()[var11];
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText("COG Client wireframe mode: " + ClientState.dgRenderingMode.name()));
                    break;
                }
                case DebuggingGeometryReset: {
                    ClientState.clearDebuggingGeometry();
                    break;
                }
                case CommandResponse: {
                    player.func_145747_a((IChatComponent)new ChatComponentText((String)((Object)payload.data)));
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled client packet type " + (Object)((Object)payload.type));
                }
            }
        }
    }

    @SubscribeEvent
    public void serverCustomPayload(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        World handlerWorld = player == null ? null : player.field_70170_p;
        ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), handlerWorld == null ? null : handlerWorld.func_72912_H());
        CustomPacketPayload payload = CustomPacketPayload.decodePacket(event.packet);
        if (payload != null) {
            switch (payload.type) {
                case DebuggingGeometryRequest: {
                    GeometryData geometryData = null;
                    if (player.field_71133_b.func_71203_ab().func_152596_g(player.func_146103_bH())) {
                        // empty if block
                    }
                    if ((geometryData = ServerState.getDebuggingGeometryData((GeometryRequestData)payload.data)) == null) {
                        new CustomPacketPayload(CustomPacketPayload.PayloadType.DebuggingGeometryRenderMode, (Serializable)((Object)"_DISABLE_")).sendToClient(player);
                        break;
                    }
                    new CustomPacketPayload(CustomPacketPayload.PayloadType.DebuggingGeometryData, geometryData).sendToClient(player);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled server packet type " + (Object)((Object)payload.type));
                }
            }
        }
    }
}

