/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen;

import CustomOreGen.Client.ClientState;
import CustomOreGen.CustomOreGenBase;
import CustomOreGen.CustomPacketPayload;
import CustomOreGen.CustomPacketPayloadHandler;
import CustomOreGen.ForgeInterface;
import CustomOreGen.Server.ConsoleCommands;
import CustomOreGen.Server.ServerState;
import CustomOreGen.Util.ConsoleCommand;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

@Mod(modid="CustomOreGen", useMetadata=true)
public class FMLInterface
implements IWorldGenerator {
    @Mod.Instance(value="CustomOreGen")
    public static FMLInterface instance;
    private Object _worldCreationGui = null;

    @Mod.EventHandler
    public void onFMLPreInit(FMLPreInitializationEvent event) {
        CustomOreGenBase.log = event.getModLog();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)Integer.MAX_VALUE);
        ForgeInterface.createAndRegister();
        CustomPacketPayload.registerChannels(new CustomPacketPayloadHandler());
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Mod.EventHandler
    public void onFMLPostInit(FMLPostInitializationEvent event) {
        CustomOreGenBase.onModPostLoad();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), null);
        this.registerCommands(event);
    }

    private void registerCommands(FMLServerStartingEvent event) {
        CustomOreGenBase.log.debug("Registering Console command interface ...");
        ConsoleCommands commands = new ConsoleCommands();
        for (Method method : ConsoleCommands.class.getMethods()) {
            if (method.getAnnotation(ConsoleCommand.CommandDelegate.class) == null) continue;
            event.registerServerCommand((ICommand)new ConsoleCommand(commands, method));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), world.func_72912_H());
        ServerState.onPopulateChunk(world, chunkX, chunkZ, random);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null && mc.field_71462_r != null) {
            if (mc.field_71462_r instanceof GuiCreateWorld) {
                if (this._worldCreationGui == null) {
                    this._worldCreationGui = mc.field_71462_r;
                }
                ServerState.onWorldCreationMenuTick((GuiCreateWorld)mc.field_71462_r);
            } else if (this._worldCreationGui != null && (mc.field_71462_r instanceof GuiSelectWorld || mc.field_71462_r instanceof GuiMainMenu)) {
                this._worldCreationGui = null;
                ServerState.onWorldCreationMenuTick(null);
            }
        } else if (this._worldCreationGui != null) {
            this._worldCreationGui = null;
            ServerState.onWorldCreationMenuTick(null);
        }
        if (mc.field_71441_e != null && ClientState.hasWorldChanged((World)mc.field_71441_e)) {
            ClientState.onWorldChanged((World)mc.field_71441_e);
        }
    }

    @SubscribeEvent
    public void onClientLogin(PlayerEvent.PlayerLoggedInEvent event) {
        World handlerWorld = event.player == null ? null : event.player.field_70170_p;
        ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), handlerWorld == null ? null : handlerWorld.func_72912_H());
    }

    private static ModContainer getModContainer() {
        return FMLCommonHandler.instance().findContainerFor((Object)instance);
    }

    public static String getDisplayString() {
        ModContainer metadata = FMLInterface.getModContainer();
        return metadata.getName() + " " + metadata.getVersion();
    }
}

