/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Server;

import CustomOreGen.Server.DistributionSettingMap;
import CustomOreGen.Server.MapGenOreDistribution;
import CustomOreGen.Util.HeightScaledPDist;
import CustomOreGen.Util.IGeometryBuilder;
import CustomOreGen.Util.NoiseGenerator;
import CustomOreGen.Util.PDist;
import CustomOreGen.Util.Transform;
import CustomOreGen.Util.WireframeShapes;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class MapGenCloud
extends MapGenOreDistribution {
    @DistributionSettingMap.DistributionSetting(name="CloudRadius", info="Cloud horizontal radius, in meters")
    public final PDist clRadius = new PDist(25.0f, 10.0f);
    @DistributionSettingMap.DistributionSetting(name="CloudThickness", info="Cloud thickness (vertical radius), in meters")
    public final HeightScaledPDist clThickness = new HeightScaledPDist(14.0f, 6.0f);
    @DistributionSettingMap.DistributionSetting(name="CloudSizeNoise", info="Noise level added to cloud radius and thickness")
    public final PDist clSizeNoise = new PDist(0.2f, 0.0f);
    @DistributionSettingMap.DistributionSetting(name="CloudHeight", info="Height of cloud, in meters")
    public final HeightScaledPDist clHeight = new HeightScaledPDist(32.0f, 16.0f, PDist.Type.normal);
    @DistributionSettingMap.DistributionSetting(name="CloudInclination", info="Cloud angle from horizontal plane, in radians")
    public final PDist clInclination = new PDist(0.0f, 0.35f);
    @DistributionSettingMap.DistributionSetting(name="OreRadiusMult", info="Radius multiplier for individual ore blocks")
    public final PDist orRadiusMult = new PDist(1.0f, 0.1f);
    @DistributionSettingMap.DistributionSetting(name="OreDensity", info="Density multiplier for individual ore blocks")
    public final HeightScaledPDist orDensity = new HeightScaledPDist(0.1f, 0.0f);
    @DistributionSettingMap.DistributionSetting(name="OreVolumeNoiseCutoff", info="Minimum threshold for density noise on individual ore blocks")
    public final PDist orVolumeNoiseCutoff = new PDist(0.5f, 0.0f);
    protected static final DistributionSettingMap _cloudSettingsMap = new DistributionSettingMap(MapGenCloud.class);

    public MapGenCloud(int distributionID, boolean canGenerate) {
        super(_cloudSettingsMap, distributionID, canGenerate);
        this.name = "Cloud_" + distributionID;
        this.frequency.set(0.001f, 0.0f, PDist.Type.uniform);
    }

    @Override
    public boolean validate() throws IllegalStateException {
        float r = Math.max(this.clRadius.getMax(), this.clThickness.pdist.getMax());
        r *= 1.0f + this.clSizeNoise.getMax() * 2.0f;
        this.field_75040_a = (int)((r *= this.orRadiusMult.getMax()) + 15.9999f) / 16;
        return super.validate();
    }

    @Override
    public MapGenOreDistribution.Component generateStructure(MapGenOreDistribution.StructureGroup structureGroup, Random random) {
        float clZ;
        float clY;
        float clX = (random.nextFloat() + (float)structureGroup.chunkX) * 16.0f;
        if (!structureGroup.canPlaceComponentAt(0, clX, clY = this.clHeight.getValue(random, this.field_75039_c, clX, clZ = (random.nextFloat() + (float)structureGroup.chunkZ) * 16.0f) + this.heightOffset.getValue(random), clZ, random)) {
            return null;
        }
        Transform clMat = new Transform();
        clMat.translate(clX, clY, clZ);
        clMat.rotateZInto(0.0f, 1.0f, 0.0f);
        clMat.rotateZ(random.nextFloat() * ((float)Math.PI * 2));
        clMat.rotateY(this.clInclination.getValue(random));
        float thickness = this.clThickness.getValue(random, this.field_75039_c, clX, clZ);
        clMat.scale(this.clRadius.getValue(random), this.clRadius.getValue(random), thickness);
        DiffuseCloudComponent cloud = new DiffuseCloudComponent(this, structureGroup, clMat, random);
        structureGroup.addComponent(cloud, null);
        return cloud;
    }

    public String func_143025_a() {
        return "COG:Cloud";
    }

    @Override
    public double getAverageOreCount() {
        float radius = this.clRadius.mean * this.orRadiusMult.mean;
        float thickness = this.clThickness.pdist.mean * this.orRadiusMult.mean;
        float v = 1.3333334f * radius * radius * thickness;
        PDist simplex = new PDist(0.5f, 0.1f, PDist.Type.normal);
        double aboveNoiseCutoff = 1.0f - simplex.cdf(this.orVolumeNoiseCutoff.mean);
        return (double)(v * this.orDensity.pdist.mean) * aboveNoiseCutoff;
    }

    private class DiffuseCloudComponent
    extends MapGenOreDistribution.Component {
        protected final Transform mat;
        protected final Transform invMat;
        protected final NoiseGenerator noiseGen;
        protected final float sizeNoiseMagnitude;
        protected final int noiseLevels;

        public DiffuseCloudComponent(MapGenCloud var1, MapGenOreDistribution.StructureGroup structureGroup, Transform transform, Random random) {
            super(MapGenCloud.this, structureGroup);
            this.noiseGen = new NoiseGenerator(random);
            this.sizeNoiseMagnitude = Math.abs(var1.clSizeNoise.getValue(random));
            float rMax = (1.0f + this.sizeNoiseMagnitude * 2.0f) * var1.orRadiusMult.getMax();
            if (rMax < 0.0f) {
                rMax = 0.0f;
            }
            float[] bb = new float[]{-rMax, -rMax, -rMax, rMax, rMax, rMax};
            transform.transformBB(bb);
            this.field_74887_e = new StructureBoundingBox(MathHelper.func_76141_d((float)bb[0]), MathHelper.func_76141_d((float)bb[1]), MathHelper.func_76141_d((float)bb[2]), MathHelper.func_76141_d((float)bb[3]) + 1, MathHelper.func_76141_d((float)bb[4]) + 1, MathHelper.func_76141_d((float)bb[5]) + 1);
            float maxSize = (float)Math.max(this.field_74887_e.func_78883_b(), Math.max(this.field_74887_e.func_78882_c(), this.field_74887_e.func_78880_d())) * 0.2f;
            this.noiseLevels = maxSize <= 1.0f ? 0 : (int)(Math.log(maxSize) / Math.log(2.0) + 0.5);
            this.mat = transform.clone();
            this.invMat = transform.determinant() != 0.0f ? transform.inverse() : null;
        }

        public float getNoise(float x, float y, float z) {
            double noise = 0.0;
            for (int i = 0; i < this.noiseLevels; ++i) {
                float im = 1 << i;
                noise += (double)(1.0f / im) * this.noiseGen.noise(x * im, y * im, z * im);
            }
            return (float)noise;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox bounds) {
            if (this.invMat == null) {
                return true;
            }
            float maxR = Math.max(MapGenCloud.this.orRadiusMult.getMax(), 0.0f);
            float minR = Math.max(MapGenCloud.this.orRadiusMult.getMin(), 0.0f);
            float maxNoisyR2 = maxR * (1.0f + this.sizeNoiseMagnitude * 2.0f);
            float minNoisyR2 = minR * (1.0f - this.sizeNoiseMagnitude * 2.0f);
            maxNoisyR2 *= maxNoisyR2;
            minNoisyR2 *= minNoisyR2;
            float[] pos = new float[3];
            for (int x = Math.max(this.field_74887_e.field_78897_a, bounds.field_78897_a); x <= Math.min(this.field_74887_e.field_78893_d, bounds.field_78893_d); ++x) {
                for (int y = Math.min(this.field_74887_e.field_78894_e, bounds.field_78894_e); y >= Math.max(this.field_74887_e.field_78895_b, bounds.field_78895_b); --y) {
                    for (int z = Math.max(this.field_74887_e.field_78896_c, bounds.field_78896_c); z <= Math.min(this.field_74887_e.field_78892_f, bounds.field_78892_f); ++z) {
                        pos[0] = (float)x + 0.5f;
                        pos[1] = (float)y + 0.5f;
                        pos[2] = (float)z + 0.5f;
                        this.invMat.transformVector(pos);
                        float r2 = pos[0] * pos[0] + pos[1] * pos[1] + pos[2] * pos[2];
                        if (!(r2 <= maxNoisyR2)) continue;
                        if (r2 > minNoisyR2) {
                            float r = MathHelper.func_76129_c((float)r2);
                            float mult = 1.0f;
                            mult = r > 0.0f ? (mult += this.sizeNoiseMagnitude * this.getNoise(pos[0] / r, pos[1] / r, pos[2] / r)) : (mult += this.sizeNoiseMagnitude * this.getNoise(0.0f, 0.0f, 0.0f));
                            if (mult <= 0.0f || (r /= mult) > maxR || r > minR && r > MapGenCloud.this.orRadiusMult.getValue(random)) continue;
                        }
                        if (!(MapGenCloud.this.orVolumeNoiseCutoff.getMin() <= 1.0f) || !(MapGenCloud.this.orVolumeNoiseCutoff.getMax() <= 0.0f) && !((this.getNoise(pos[0], pos[1], pos[2]) + 1.0f) / 2.0f >= MapGenCloud.this.orVolumeNoiseCutoff.getValue(random)) || MapGenCloud.this.orDensity.getIntValue(random, world, x, z) < 1) continue;
                        this.attemptPlaceBlock(world, random, x, y, z, bounds);
                    }
                }
            }
            super.func_74875_a(world, random, bounds);
            return true;
        }

        @Override
        public void buildWireframe(IGeometryBuilder gb) {
            super.buildWireframe(gb);
            if (MapGenCloud.this.wfHasWireframe && this.mat != null) {
                float mult;
                int s;
                int offset;
                int segments;
                int stacks = segments = Math.max(8, (1 << this.noiseLevels) * 4);
                gb.setPositionTransform(this.mat);
                gb.setVertexMode(IGeometryBuilder.PrimitiveType.QUAD, segments + 1, segments + 2, 1);
                float[][] xycoords = WireframeShapes.getCirclePoints(segments, null);
                float[][] zcoords = WireframeShapes.getCirclePoints(2 * segments, null);
                float[] pos = new float[3];
                for (offset = 1; offset < stacks; ++offset) {
                    for (s = 0; s < segments; ++s) {
                        pos[0] = zcoords[offset][1] * xycoords[s][0];
                        pos[1] = zcoords[offset][1] * xycoords[s][1];
                        pos[2] = zcoords[offset][0];
                        mult = 1.0f + this.sizeNoiseMagnitude * this.getNoise(pos[0], pos[1], pos[2]);
                        pos[0] = pos[0] * mult;
                        pos[1] = pos[1] * mult;
                        pos[2] = pos[2] * mult;
                        gb.addVertex(pos);
                    }
                    gb.addVertexRef(segments);
                }
                gb.setVertexMode(IGeometryBuilder.PrimitiveType.TRIANGLE, 1);
                offset = (segments + 1) * (stacks - 2) + 1;
                gb.addVertexRef(offset);
                for (s = 1; s <= segments; ++s) {
                    if (s == 1) {
                        pos[0] = 0.0f;
                        pos[1] = 0.0f;
                        pos[2] = 1.0f;
                        mult = 1.0f + this.sizeNoiseMagnitude * this.getNoise(pos[0], pos[1], pos[2]);
                        pos[0] = pos[0] * mult;
                        pos[1] = pos[1] * mult;
                        pos[2] = pos[2] * mult;
                        gb.addVertex(pos);
                    } else {
                        gb.addVertexRef(2);
                    }
                    gb.addVertexRef(offset + 3 * s);
                }
                gb.setVertexMode(IGeometryBuilder.PrimitiveType.TRIANGLE, 1);
                offset = 3 * segments + 2;
                gb.addVertexRef(offset);
                for (s = 1; s <= segments; ++s) {
                    if (s == 1) {
                        pos[0] = 0.0f;
                        pos[1] = 0.0f;
                        pos[2] = -1.0f;
                        mult = 1.0f + this.sizeNoiseMagnitude * this.getNoise(pos[0], pos[1], pos[2]);
                        pos[0] = pos[0] * mult;
                        pos[1] = pos[1] * mult;
                        pos[2] = pos[2] * mult;
                        gb.addVertex(pos);
                    } else {
                        gb.addVertexRef(2);
                    }
                    gb.addVertexRef(offset + s);
                }
            }
        }
    }
}

