/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Server;

import CustomOreGen.Server.DistributionSettingMap;
import CustomOreGen.Server.MapGenOreDistribution;
import CustomOreGen.Util.HeightScaledPDist;
import CustomOreGen.Util.IGeometryBuilder;
import CustomOreGen.Util.PDist;
import CustomOreGen.Util.Transform;
import CustomOreGen.Util.VolumeHelper;
import CustomOreGen.Util.WireframeShapes;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class MapGenClusters
extends MapGenOreDistribution {
    @DistributionSettingMap.DistributionSetting(name="Size", info="Roughly the number of blocks in every deposit.  No range.")
    public final PDist clSize = new PDist(8.0f, 0.0f);
    @DistributionSettingMap.DistributionSetting(name="Frequency", info="Number of deposits per 16x16 chunk.  No range.")
    public final HeightScaledPDist clFreq = this.frequency;
    @DistributionSettingMap.DistributionSetting(name="Height", info="Vertical height of the deposits.  Normal distributions are approximated.")
    public final HeightScaledPDist clHeight = new HeightScaledPDist(64.0f, 64.0f, PDist.Type.uniform);
    protected static final DistributionSettingMap _clusterSettingsMap = new DistributionSettingMap(MapGenClusters.class);

    public MapGenClusters(int distributionID, boolean canGenerate) {
        super(_clusterSettingsMap, distributionID, canGenerate);
        this.name = "StandardGen_" + distributionID;
        this.frequency.set(20.0f, 0.0f, PDist.Type.uniform);
    }

    @Override
    public boolean validate() throws IllegalStateException {
        int maxClusterSize = (int)Math.ceil(this.clSize.getMax() / 4.0f);
        this.field_75040_a = (maxClusterSize + 15) / 16;
        return super.validate();
    }

    @Override
    public MapGenOreDistribution.Component generateStructure(MapGenOreDistribution.StructureGroup structureGroup, Random random) {
        float clZ;
        float clY;
        float clX = (random.nextFloat() + (float)structureGroup.chunkX) * 16.0f;
        if (!structureGroup.canPlaceComponentAt(0, clX, clY = this.clHeight.getValue(random, this.field_75039_c, clX, clZ = (random.nextFloat() + (float)structureGroup.chunkZ) * 16.0f) + this.heightOffset.getValue(random), clZ, random)) {
            return null;
        }
        ClusterComponent cluster = new ClusterComponent(structureGroup, clX, clY, clZ, random);
        structureGroup.addComponent(cluster, null);
        return cluster;
    }

    public String func_143025_a() {
        return "COG:Clusters";
    }

    private static float adjustRadius(double baseRadius, double fraction) {
        return (float)((Math.sin(fraction * Math.PI) + 1.0) * baseRadius + 0.5);
    }

    @Override
    public double getAverageOreCount() {
        int segLen = MathHelper.func_76123_f((float)(this.clSize.mean / 8.0f)) * 2;
        double volume = 0.0;
        for (int s = 0; s < segLen; ++s) {
            float rad = MapGenClusters.adjustRadius(this.clSize.mean / 64.0f, (double)s / (double)segLen);
            volume += VolumeHelper.cylindricalVolume(1.0, rad);
        }
        return volume;
    }

    private class ClusterComponent
    extends MapGenOreDistribution.Component {
        protected final int size;
        protected final float[] ptA;
        protected final float[] ptB;
        protected final float[] rad;

        public ClusterComponent(MapGenOreDistribution.StructureGroup structureGroup, float x, float y, float z, Random random) {
            super(structureGroup);
            this.size = Math.max(0, MapGenClusters.this.clSize.getIntValue(random));
            double horizAngle = (double)random.nextFloat() * Math.PI;
            this.ptA = new float[3];
            this.ptB = new float[3];
            float segmentXOffset = (float)Math.sin(horizAngle) * (float)this.size / 8.0f;
            float segmentZOffset = (float)Math.cos(horizAngle) * (float)this.size / 8.0f;
            this.ptA[0] = x + segmentXOffset;
            this.ptB[0] = x - segmentXOffset;
            this.ptA[2] = z + segmentZOffset;
            this.ptB[2] = z - segmentZOffset;
            this.ptA[1] = y + (float)random.nextInt(3) - 2.0f;
            this.ptB[1] = y + (float)random.nextInt(3) - 2.0f;
            this.field_74887_e = StructureBoundingBox.func_78887_a();
            this.rad = new float[this.size + 1];
            for (int s = 0; s < this.rad.length; ++s) {
                float ns = (float)s / (float)(this.rad.length - 1);
                float baseRadius = (float)random.nextDouble() * (float)this.size / 32.0f;
                this.rad[s] = MapGenClusters.adjustRadius(baseRadius, ns);
                float xCenter = this.ptA[0] + (this.ptB[0] - this.ptA[0]) * ns;
                float yCenter = this.ptA[1] + (this.ptB[1] - this.ptA[1]) * ns;
                float zCenter = this.ptA[2] + (this.ptB[2] - this.ptA[2]) * ns;
                this.field_74887_e.field_78897_a = Math.min(this.field_74887_e.field_78897_a, MathHelper.func_76141_d((float)(xCenter - this.rad[s])));
                this.field_74887_e.field_78895_b = Math.min(this.field_74887_e.field_78895_b, MathHelper.func_76141_d((float)(yCenter - this.rad[s])));
                this.field_74887_e.field_78896_c = Math.min(this.field_74887_e.field_78896_c, MathHelper.func_76141_d((float)(zCenter - this.rad[s])));
                this.field_74887_e.field_78893_d = Math.max(this.field_74887_e.field_78893_d, MathHelper.func_76123_f((float)(xCenter + this.rad[s])));
                this.field_74887_e.field_78894_e = Math.max(this.field_74887_e.field_78894_e, MathHelper.func_76123_f((float)(yCenter + this.rad[s])));
                this.field_74887_e.field_78892_f = Math.max(this.field_74887_e.field_78892_f, MathHelper.func_76123_f((float)(zCenter + this.rad[s])));
            }
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox bounds) {
            for (int s = 0; s < this.rad.length; ++s) {
                float ns = (float)s / (float)(this.rad.length - 1);
                float xCenter = this.ptA[0] + (this.ptB[0] - this.ptA[0]) * ns;
                float yCenter = this.ptA[1] + (this.ptB[1] - this.ptA[1]) * ns;
                float zCenter = this.ptA[2] + (this.ptB[2] - this.ptA[2]) * ns;
                int xMin = Math.max(MathHelper.func_76141_d((float)(xCenter - this.rad[s])), bounds.field_78897_a);
                int xMax = Math.min(MathHelper.func_76141_d((float)(xCenter + this.rad[s])), bounds.field_78893_d);
                int yMin = Math.max(MathHelper.func_76141_d((float)(yCenter - this.rad[s])), bounds.field_78895_b);
                int yMax = Math.min(MathHelper.func_76123_f((float)(yCenter + this.rad[s])), bounds.field_78894_e);
                int zMin = Math.max(MathHelper.func_76123_f((float)(zCenter - this.rad[s])), bounds.field_78896_c);
                int zMax = Math.min(MathHelper.func_76123_f((float)(zCenter + this.rad[s])), bounds.field_78892_f);
                for (int tgtX = xMin; tgtX <= xMax; ++tgtX) {
                    double normXDist = ((double)tgtX + 0.5 - (double)xCenter) / (double)this.rad[s];
                    if (!(normXDist * normXDist < 1.0)) continue;
                    for (int tgtY = yMin; tgtY <= yMax; ++tgtY) {
                        double normYDist = ((double)tgtY + 0.5 - (double)yCenter) / (double)this.rad[s];
                        if (!(normXDist * normXDist + normYDist * normYDist < 1.0)) continue;
                        for (int tgtZ = zMin; tgtZ <= zMax; ++tgtZ) {
                            double normZDist = ((double)tgtZ + 0.5 - (double)zCenter) / (double)this.rad[s];
                            if (!(normXDist * normXDist + normYDist * normYDist + normZDist * normZDist < 1.0)) continue;
                            this.attemptPlaceBlock(world, random, tgtX, tgtY, tgtZ, bounds);
                        }
                    }
                }
            }
            super.func_74875_a(world, random, bounds);
            return true;
        }

        @Override
        public void buildWireframe(IGeometryBuilder gb) {
            super.buildWireframe(gb);
            if (MapGenClusters.this.wfHasWireframe) {
                gb.setPositionTransform(null);
                gb.setVertexMode(IGeometryBuilder.PrimitiveType.LINE, new int[0]);
                gb.addVertex(this.ptA);
                gb.addVertex(this.ptB);
                float segLenX = this.ptB[0] - this.ptA[0];
                float segLenY = this.ptB[1] - this.ptA[1];
                float segLenZ = this.ptB[2] - this.ptA[2];
                float segLen = (float)Math.sqrt(segLenX * segLenX + segLenY * segLenY + segLenZ * segLenZ);
                if (segLen == 0.0f) {
                    return;
                }
                int stepCount = MathHelper.func_76123_f((float)segLen);
                int circleSides = 8;
                float[][] pts = WireframeShapes.getCirclePoints(circleSides, null);
                float[] pos = new float[3];
                Transform trans = new Transform();
                gb.setVertexMode(IGeometryBuilder.PrimitiveType.QUAD, circleSides + 1, circleSides + 2, 1);
                for (int step = 0; step <= stepCount; ++step) {
                    if (step == 0) {
                        trans.translate(this.ptA[0], this.ptA[1], this.ptA[2]);
                        trans.rotateZInto(segLenX, segLenY, segLenZ);
                    } else {
                        trans.translate(0.0f, 0.0f, 1.0f);
                    }
                    gb.setPositionTransform(trans);
                    float radius = MapGenClusters.adjustRadius((float)this.size / 32.0f, (double)step / (double)stepCount);
                    for (int s = 0; s < circleSides; ++s) {
                        pos[0] = pts[s][0] * radius;
                        pos[1] = pts[s][1] * radius;
                        pos[2] = pts[s][2];
                        gb.addVertex(pos, pos, null, null);
                    }
                    gb.addVertexRef(circleSides);
                }
            }
        }
    }
}

