/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import CustomOreGen.Util.BlockDescriptor;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class BlockArrangement {
    private BlockDescriptor center;
    private BlockDescriptor above;
    private BlockDescriptor below;
    private BlockDescriptor beside;

    public BlockArrangement(BlockDescriptor center, BlockDescriptor above, BlockDescriptor below, BlockDescriptor beside) {
        this.center = center;
        this.above = above;
        this.below = below;
        this.beside = beside;
    }

    public boolean matchesAt(World world, Random rand, int x, int y, int z) {
        return this.descriptorMatchesAt(this.center, world, rand, x, y, z) && this.descriptorMatchesAt(this.above, world, rand, x, y + 1, z) && this.descriptorMatchesAt(this.below, world, rand, x, y - 1, z) && (this.descriptorMatchesAt(this.beside, world, rand, x + 1, y, z) || this.descriptorMatchesAt(this.beside, world, rand, x, y, z + 1) || this.descriptorMatchesAt(this.beside, world, rand, x - 1, y, z) || this.descriptorMatchesAt(this.beside, world, rand, x, y, z - 1));
    }

    private boolean descriptorMatchesAt(BlockDescriptor descriptor, World world, Random rand, int x, int y, int z) {
        if (descriptor.isEmpty()) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        int fastCheck = descriptor.matchesBlock_fast(block);
        if (fastCheck == -1) {
            return descriptor.matchesBlock(block, world.func_72805_g(x, y, z), rand);
        }
        return fastCheck == 1;
    }

    public BlockDescriptor getCenter() {
        return this.center;
    }

    public BlockDescriptor getAbove() {
        return this.above;
    }

    public BlockDescriptor getBelow() {
        return this.below;
    }

    public BlockDescriptor getBeside() {
        return this.beside;
    }
}

