/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import CustomOreGen.Server.DistributionSettingMap;
import CustomOreGen.Util.TileEntityHelper;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class BlockDescriptor
implements DistributionSettingMap.Copyable<BlockDescriptor> {
    protected LinkedList<Descriptor> _descriptors = new LinkedList();
    protected Map<BlockInfo, Match> _matches = new Hashtable<BlockInfo, Match>();
    protected boolean _compiled = false;
    protected float[] _fastMatch = new float[256];

    public BlockDescriptor() {
        this.clear();
    }

    public BlockDescriptor(String descriptor) {
        this.set(descriptor);
    }

    public BlockDescriptor(Block stone) {
        this.set(stone);
    }

    @Override
    public void copyFrom(BlockDescriptor source) {
        this._descriptors = new LinkedList<Descriptor>(source._descriptors);
        this._matches = new Hashtable<BlockInfo, Match>(source._matches);
        this._compiled = source._compiled;
        this._fastMatch = (float[])source._fastMatch.clone();
    }

    public BlockDescriptor set(Block block) {
        return this.set(Block.field_149771_c.func_148750_c((Object)block));
    }

    public BlockDescriptor set(String descriptor) {
        this.clear();
        if (descriptor != null) {
            this.add(descriptor);
        }
        return this;
    }

    public BlockDescriptor add(String descriptor) {
        return this.add(descriptor, 1.0f, false, false, false, null);
    }

    public BlockDescriptor add(String descriptor, float weight, NBTTagCompound nbt) {
        return this.add(descriptor, weight, false, false, false, nbt);
    }

    public BlockDescriptor add(String descriptor, float weight, boolean describesOre, boolean matchFirst, boolean regexp, NBTTagCompound nbt) {
        if (descriptor != null && weight != 0.0f) {
            this._compiled = false;
            this._descriptors.add(new Descriptor(descriptor, weight, describesOre, matchFirst, regexp, nbt));
        }
        return this;
    }

    public BlockDescriptor clear() {
        this._compiled = false;
        this._descriptors.clear();
        return this;
    }

    public List<Descriptor> getDescriptors() {
        return Collections.unmodifiableList(this._descriptors);
    }

    private void add(Block block, int metadata, NBTTagCompound nbt, float weight) {
        if (nbt != null && !block.hasTileEntity(metadata)) {
            throw new IllegalArgumentException("NBT specified, but matching block " + block.func_149739_a() + ":" + metadata + " lacks tile entity");
        }
        if (weight != 0.0f) {
            BlockInfo key = new BlockInfo(block, metadata, nbt);
            Match match = this._matches.get(key);
            match = match != null ? new Match(match.weight + weight) : new Match(weight);
            this._matches.put(key, match);
            int blockID = Block.func_149682_b((Block)block);
            if (blockID >= 0 && blockID < this._fastMatch.length) {
                if (metadata == Short.MAX_VALUE && !Float.isNaN(this._fastMatch[blockID])) {
                    int n = blockID;
                    this._fastMatch[n] = this._fastMatch[n] + weight;
                } else {
                    this._fastMatch[blockID] = Float.NaN;
                }
            }
        }
    }

    public void add(BlockDescriptor desc, float weight) {
        for (Descriptor d : desc._descriptors) {
            this.add(d.description, d.weight * weight, d.describesOre, d.matchFirst, d.regexp, d.nbt);
        }
    }

    protected void compileMatches() {
        if (!this._compiled) {
            this._compiled = true;
            this._matches.clear();
            Arrays.fill(this._fastMatch, 0.0f);
            block0: for (Descriptor desc : this._descriptors) {
                if (desc.describesOre) {
                    for (ItemStack ore : OreDictionary.getOres((String)desc.description)) {
                        Item oreItem = ore.func_77973_b();
                        if (oreItem instanceof ItemBlock) {
                            Block oreBlock = ((ItemBlock)oreItem).field_150939_a;
                            int meta = ore.func_77960_j();
                            NBTTagCompound nbt = ore.field_77990_d;
                            if (nbt == null && (nbt = TileEntityHelper.tryToCreateGTPrefixBlockNBT(ore)) != null) {
                                oreBlock = Block.func_149684_b((String)"gregtech:gt.meta.ore.normal.default");
                                meta = 2;
                            }
                            this.add(oreBlock, meta, nbt, desc.weight);
                        }
                        if (!desc.matchFirst) continue;
                        continue block0;
                    }
                    continue;
                }
                if (desc.regexp) {
                    FMLControlledNamespacedRegistry blocks = GameData.getBlockRegistry();
                    for (Block block : blocks) {
                        String name = Block.field_149771_c.func_148750_c((Object)block);
                        float[] weights = desc.regexMatch(name);
                        this.add(block, Short.MAX_VALUE, desc.nbt, weights[16]);
                        if (weights[16] > 0.0f && desc.matchFirst) continue block0;
                        boolean matched = false;
                        for (int m = 0; m < 16 && !matched; ++m) {
                            this.add(block, m, desc.nbt, weights[m]);
                            if (!(weights[m] > 0.0f) || !desc.matchFirst) continue;
                            matched = true;
                        }
                        if (!matched) continue;
                        continue block0;
                    }
                    continue;
                }
                Block block = Block.func_149684_b((String)desc.getBlockName());
                if (block == null) continue;
                this.add(block, desc.getMeta(), desc.nbt, desc.weight);
            }
        }
    }

    public Map<BlockInfo, Match> getMatches() {
        this.compileMatches();
        return Collections.unmodifiableMap(this._matches);
    }

    public float getWeight_fast(Block block) {
        this.compileMatches();
        int blockID = Block.func_149682_b((Block)block);
        return blockID >= 0 && blockID < this._fastMatch.length ? this._fastMatch[blockID] : Float.NaN;
    }

    public float getWeight(Block block, int metaData, NBTTagCompound nbt) {
        Match metaValue;
        this.compileMatches();
        float value = 0.0f;
        Match noMetaValue = this._matches.get(new BlockInfo(block, Short.MAX_VALUE, nbt));
        if (noMetaValue != null) {
            value = noMetaValue.weight;
        }
        if (metaData != Short.MAX_VALUE && (metaValue = this._matches.get(new BlockInfo(block, metaData, nbt))) != null) {
            value += metaValue.weight;
        }
        return value;
    }

    public int matchesBlock_fast(Block block) {
        float weight = this.getWeight_fast(block);
        return Float.isNaN(weight) ? -1 : (weight <= 0.0f ? 0 : (weight < 1.0f ? -1 : 1));
    }

    public boolean matchesBlock(Block block, int metaData, Random rand) {
        float weight = this.getWeight(block, metaData, null);
        if (weight <= 0.0f) {
            return false;
        }
        if (weight < 1.0f) {
            if (rand == null) {
                rand = new Random();
            }
            return rand.nextFloat() < weight;
        }
        return true;
    }

    public BlockInfo getMatchingBlock(Random rand) {
        this.compileMatches();
        float value = -1.0f;
        for (Map.Entry<BlockInfo, Match> entry : this._matches.entrySet()) {
            float weight = entry.getValue().weight;
            BlockInfo info = entry.getKey();
            if (info.getMetadata() == Short.MAX_VALUE) {
                info = new BlockInfo(info.getBlock(), 0, info.getNBT());
            }
            if (!(weight > 0.0f)) continue;
            if (weight >= 1.0f) {
                return info;
            }
            if (value < 0.0f) {
                if (rand == null) {
                    rand = new Random();
                }
                value = rand.nextFloat();
            }
            if (!((value -= weight) < 0.0f)) continue;
            return info;
        }
        return null;
    }

    public float getTotalMatchWeight() {
        this.compileMatches();
        float weight = 0.0f;
        for (Match m : this._matches.values()) {
            if (!(m.weight > 0.0f)) continue;
            weight += m.weight;
        }
        return weight;
    }

    public String toString() {
        switch (this._descriptors.size()) {
            case 0: {
                return "[no blocks]";
            }
            case 1: {
                return this._descriptors.get(0).toString();
            }
        }
        return this._descriptors.toString();
    }

    public String[] toDetailedString() {
        this.compileMatches();
        String[] breakdown = new String[this._matches.size() + 1];
        breakdown[0] = this._matches.size() + " block matches";
        if (this._matches.size() > 0) {
            breakdown[0] = breakdown[0] + ':';
        }
        int i = 1;
        for (Map.Entry<BlockInfo, Match> entry : this._matches.entrySet()) {
            float weight = entry.getValue().weight;
            int metaData = entry.getKey().getMetadata();
            Block block = entry.getKey().getBlock();
            breakdown[i] = Block.field_149771_c.func_148750_c((Object)block);
            if (metaData != Short.MAX_VALUE) {
                int n = i;
                breakdown[n] = breakdown[n] + ":" + metaData;
            }
            int n = i++;
            breakdown[n] = breakdown[n] + " (" + weight + ")";
        }
        return breakdown;
    }

    public boolean isEmpty() {
        return this._descriptors.isEmpty();
    }

    private class Descriptor {
        public final String description;
        public final float weight;
        public final boolean describesOre;
        public final boolean matchFirst;
        public final boolean regexp;
        public final NBTTagCompound nbt;
        private Pattern pattern = null;

        public Descriptor(String description, float weight, boolean describesOre, boolean matchFirst, boolean regexp, NBTTagCompound nbt) {
            this.description = description;
            this.weight = weight;
            this.describesOre = describesOre;
            this.matchFirst = matchFirst;
            this.regexp = regexp;
            this.nbt = nbt;
        }

        public Pattern getPattern() {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.description, 2);
            }
            return this.pattern;
        }

        public String getBlockName() {
            boolean hasMeta;
            boolean bl = hasMeta = this.description.indexOf(58) != this.description.lastIndexOf(58);
            if (hasMeta) {
                return this.description.substring(0, this.description.lastIndexOf(58));
            }
            return this.description;
        }

        public int getMeta() {
            boolean hasMeta;
            boolean bl = hasMeta = this.getBlockName().length() < this.description.length();
            if (hasMeta) {
                return Integer.valueOf(this.description.substring(this.getBlockName().length() + 1));
            }
            return Short.MAX_VALUE;
        }

        public float[] regexMatch(String name) {
            float[] weights = new float[17];
            if (!this.getPattern().matcher(name).matches()) {
                for (int m = 0; m < 16; ++m) {
                    if (!this.getPattern().matcher(name + ":" + m).matches()) continue;
                    int n = m;
                    weights[n] = weights[n] + this.weight;
                }
            } else {
                weights[16] = weights[16] + this.weight;
            }
            return weights;
        }

        public String toString() {
            return this.description + " - " + Float.toString(this.weight);
        }
    }

    private static class Match {
        public final float weight;

        public Match(float weight) {
            this.weight = weight;
        }
    }

    public static class BlockInfo {
        private Block block;
        private int metadata;
        private NBTTagCompound nbt;

        public BlockInfo(Block block, int metadata, NBTTagCompound nbt) {
            this.block = block;
            this.metadata = metadata;
            this.nbt = nbt;
        }

        public int hashCode() {
            int code = Block.func_149682_b((Block)this.block) << 16 | this.metadata & Short.MAX_VALUE;
            if (this.nbt != null) {
                code ^= this.nbt.hashCode();
            }
            return code;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BlockInfo)) {
                return false;
            }
            BlockInfo ok = (BlockInfo)o;
            if (this.block != ok.block) {
                return false;
            }
            if (this.metadata != ok.metadata) {
                return false;
            }
            return this.nbt == null && ok.nbt == null || this.nbt != null && this.nbt.equals((Object)ok.nbt);
        }

        public int getMetadata() {
            return this.metadata;
        }

        public Block getBlock() {
            return this.block;
        }

        public NBTTagCompound getNBT() {
            return this.nbt;
        }
    }
}

