/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import CustomOreGen.Config.ConfigParser;
import CustomOreGen.CustomPacketPayload;
import CustomOreGen.Server.ServerState;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ConsoleCommand
extends CommandBase {
    private final Object _obj;
    private final Method _method;

    public static void sendText(ICommandSender recipient, String text) {
        if (text != null && recipient != null) {
            for (String line : text.split("\n")) {
                if (recipient instanceof EntityPlayerMP) {
                    new CustomPacketPayload(CustomPacketPayload.PayloadType.CommandResponse, (Serializable)((Object)line)).sendToClient((EntityPlayerMP)recipient);
                    continue;
                }
                recipient.func_145747_a((IChatComponent)new ChatComponentText(line));
            }
        }
    }

    public static WorldServer getSenderWorld(ICommandSender sender) {
        World entityWorld = null;
        if (sender instanceof Entity) {
            entityWorld = ((Entity)sender).field_70170_p;
        } else {
            if (!(sender instanceof TileEntity)) {
                return null;
            }
            entityWorld = ((TileEntity)sender).func_145831_w();
        }
        if (entityWorld == null) {
            return null;
        }
        int dim = entityWorld.field_73011_w.field_76574_g;
        return MinecraftServer.func_71276_C().func_71218_a(dim);
    }

    public ConsoleCommand(Object obj, Method method) {
        if ((method.getModifiers() & 8) == 0 && obj == null) {
            throw new RuntimeException("Method '" + method.getName() + "' for class " + method.getDeclaringClass().getSimpleName() + " requires an object instance");
        }
        this._obj = obj;
        this._method = method;
    }

    public ConsoleCommand(Method method) {
        this(null, method);
    }

    public String func_71517_b() {
        CommandDelegate cmdDef = this._method.getAnnotation(CommandDelegate.class);
        return cmdDef != null && cmdDef.names() != null && cmdDef.names().length > 0 ? cmdDef.names()[0] : this._method.getName();
    }

    public List<String> func_71514_a() {
        CommandDelegate cmdDef = this._method.getAnnotation(CommandDelegate.class);
        return cmdDef != null && cmdDef.names() != null && cmdDef.names().length > 1 ? Arrays.asList(Arrays.copyOfRange(cmdDef.names(), 1, cmdDef.names().length)) : null;
    }

    public String func_71518_a(ICommandSender sender) {
        return this.getCommandHelp(sender, false);
    }

    public String getCommandHelp(ICommandSender sender, boolean verbose) {
        StringBuilder out = new StringBuilder("/" + this.func_71517_b());
        Class<?>[] ptypes = this._method.getParameterTypes();
        Annotation[][] pantns = this._method.getParameterAnnotations();
        for (int cmdDef = 0; cmdDef < ptypes.length; ++cmdDef) {
            Class<Object> clazz = ptypes[cmdDef];
            String name = "arg" + cmdDef + ":" + clazz.getSimpleName();
            boolean required = true;
            if (pantns != null && cmdDef < pantns.length && pantns[cmdDef] != null) {
                Annotation[] senderWorld;
                for (Annotation annot : senderWorld = pantns[cmdDef]) {
                    if (annot instanceof ArgName) {
                        name = ((ArgName)annot).name();
                        continue;
                    }
                    if (!(annot instanceof ArgOptional)) continue;
                    required = false;
                }
            }
            if (clazz.isAssignableFrom(ICommandSender.class)) continue;
            if (clazz.isAssignableFrom(WorldServer.class)) {
                WorldServer var15 = ConsoleCommand.getSenderWorld(sender);
                if (var15 != null) continue;
                clazz = Integer.class;
            } else if (clazz.isArray() && cmdDef == ptypes.length - 1 && this._method.isVarArgs()) {
                name = " ... ";
                required = false;
            }
            out.append(' ');
            if (required) {
                out.append('<');
            } else {
                out.append('[');
            }
            out.append(name);
            if (required) {
                out.append('>');
                continue;
            }
            out.append(']');
        }
        CommandDelegate var14 = this._method.getAnnotation(CommandDelegate.class);
        if (verbose && var14 != null && var14.desc() != null && !var14.desc().isEmpty()) {
            out.append("\n  ");
            out.append(var14.desc());
        }
        return out.toString();
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        Class<?>[] ptypes = this._method.getParameterTypes();
        Annotation[][] pantns = this._method.getParameterAnnotations();
        Object[] pvalues = new Object[ptypes.length];
        try {
            int ex = 0;
            for (int pidx = 0; pidx < ptypes.length; ++pidx) {
                Class<Object> clazz = ptypes[pidx];
                String name = "arg" + pidx + ":" + clazz.getSimpleName();
                String defValue = null;
                boolean required = true;
                if (pantns != null && pidx < pantns.length && pantns[pidx] != null) {
                    for (Annotation annot : pantns[pidx]) {
                        if (annot instanceof ArgName) {
                            name = ((ArgName)annot).name();
                            continue;
                        }
                        if (!(annot instanceof ArgOptional)) continue;
                        required = false;
                        defValue = ((ArgOptional)annot).defValue();
                        if (!defValue.isEmpty()) continue;
                        defValue = null;
                    }
                }
                if (clazz.isAssignableFrom(ICommandSender.class)) {
                    pvalues[pidx] = sender;
                    continue;
                }
                if (clazz.isAssignableFrom(WorldServer.class)) {
                    pvalues[pidx] = ConsoleCommand.getSenderWorld(sender);
                    if (pvalues[pidx] != null) continue;
                    Integer var20 = (Integer)ConfigParser.parseString(Integer.class, ex < args.length ? args[ex++] : defValue);
                    Object object = pvalues[pidx] = var20 == null ? null : MinecraftServer.func_71276_C().func_71218_a(var20.intValue());
                    if (pvalues[pidx] != null || !required) continue;
                    throw new SyntaxErrorException("Missing or invalid dimension ID for required argument '" + name + "'", new Object[0]);
                }
                if (clazz.isArray() && pidx == ptypes.length - 1 && this._method.isVarArgs()) {
                    pvalues[pidx] = Array.newInstance(clazz.getComponentType(), args.length - ex);
                    for (int var21 = 0; var21 < Array.getLength(pvalues[pidx]); ++var21) {
                        Object var22 = ConfigParser.parseString(clazz.getComponentType(), args[ex++]);
                        Array.set(pvalues[pidx], var21, var22);
                    }
                    continue;
                }
                pvalues[pidx] = ConfigParser.parseString(clazz, ex < args.length ? args[ex++] : defValue);
                if (pvalues[pidx] != null || !required) continue;
                throw new SyntaxErrorException("Missing required argument '" + name + "'", new Object[0]);
            }
            if (ex < args.length) {
                throw new SyntaxErrorException("Too many arguments", new Object[0]);
            }
        }
        catch (IllegalArgumentException var18) {
            throw new SyntaxErrorException(var18.getMessage(), new Object[0]);
        }
        try {
            Object var19 = this._method.invoke(this._obj, pvalues);
            if (var19 != null) {
                ConsoleCommand.sendText(sender, var19.toString());
            }
        }
        catch (InvocationTargetException var16) {
            throw new CommandException("Error: " + var16.getCause().getMessage(), new Object[0]);
        }
        catch (Exception var17) {
            throw new CommandException("Unkown Error: " + var17.getMessage(), new Object[0]);
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        WorldServer senderWorld;
        CommandDelegate cmdDef = this._method.getAnnotation(CommandDelegate.class);
        if ((cmdDef == null || cmdDef.isDebugging()) && (senderWorld = ConsoleCommand.getSenderWorld(sender)) != null) {
            ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), senderWorld.func_72912_H());
            if (!ServerState.getWorldConfig((World)senderWorld).debuggingMode) {
                return false;
            }
        }
        return super.func_71519_b(sender);
    }

    public int func_82362_a() {
        CommandDelegate cmdDef = this._method.getAnnotation(CommandDelegate.class);
        return cmdDef != null && cmdDef.isCheat() ? 2 : 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface CommandDelegate {
        public String[] names() default {};

        public boolean isCheat() default true;

        public boolean isDebugging() default true;

        public String desc() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface ArgOptional {
        public String defValue() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface ArgName {
        public String name() default "";
    }
}

