/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityHelper {
    private static Class<? extends Block> prefixBlockClass;
    private static Class<? extends TileEntity> prefixBlockTileEntityClass;

    public static void readFromPartialNBT(TileEntity te, NBTTagCompound source) {
        NBTTagCompound dest = new NBTTagCompound();
        te.func_145841_b(dest);
        TileEntityHelper.mergeNbt(source, dest);
        te.func_145839_a(dest);
    }

    public static void readFromPartialNBT(World world, int x, int y, int z, NBTTagCompound source) {
        if (source != null) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te == null && (te = TileEntityHelper.tryToCreateGTPrefixBlockTileEntity(world.func_147439_a(x, y, z))) != null) {
                world.func_147455_a(x, y, z, te);
            }
            if (te != null) {
                TileEntityHelper.readFromPartialNBT(te, source);
            }
        }
    }

    public static NBTTagCompound tryToCreateGTPrefixBlockNBT(ItemStack ore) {
        Block block = ((ItemBlock)ore.func_77973_b()).field_150939_a;
        NBTTagCompound nbt = null;
        if (TileEntityHelper.isGTPrefixBlock(block)) {
            nbt = new NBTTagCompound();
            nbt.func_74777_a("m", (short)ore.func_77960_j());
            nbt.func_74778_a("id", "gt.MetaBlockTileEntity");
        }
        return nbt;
    }

    private static boolean isGTPrefixBlock(Block block) {
        return prefixBlockClass != null && prefixBlockClass.isAssignableFrom(block.getClass());
    }

    private static TileEntity tryToCreateGTPrefixBlockTileEntity(Block block) {
        try {
            if (TileEntityHelper.isGTPrefixBlock(block)) {
                return prefixBlockTileEntityClass.newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private static void mergeNbt(NBTTagCompound source, NBTTagCompound dest) {
        for (String key : source.func_150296_c()) {
            dest.func_74782_a(key, source.func_74781_a(key));
        }
    }

    static {
        try {
            prefixBlockClass = Class.forName("gregapi.block.prefixblock.PrefixBlock");
            prefixBlockTileEntityClass = Class.forName("gregapi.block.prefixblock.PrefixBlockTileEntity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

