/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.fog;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.blockartistry.mod.DynSurround.client.fog.IFogColorCalculator;
import org.blockartistry.mod.DynSurround.util.Color;

@SideOnly(value=Side.CLIENT)
public class HolisticFogColorCalculator
implements IFogColorCalculator {
    protected List<IFogColorCalculator> calculators = new ArrayList<IFogColorCalculator>();
    protected Color cached;

    public void add(@Nonnull IFogColorCalculator calc) {
        this.calculators.add(calc);
    }

    @Override
    public Color calculate(@Nonnull EntityViewRenderEvent.FogColors event) {
        Color result = null;
        for (IFogColorCalculator calc : this.calculators) {
            Color color = calc.calculate(event);
            if (result == null) {
                result = color;
                continue;
            }
            if (color == null) continue;
            result = result.mix(color);
        }
        this.cached = result;
        return this.cached;
    }

    @Override
    public void tick() {
        for (IFogColorCalculator calc : this.calculators) {
            calc.tick();
        }
    }

    public String toString() {
        return this.cached != null ? this.cached.toString() : "<NOT SET>";
    }
}

