/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.implem.AcousticsLibrary;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.IOptions;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.ISoundPlayer;
import org.blockartistry.mod.DynSurround.client.footsteps.game.system.Association;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem.PendingSound;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.IDefaultStepPlayer;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.IIsolator;
import org.blockartistry.mod.DynSurround.util.MyUtils;
import org.blockartistry.mod.DynSurround.util.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class AcousticsManager
extends AcousticsLibrary
implements ISoundPlayer,
IDefaultStepPlayer {
    private static final Random RANDOM = new XorShiftRandom();
    private static final boolean USING_LATENESS = true;
    private static final boolean USING_EARLYNESS = true;
    private static final float LATENESS_THRESHOLD_DIVIDER = 1.2f;
    private static final double EARLYNESS_THRESHOLD_POW = 0.75;
    private final List<PendingSound> pending = new ArrayList<PendingSound>();
    private final IIsolator isolator;
    private long minimum;

    public AcousticsManager(IIsolator isolator) {
        this.isolator = isolator;
    }

    @Override
    public void playStep(EntityLivingBase entity, Association assos) {
        try {
            Block block = assos.getBlock();
            if (!block.func_149688_o().func_76224_d() && block.field_149762_H != null && block.field_149762_H.field_150501_a != null) {
                Block.SoundType soundType = block.field_149762_H;
                if (EnvironStateHandler.EnvironState.getWorld().func_147439_a(assos.x, assos.y + 1, assos.z) == Blocks.field_150431_aC) {
                    soundType = Blocks.field_150431_aC.field_149762_H;
                }
                entity.func_85030_a(soundType.func_150498_e(), soundType.func_150497_c() * 0.15f, soundType.func_150494_d());
            }
        }
        catch (Throwable t) {
            ModLog.error("Unable to play step", t);
        }
    }

    @Override
    public void playSound(Object location, String soundName, float volume, float pitch, IOptions options) {
        if (!(location instanceof Entity)) {
            return;
        }
        if (options != null) {
            if (options.hasOption(IOptions.Option.DELAY_MIN) && options.hasOption(IOptions.Option.DELAY_MAX)) {
                long delay = this.randAB(RANDOM, (Long)options.getOption(IOptions.Option.DELAY_MIN), (Long)options.getOption(IOptions.Option.DELAY_MAX));
                if (delay < this.minimum) {
                    this.minimum = delay;
                }
                this.pending.add(new PendingSound(location, soundName, volume, pitch, null, MyUtils.currentTimeMillis() + delay, options.hasOption(IOptions.Option.SKIPPABLE) ? -1L : (Long)options.getOption(IOptions.Option.DELAY_MAX)));
            } else {
                this.actuallyPlaySound((Entity)location, soundName, volume, pitch);
            }
        } else {
            this.actuallyPlaySound((Entity)location, soundName, volume, pitch);
        }
    }

    protected void actuallyPlaySound(Entity location, String soundName, float volume, float pitch) {
        if (ModLog.DEBUGGING) {
            ModLog.debug("    Playing sound " + soundName + " (" + String.format(Locale.ENGLISH, "v%.2f, p%.2f", Float.valueOf(volume), Float.valueOf(pitch)) + ")", new Object[0]);
        }
        try {
            location.func_85030_a(soundName, volume, pitch);
        }
        catch (Throwable t) {
            ModLog.error("Unable to play sound", t);
        }
    }

    private long randAB(Random rng, long a, long b) {
        return a >= b ? a : a + (long)rng.nextInt((int)b + 1);
    }

    @Override
    public Random getRNG() {
        return RANDOM;
    }

    @Override
    public void think() {
        if (this.pending.isEmpty() || MyUtils.currentTimeMillis() < this.minimum) {
            return;
        }
        long newMinimum = Long.MAX_VALUE;
        long time = MyUtils.currentTimeMillis();
        Iterator<PendingSound> iter = this.pending.iterator();
        while (iter.hasNext()) {
            PendingSound sound = iter.next();
            if (time >= sound.getTimeToPlay() || (double)time >= (double)sound.getTimeToPlay() - Math.pow(sound.getMaximumBase(), 0.75)) {
                if (ModLog.DEBUGGING && time < sound.getTimeToPlay()) {
                    ModLog.debug("    Playing early sound (early by " + (sound.getTimeToPlay() - time) + "ms, tolerence is " + Math.pow(sound.getMaximumBase(), 0.75), new Object[0]);
                }
                long lateness = time - sound.getTimeToPlay();
                if (sound.getMaximumBase() < 0L || (float)lateness <= (float)sound.getMaximumBase() / 1.2f) {
                    sound.playSound(this);
                } else if (ModLog.DEBUGGING) {
                    ModLog.debug("    Skipped late sound (late by " + lateness + "ms, tolerence is " + (float)sound.getMaximumBase() / 1.2f + "ms)", new Object[0]);
                }
                iter.remove();
                continue;
            }
            newMinimum = sound.getTimeToPlay();
        }
        this.minimum = newMinimum;
    }

    @Override
    protected ISoundPlayer mySoundPlayer() {
        return this.isolator.getSoundPlayer();
    }
}

