/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.footsteps.util.property.simple;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.blockartistry.mod.DynSurround.client.footsteps.util.property.simple.PropertyMissingException;
import org.blockartistry.mod.DynSurround.client.footsteps.util.property.simple.PropertyTypeException;
import org.blockartistry.mod.DynSurround.util.JsonUtils;

@SideOnly(value=Side.CLIENT)
public class ConfigProperty {
    private Map<String, String> properties = new HashMap<String, String>();

    public String getString(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        return this.properties.get(name);
    }

    public boolean getBoolean(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Boolean.parseBoolean(this.properties.get(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException();
        }
    }

    public int getInteger(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Integer.parseInt(this.properties.get(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException();
        }
    }

    public float getFloat(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Float.parseFloat(this.properties.get(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException();
        }
    }

    public long getLong(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Long.parseLong(this.properties.get(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException();
        }
    }

    public double getDouble(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Double.parseDouble(this.properties.get(name));
        }
        catch (NumberFormatException e) {
            throw new PropertyTypeException();
        }
    }

    public void setProperty(String name, Object o) {
        this.properties.put(name, o.toString());
    }

    public Map<String, String> getAllProperties() {
        return this.properties;
    }

    public static ConfigProperty fromStream(InputStream stream) {
        ConfigProperty props = new ConfigProperty();
        ConfigProperty.loadStream(props, stream);
        return props;
    }

    public static boolean loadStream(ConfigProperty properties, InputStream stream) {
        if (stream == null) {
            return false;
        }
        properties.properties = (Map)JsonUtils.load(stream, properties.properties.getClass());
        return true;
    }
}

