/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.data;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.data.AuroraData;
import org.blockartistry.mod.DynSurround.data.DimensionEffectDataFile;
import org.blockartistry.mod.DynSurround.util.INBTSerialization;
import org.blockartistry.mod.DynSurround.util.random.XorShiftRandom;

public final class DimensionEffectData
implements INBTSerialization {
    private static final XorShiftRandom random = new XorShiftRandom();
    private static final DecimalFormat FORMATTER = new DecimalFormat("0");
    public static final float MIN_INTENSITY = 0.0f;
    public static final float MAX_INTENSITY = 1.0f;
    private int dimensionId = 0;
    private float intensity = 0.0f;
    private float minIntensity = ModOptions.defaultMinRainStrength;
    private float maxIntensity = ModOptions.defaultMaxRainStrength;
    private final Set<AuroraData> auroras = new HashSet<AuroraData>();

    public DimensionEffectData() {
    }

    public DimensionEffectData(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public float getRainIntensity() {
        return this.intensity;
    }

    public void setRainIntensity(float intensity) {
        this.intensity = MathHelper.func_76131_a((float)intensity, (float)0.0f, (float)1.0f);
    }

    public float getMinRainIntensity() {
        return this.minIntensity;
    }

    public void setMinRainIntensity(float intensity) {
        this.minIntensity = MathHelper.func_76131_a((float)intensity, (float)0.0f, (float)this.maxIntensity);
    }

    public float getMaxRainIntensity() {
        return this.maxIntensity;
    }

    public void setMaxRainIntensity(float intensity) {
        this.maxIntensity = MathHelper.func_76131_a((float)intensity, (float)this.minIntensity, (float)1.0f);
    }

    public Set<AuroraData> getAuroraList() {
        return this.auroras;
    }

    public void randomizeRain() {
        float result = 0.0f;
        float delta = this.maxIntensity - this.minIntensity;
        if (delta <= 0.0f) {
            result = this.minIntensity;
        } else {
            float mid = delta / 2.0f;
            result = random.nextFloat() * mid + random.nextFloat() * mid;
        }
        this.setRainIntensity(MathHelper.func_76131_a((float)result, (float)0.01f, (float)1.0f));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.dimensionId = nbt.func_74762_e("d");
        this.intensity = MathHelper.func_76131_a((float)nbt.func_74760_g("s"), (float)0.0f, (float)1.0f);
        if (nbt.func_74764_b("min")) {
            this.minIntensity = MathHelper.func_76131_a((float)nbt.func_74760_g("min"), (float)0.0f, (float)1.0f);
        }
        if (nbt.func_74764_b("max")) {
            this.maxIntensity = MathHelper.func_76131_a((float)nbt.func_74760_g("max"), (float)this.minIntensity, (float)1.0f);
        }
        NBTTagList list = nbt.func_150295_c("al", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            AuroraData data = new AuroraData();
            data.readFromNBT(tag);
            this.auroras.add(data);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("d", this.dimensionId);
        nbt.func_74776_a("s", this.intensity);
        nbt.func_74776_a("min", this.minIntensity);
        nbt.func_74776_a("max", this.maxIntensity);
        NBTTagList list = new NBTTagList();
        for (AuroraData data : this.auroras) {
            NBTTagCompound tag = new NBTTagCompound();
            data.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("al", (NBTBase)list);
    }

    public static DimensionEffectData get(World world) {
        return DimensionEffectDataFile.get(world);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("dim ").append(this.dimensionId).append(": ");
        builder.append("intensity: ").append(FORMATTER.format(this.intensity * 100.0f));
        builder.append(" [").append(FORMATTER.format(this.minIntensity * 100.0f));
        builder.append(",").append(FORMATTER.format(this.maxIntensity * 100.0f));
        builder.append("]");
        builder.append(", auroras: ").append(this.auroras.size());
        return builder.toString();
    }

    private final class NBT {
        public static final String DIMENSION = "d";
        public static final String INTENSITY = "s";
        public static final String MIN_INTENSITY = "min";
        public static final String MAX_INTENSITY = "max";
        public static final String AURORA_LIST = "al";

        private NBT() {
        }
    }
}

