/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.enderio.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public final class FastOreDictionary {
    private static final Object lock = new Object();
    private static final Map<ItemStackKey, int[]> ORE_IDS_CACHE = new HashMap<ItemStackKey, int[]>(256);
    private static boolean dirty;
    private static int counter;

    private FastOreDictionary() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && counter++ >= 6000) {
            counter = 0;
            long time = System.currentTimeMillis();
            Object object = lock;
            synchronized (object) {
                ORE_IDS_CACHE.keySet().removeIf(x -> x.expireTime < time);
            }
        }
    }

    @SubscribeEvent
    public void onUpdateOres(OreDictionary.OreRegisterEvent event) {
        dirty = true;
    }

    @Nonnull
    public static int[] getOreIDsCopy(ItemStack stack) {
        int[] oreIDs = FastOreDictionary.getOreIDs(stack);
        return oreIDs.length == 0 ? oreIDs : (int[])oreIDs.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static int[] getOreIDs(ItemStack stack) {
        if (stack == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        Item item = stack.func_77973_b();
        if (item == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        ItemStackKey key = new ItemStackKey(item, item.getDamage(stack));
        Object object = lock;
        synchronized (object) {
            int[] oreIDs;
            if (!dirty) {
                oreIDs = ORE_IDS_CACHE.get(key);
                if (oreIDs != null) {
                    return oreIDs;
                }
            } else {
                dirty = false;
                ORE_IDS_CACHE.clear();
            }
            if ((oreIDs = OreDictionary.getOreIDs((ItemStack)stack)).length == 0) {
                oreIDs = ArrayUtils.EMPTY_INT_ARRAY;
            }
            key.expireTime = System.currentTimeMillis() + 300000L;
            ORE_IDS_CACHE.put(key, oreIDs);
            return oreIDs;
        }
    }

    static {
        FastOreDictionary instance = new FastOreDictionary();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        FMLCommonHandler.instance().bus().register((Object)instance);
    }

    private static final class ItemStackKey {
        long expireTime;
        public final Item item;
        public final int damage;

        public ItemStackKey(Item item, int damage) {
            this.item = item;
            this.damage = damage;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            ItemStackKey that = (ItemStackKey)o;
            return this.damage == that.damage && this.item == that.item;
        }

        public int hashCode() {
            return 31 * this.item.hashCode() + this.damage;
        }
    }
}

