/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item;

import cpw.mods.fml.common.network.ByteBufUtils;
import crazypants.enderio.Log;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.item.filter.IItemFilterUpgrade;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FilterRegister {
    private static final Map<String, FilterProvider> filterProviders = new HashMap<String, FilterProvider>();

    public static boolean isItemFilter(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IItemFilterUpgrade;
    }

    public static IItemFilter getFilterForUpgrade(ItemStack stack) {
        if (!FilterRegister.isItemFilter(stack)) {
            return null;
        }
        IItemFilterUpgrade upgrade = (IItemFilterUpgrade)stack.func_77973_b();
        return upgrade.createFilterFromStack(stack);
    }

    public static boolean isFilterSet(ItemStack stack) {
        return stack != null && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("filter");
    }

    public static void writeFilterToStack(IItemFilter filter, ItemStack stack) {
        if (stack == null || filter == null) {
            return;
        }
        NBTTagCompound filterRoot = new NBTTagCompound();
        FilterRegister.writeFilterToNbt(filter, filterRoot);
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74782_a("filter", (NBTBase)filterRoot);
    }

    public static void writeFilterToNbt(IItemFilter filter, NBTTagCompound filterTag) {
        filterTag.func_74778_a("filterClass", filter.getClass().getName());
        filter.writeToNBT(filterTag);
    }

    private static IItemFilter create(String clazzName) {
        return filterProviders.computeIfAbsent(clazzName, clazz -> {
            try {
                Class<?> cl = Class.forName(clazz);
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                CallSite callSite = LambdaMetafactory.metafactory(lookup, "provideFilter", MethodType.methodType(FilterProvider.class), MethodType.methodType(IItemFilter.class), lookup.findConstructor(cl, MethodType.methodType(Void.TYPE)), MethodType.methodType(cl));
                return callSite.getTarget().invoke();
            }
            catch (Throwable t) {
                throw new RuntimeException("Cant generate dynamic lambda constructor for class " + clazz);
            }
        }).provideFilter();
    }

    public static IItemFilter loadFilterFromNbt(NBTTagCompound filterTag) {
        IItemFilter filter;
        if (filterTag == null) {
            return null;
        }
        if (!filterTag.func_74764_b("filterClass")) {
            filter = null;
            Log.warn("Could not load old version of item filter.");
        } else {
            String className = filterTag.func_74779_i("filterClass");
            filter = FilterRegister.loadFilterFromNbt(className, filterTag);
        }
        return filter;
    }

    private static IItemFilter loadFilterFromNbt(String className, NBTTagCompound tag) {
        try {
            IItemFilter filter = FilterRegister.create(className);
            filter.readFromNBT(tag);
            return filter;
        }
        catch (Exception e) {
            Log.error("Could not read item filter with class name: " + className + " from NBT: " + tag + " Error: " + e);
            return null;
        }
    }

    private static IItemFilter loadFilterFromByteBuf(String className, ByteBuf buf) {
        try {
            IItemFilter filter = FilterRegister.create(className);
            filter.readFromByteBuf(buf);
            return filter;
        }
        catch (Exception e) {
            Log.error("[EnderIO] Could not read item filter with class name: " + className + " from ByteBuf Error: " + e);
            return null;
        }
    }

    public static void writeFilter(ByteBuf buf, IItemFilter filter) {
        if (filter == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"nullFilter");
            return;
        }
        String name = filter.getClass().getName();
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)name);
        filter.writeToByteBuf(buf);
    }

    public static IItemFilter readFilter(ByteBuf buf) {
        String className = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (className.equals("nullFilter")) {
            return null;
        }
        return FilterRegister.loadFilterFromByteBuf(className, buf);
    }

    private static interface FilterProvider {
        public IItemFilter provideFilter();
    }
}

