/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item;

import cofh.api.inventory.IInventoryConnection;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.FunctionUpgrade;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduit.item.SpeedUpgrade;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.item.PacketConduitProbe;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemConduit
extends AbstractConduit
implements IItemConduit {
    public static final String EXTERNAL_INTERFACE_GEOM = "ExternalInterface";
    public static final String ICON_KEY = "enderio:itemConduit";
    public static final String ICON_KEY_CORE = "enderio:itemConduitCore";
    public static final String ICON_KEY_CORE_ADV = "enderio:itemConduitCoreAdvanced";
    public static final String ICON_KEY_INPUT = "enderio:itemConduitInput";
    public static final String ICON_KEY_OUTPUT = "enderio:itemConduitOutput";
    public static final String ICON_KEY_IN_OUT_OUT = "enderio:itemConduitInOut_Out";
    public static final String ICON_KEY_IN_OUT_IN = "enderio:itemConduitInOut_In";
    public static final String ICON_KEY_IN_OUT_BG = "enderio:itemConduitIoConnector";
    public static final String ICON_KEY_ENDER = "enderio:ender_still";
    static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    ItemConduitNetwork network;
    protected final RedstoneControlMode[] extractionModes = new RedstoneControlMode[7];
    protected final DyeColor[] extractionColors = new DyeColor[7];
    protected final IItemFilter[] outputFilters = new IItemFilter[7];
    protected final IItemFilter[] inputFilters = new IItemFilter[7];
    protected final ItemStack[] outputFilterUpgrades = new ItemStack[7];
    protected final ItemStack[] inputFilterUpgrades = new ItemStack[7];
    protected final ItemStack[] speedUpgrades = new ItemStack[7];
    protected final ItemStack[] functionUpgrades = new ItemStack[7];
    protected final Boolean[] selfFeed = new Boolean[7];
    protected final Boolean[] roundRobin = new Boolean[7];
    protected final Integer[] priority = new Integer[7];
    protected final DyeColor[] outputColors = new DyeColor[7];
    protected final DyeColor[] inputColors = new DyeColor[7];
    private int metaData;

    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(IIconRegister register) {
                ICONS.put(ItemConduit.ICON_KEY, register.func_94245_a(ItemConduit.ICON_KEY));
                ICONS.put(ItemConduit.ICON_KEY_CORE, register.func_94245_a(ItemConduit.ICON_KEY_CORE));
                ICONS.put(ItemConduit.ICON_KEY_CORE_ADV, register.func_94245_a(ItemConduit.ICON_KEY_CORE_ADV));
                ICONS.put(ItemConduit.ICON_KEY_INPUT, register.func_94245_a(ItemConduit.ICON_KEY_INPUT));
                ICONS.put(ItemConduit.ICON_KEY_OUTPUT, register.func_94245_a(ItemConduit.ICON_KEY_OUTPUT));
                ICONS.put(ItemConduit.ICON_KEY_IN_OUT_OUT, register.func_94245_a(ItemConduit.ICON_KEY_IN_OUT_OUT));
                ICONS.put(ItemConduit.ICON_KEY_IN_OUT_IN, register.func_94245_a(ItemConduit.ICON_KEY_IN_OUT_IN));
                ICONS.put(ItemConduit.ICON_KEY_IN_OUT_BG, register.func_94245_a(ItemConduit.ICON_KEY_IN_OUT_BG));
                ICONS.put(ItemConduit.ICON_KEY_ENDER, register.func_94245_a(ItemConduit.ICON_KEY_ENDER));
            }

            public int getTextureType() {
                return 0;
            }
        });
    }

    public ItemConduit() {
        this(0);
    }

    public ItemConduit(int itemDamage) {
        this.metaData = itemDamage;
        this.updateFromNonUpgradeableVersion();
    }

    private void updateFromNonUpgradeableVersion() {
        int filterMeta = this.metaData;
        if (this.metaData == 1) {
            for (int i = 0; i < this.inputFilters.length; ++i) {
                IItemFilter f = this.inputFilters[i];
                if (f == null) continue;
                this.setSpeedUpgrade(ForgeDirection.getOrientation((int)i), new ItemStack((Item)EnderIO.itemExtractSpeedUpgrade, 15, 0));
            }
            this.metaData = 0;
        }
        HashMap<ForgeDirection, ItemStack> converted = new HashMap<ForgeDirection, ItemStack>();
        this.convertToItemUpgrades(filterMeta, converted, this.inputFilters);
        for (Map.Entry entry : converted.entrySet()) {
            this.setInputFilter((ForgeDirection)entry.getKey(), null);
            this.setInputFilterUpgrade((ForgeDirection)entry.getKey(), (ItemStack)entry.getValue());
        }
        converted.clear();
        this.convertToItemUpgrades(filterMeta, converted, this.outputFilters);
        for (Map.Entry entry : converted.entrySet()) {
            this.setOutputFilter((ForgeDirection)entry.getKey(), null);
            this.setOutputFilterUpgrade((ForgeDirection)entry.getKey(), (ItemStack)entry.getValue());
        }
    }

    @Override
    protected void readTypeSettings(ForgeDirection dir, NBTTagCompound dataRoot) {
        this.setExtractionSignalColor(dir, DyeColor.COLORS[dataRoot.func_74765_d("extractionSignalColor")]);
        this.setExtractionRedstoneMode(RedstoneControlMode.MODES[dataRoot.func_74765_d("extractionRedstoneMode")], dir);
        this.setInputColor(dir, DyeColor.COLORS[dataRoot.func_74765_d("inputColor")]);
        this.setOutputColor(dir, DyeColor.COLORS[dataRoot.func_74765_d("outputColor")]);
        this.setSelfFeedEnabled(dir, dataRoot.func_74767_n("selfFeed"));
        this.setRoundRobinEnabled(dir, dataRoot.func_74767_n("roundRobin"));
        this.setOutputPriority(dir, dataRoot.func_74762_e("outputPriority"));
    }

    @Override
    protected void writeTypeSettingsToNbt(ForgeDirection dir, NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.func_74777_a("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
        dataRoot.func_74777_a("inputColor", (short)this.getInputColor(dir).ordinal());
        dataRoot.func_74777_a("outputColor", (short)this.getOutputColor(dir).ordinal());
        dataRoot.func_74757_a("selfFeed", this.isSelfFeedEnabled(dir));
        dataRoot.func_74757_a("roundRobin", this.isRoundRobinEnabled(dir));
        dataRoot.func_74768_a("outputPriority", this.getOutputPriority(dir));
    }

    protected void convertToItemUpgrades(int filterMeta, Map<ForgeDirection, ItemStack> converted, IItemFilter[] sourceFilters) {
        for (int i = 0; i < sourceFilters.length; ++i) {
            IItemFilter f = sourceFilters[i];
            if (f == null) continue;
            ItemStack up = new ItemStack((Item)EnderIO.itemBasicFilterUpgrade, 1, filterMeta);
            FilterRegister.writeFilterToStack(f, up);
            converted.put(ForgeDirection.getOrientation((int)i), up);
        }
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        res.add(this.createItem());
        res.addAll(Arrays.asList(this.speedUpgrades));
        res.addAll(Arrays.asList(this.functionUpgrades));
        res.addAll(Arrays.asList(this.inputFilterUpgrades));
        res.addAll(Arrays.asList(this.outputFilterUpgrades));
        return res;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        ForgeDirection connDir;
        if (ConduitUtil.isProbeEquipped(player)) {
            if (!player.field_70170_p.field_72995_K) {
                PacketConduitProbe.sendInfoMessage(player, this, null);
            }
            return true;
        }
        if (ToolUtil.isToolEquipped(player)) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
                ForgeDirection connDir2 = res.component.dir;
                ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.field_72310_e);
                if (connDir2 == ForgeDirection.UNKNOWN || connDir2 == faceHit) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    return ConduitUtil.joinConduits(this, faceHit);
                }
                if (this.externalConnections.contains(connDir2)) {
                    this.setConnectionMode(connDir2, this.getNextConnectionMode(connDir2));
                    return true;
                }
                if (this.containsConduitConnection(connDir2)) {
                    ConduitUtil.disconectConduits(this, connDir2);
                    return true;
                }
            }
        } else if (res != null && res.component != null && (connDir = res.component.dir) != null && connDir != ForgeDirection.UNKNOWN && this.containsExternalConnection(connDir)) {
            if (!player.field_70170_p.field_72995_K) {
                PacketConduitProbe.sendInfoMessage(player, this, player.func_71045_bC());
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack insertItem(ForgeDirection from, ItemStack item) {
        if (!this.externalConnections.contains(from)) {
            return item;
        }
        if (!this.getConnectionMode(from).acceptsInput()) {
            return item;
        }
        if (this.network == null) {
            return item;
        }
        IItemFilter filter = this.inputFilters[from.ordinal()];
        ItemConduitNetwork network = (ItemConduitNetwork)this.getNetwork();
        if (filter != null && !filter.doesItemPassFilter(network.getInventory(this, from.getOpposite()), item)) {
            return item;
        }
        return this.network.sendItems(this, item, from);
    }

    @Override
    public void setInputFilter(ForgeDirection dir, IItemFilter filter) {
        this.inputFilters[dir.ordinal()] = filter;
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
    }

    @Override
    public void setOutputFilter(ForgeDirection dir, IItemFilter filter) {
        this.outputFilters[dir.ordinal()] = filter;
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
    }

    @Override
    public IItemFilter getInputFilter(ForgeDirection dir) {
        return this.inputFilters[dir.ordinal()];
    }

    @Override
    public IItemFilter getOutputFilter(ForgeDirection dir) {
        return this.outputFilters[dir.ordinal()];
    }

    @Override
    public void setInputFilterUpgrade(ForgeDirection dir, ItemStack stack) {
        this.inputFilterUpgrades[dir.ordinal()] = stack;
        this.setInputFilter(dir, FilterRegister.getFilterForUpgrade(stack));
        this.setClientStateDirty();
    }

    @Override
    public void setOutputFilterUpgrade(ForgeDirection dir, ItemStack stack) {
        this.outputFilterUpgrades[dir.ordinal()] = stack;
        this.setOutputFilter(dir, FilterRegister.getFilterForUpgrade(stack));
        this.setClientStateDirty();
    }

    @Override
    public ItemStack getInputFilterUpgrade(ForgeDirection dir) {
        return this.inputFilterUpgrades[dir.ordinal()];
    }

    @Override
    public ItemStack getOutputFilterUpgrade(ForgeDirection dir) {
        return this.outputFilterUpgrades[dir.ordinal()];
    }

    @Override
    public void setSpeedUpgrade(ForgeDirection dir, ItemStack upgrade) {
        this.speedUpgrades[dir.ordinal()] = upgrade != null ? upgrade : null;
        this.setClientStateDirty();
    }

    @Override
    public ItemStack getSpeedUpgrade(ForgeDirection dir) {
        return this.speedUpgrades[dir.ordinal()];
    }

    @Override
    public void setFunctionUpgrade(ForgeDirection dir, ItemStack upgrade) {
        boolean hadIPU = this.hasInventoryPanelUpgrade(dir);
        this.functionUpgrades[dir.ordinal()] = upgrade != null ? upgrade : null;
        this.setClientStateDirty();
        if (this.network != null && hadIPU != this.hasInventoryPanelUpgrade(dir)) {
            this.network.inventoryPanelSourcesChanged();
        }
    }

    @Override
    public ItemStack getFunctionUpgrade(ForgeDirection dir) {
        return this.functionUpgrades[dir.ordinal()];
    }

    @Override
    public boolean hasInventoryPanelUpgrade(ForgeDirection dir) {
        ItemStack upgrade = this.functionUpgrades[dir.ordinal()];
        return upgrade != null && EnderIO.itemFunctionUpgrade.getFunctionUpgrade(upgrade) == FunctionUpgrade.INVENTORY_PANEL;
    }

    @Override
    public int getMetaData() {
        return this.metaData;
    }

    @Override
    public void setExtractionRedstoneMode(RedstoneControlMode mode, ForgeDirection dir) {
        this.extractionModes[dir.ordinal()] = mode;
    }

    @Override
    public RedstoneControlMode getExtractionRedstoneMode(ForgeDirection dir) {
        RedstoneControlMode res = this.extractionModes[dir.ordinal()];
        if (res == null) {
            res = RedstoneControlMode.ON;
        }
        return res;
    }

    @Override
    public void setExtractionSignalColor(ForgeDirection dir, DyeColor col) {
        this.extractionColors[dir.ordinal()] = col;
    }

    @Override
    public DyeColor getExtractionSignalColor(ForgeDirection dir) {
        DyeColor result = this.extractionColors[dir.ordinal()];
        if (result == null) {
            return DyeColor.RED;
        }
        return result;
    }

    @Override
    public boolean isExtractionRedstoneConditionMet(ForgeDirection dir) {
        RedstoneControlMode mode = this.getExtractionRedstoneMode(dir);
        if (mode == null) {
            return true;
        }
        return ConduitUtil.isRedstoneControlModeMet(this.getBundle(), mode, this.getExtractionSignalColor(dir));
    }

    @Override
    public DyeColor getInputColor(ForgeDirection dir) {
        DyeColor result = this.inputColors[dir.ordinal()];
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    @Override
    public DyeColor getOutputColor(ForgeDirection dir) {
        DyeColor result = this.outputColors[dir.ordinal()];
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    @Override
    public void setInputColor(ForgeDirection dir, DyeColor col) {
        this.inputColors[dir.ordinal()] = col;
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    public void setOutputColor(ForgeDirection dir, DyeColor col) {
        this.outputColors[dir.ordinal()] = col;
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    public int getMaximumExtracted(ForgeDirection dir) {
        ItemStack stack = this.speedUpgrades[dir.ordinal()];
        if (stack == null) {
            return 4;
        }
        SpeedUpgrade speedUpgrade = EnderIO.itemExtractSpeedUpgrade.getSpeedUpgrade(stack);
        return speedUpgrade.getMaximumExtracted(stack.field_77994_a);
    }

    @Override
    public float getTickTimePerItem(ForgeDirection dir) {
        float maxExtract = 10.0f / (float)this.getMaximumExtracted(dir);
        return maxExtract;
    }

    @Override
    public void itemsExtracted(int numExtracted, int slot) {
    }

    @Override
    public void externalConnectionAdded(ForgeDirection direction) {
        super.externalConnectionAdded(direction);
        if (this.network != null) {
            TileEntity te = this.bundle.getEntity();
            this.network.inventoryAdded(this, direction, te.field_145851_c + direction.offsetX, te.field_145848_d + direction.offsetY, te.field_145849_e + direction.offsetZ, this.getExternalInventory(direction));
        }
    }

    @Override
    public IInventory getExternalInventory(ForgeDirection direction) {
        World world = this.getBundle().getWorld();
        if (world == null) {
            return null;
        }
        BlockCoord loc = this.getLocation().getLocation(direction);
        TileEntity te = world.func_147438_o(loc.x, loc.y, loc.z);
        if (te instanceof IInventory && !(te instanceof IConduitBundle)) {
            return (IInventory)te;
        }
        return null;
    }

    @Override
    public void externalConnectionRemoved(ForgeDirection direction) {
        this.externalConnections.remove(direction);
        this.connectionsChanged();
        if (this.network != null) {
            TileEntity te = this.bundle.getEntity();
            this.network.inventoryRemoved(this, te.field_145851_c + direction.offsetX, te.field_145848_d + direction.offsetY, te.field_145849_e + direction.offsetZ);
        }
    }

    @Override
    public void setConnectionMode(ForgeDirection dir, ConnectionMode mode) {
        ConnectionMode oldVal = (ConnectionMode)((Object)this.conectionModes.get(dir));
        if (oldVal == mode) {
            return;
        }
        super.setConnectionMode(dir, mode);
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public boolean isSelfFeedEnabled(ForgeDirection dir) {
        Boolean val = this.selfFeed[dir.ordinal()];
        if (val == null) {
            return false;
        }
        return val;
    }

    @Override
    public void setSelfFeedEnabled(ForgeDirection dir, boolean enabled) {
        this.selfFeed[dir.ordinal()] = !enabled ? null : Boolean.valueOf(enabled);
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public boolean isRoundRobinEnabled(ForgeDirection dir) {
        Boolean val = this.roundRobin[dir.ordinal()];
        if (val == null) {
            return false;
        }
        return val;
    }

    @Override
    public void setRoundRobinEnabled(ForgeDirection dir, boolean enabled) {
        this.roundRobin[dir.ordinal()] = !enabled ? null : Boolean.valueOf(enabled);
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public int getOutputPriority(ForgeDirection dir) {
        Integer res = this.priority[dir.ordinal()];
        if (res == null) {
            return 0;
        }
        return res;
    }

    @Override
    public void setOutputPriority(ForgeDirection dir, int priority) {
        this.priority[dir.ordinal()] = priority == 0 ? null : Integer.valueOf(priority);
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public boolean canConnectToExternal(ForgeDirection direction, boolean ignoreDisabled) {
        IInventory inv = this.getExternalInventory(direction);
        if (inv == null) {
            return false;
        }
        if (inv instanceof IInventoryConnection) {
            return ((IInventoryConnection)inv).canConnectInventory((ForgeDirection)direction.getOpposite()).canConnect;
        }
        if (inv instanceof ISidedInventory) {
            int[] slots = ((ISidedInventory)inv).func_94128_d(direction.getOpposite().ordinal());
            return slots != null && slots.length > 0;
        }
        return true;
    }

    @Override
    protected ConnectionMode getDefaultConnectionMode() {
        return ConnectionMode.INPUT;
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IItemConduit.class;
    }

    @Override
    public ItemStack createItem() {
        ItemStack result = new ItemStack((Item)EnderIO.itemItemConduit, 1, this.metaData);
        return result;
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        this.network = (ItemConduitNetwork)network;
        return true;
    }

    @Override
    public IIcon getTextureForInputMode() {
        return ICONS.get(ICON_KEY_INPUT);
    }

    @Override
    public IIcon getTextureForOutputMode() {
        return ICONS.get(ICON_KEY_OUTPUT);
    }

    @Override
    public IIcon getTextureForInOutMode(boolean input) {
        return input ? ICONS.get(ICON_KEY_IN_OUT_IN) : ICONS.get(ICON_KEY_IN_OUT_OUT);
    }

    @Override
    public IIcon getTextureForInOutBackground() {
        return ICONS.get(ICON_KEY_IN_OUT_BG);
    }

    @Override
    public IIcon getEnderIcon() {
        return ICONS.get(ICON_KEY_ENDER);
    }

    public IIcon getCoreIcon() {
        return this.metaData == 1 ? ICONS.get(ICON_KEY_CORE_ADV) : ICONS.get(ICON_KEY_CORE);
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return this.getCoreIcon();
        }
        if (EXTERNAL_INTERFACE_GEOM.equals(component.data)) {
            return this.getCoreIcon();
        }
        return ICONS.get(ICON_KEY);
    }

    @Override
    public IIcon getTransmitionTextureForState(CollidableComponent component) {
        return this.getEnderIcon();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        IItemFilter filter;
        IItemFilter up;
        NBTTagCompound itemRoot2;
        IItemFilter f;
        Object color;
        int i;
        super.writeToNBT(nbtRoot);
        for (i = 0; i < this.inputFilters.length; ++i) {
            color = this.inputFilters[i];
            if (color == null || this.isDefault(f = color)) continue;
            itemRoot2 = new NBTTagCompound();
            FilterRegister.writeFilterToNbt(f, itemRoot2);
            nbtRoot.func_74782_a("inFilts." + ForgeDirection.getOrientation((int)i).name(), (NBTBase)itemRoot2);
        }
        for (i = 0; i < this.speedUpgrades.length; ++i) {
            color = this.speedUpgrades[i];
            if (color == null) continue;
            up = color;
            itemRoot2 = new NBTTagCompound();
            up.func_77955_b(itemRoot2);
            nbtRoot.func_74782_a("speedUpgrades." + ForgeDirection.getOrientation((int)i).name(), (NBTBase)itemRoot2);
        }
        for (i = 0; i < this.functionUpgrades.length; ++i) {
            color = this.functionUpgrades[i];
            if (color == null) continue;
            up = color;
            itemRoot2 = new NBTTagCompound();
            up.func_77955_b(itemRoot2);
            nbtRoot.func_74782_a("functionUpgrades." + ForgeDirection.getOrientation((int)i).name(), (NBTBase)itemRoot2);
        }
        for (i = 0; i < this.outputFilters.length; ++i) {
            color = this.outputFilters[i];
            if (color == null || this.isDefault(f = color)) continue;
            itemRoot2 = new NBTTagCompound();
            FilterRegister.writeFilterToNbt(f, itemRoot2);
            nbtRoot.func_74782_a("outFilts." + ForgeDirection.getOrientation((int)i).name(), (NBTBase)itemRoot2);
        }
        for (i = 0; i < this.inputFilterUpgrades.length; ++i) {
            color = this.inputFilterUpgrades[i];
            if (color == null) continue;
            up = color;
            filter = this.getInputFilter(ForgeDirection.getOrientation((int)i));
            FilterRegister.writeFilterToStack(filter, (ItemStack)up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("inputFilterUpgrades." + ForgeDirection.getOrientation((int)i).name(), (NBTBase)itemRoot);
        }
        for (i = 0; i < this.outputFilterUpgrades.length; ++i) {
            color = this.outputFilterUpgrades[i];
            if (color == null) continue;
            up = color;
            filter = this.getOutputFilter(ForgeDirection.getOrientation((int)i));
            FilterRegister.writeFilterToStack(filter, (ItemStack)up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("outputFilterUpgrades." + ForgeDirection.getOrientation((int)i).name(), (NBTBase)itemRoot);
        }
        for (i = 0; i < this.extractionModes.length; ++i) {
            color = this.extractionModes[i];
            if (color == null) continue;
            short ord = (short)((Enum)color).ordinal();
            nbtRoot.func_74777_a("extRM." + ForgeDirection.getOrientation((int)i).name(), ord);
        }
        for (i = 0; i < this.extractionColors.length; ++i) {
            color = this.extractionColors[i];
            if (color == null) continue;
            short ord = (short)color.ordinal();
            nbtRoot.func_74777_a("extSC." + ForgeDirection.getOrientation((int)i).name(), ord);
        }
        for (i = 0; i < this.selfFeed.length; ++i) {
            color = this.selfFeed[i];
            if (color == null) continue;
            nbtRoot.func_74757_a("selfFeed." + ForgeDirection.getOrientation((int)i).name(), ((Boolean)color).booleanValue());
        }
        for (i = 0; i < this.roundRobin.length; ++i) {
            color = this.roundRobin[i];
            if (color == null) continue;
            nbtRoot.func_74757_a("roundRobin." + ForgeDirection.getOrientation((int)i).name(), ((Boolean)color).booleanValue());
        }
        for (i = 0; i < this.priority.length; ++i) {
            color = this.priority[i];
            if (color == null) continue;
            nbtRoot.func_74768_a("priority." + ForgeDirection.getOrientation((int)i).name(), ((Integer)color).intValue());
        }
        for (i = 0; i < this.inputColors.length; ++i) {
            color = this.inputColors[i];
            if (color == null) continue;
            short ord = (short)color.ordinal();
            nbtRoot.func_74777_a("inSC." + ForgeDirection.getOrientation((int)i).name(), ord);
        }
        for (i = 0; i < this.outputColors.length; ++i) {
            color = this.outputColors[i];
            if (color == null) continue;
            short ord = (short)color.ordinal();
            nbtRoot.func_74777_a("outSC." + ForgeDirection.getOrientation((int)i).name(), ord);
        }
    }

    private boolean isDefault(IItemFilter f) {
        if (f instanceof ItemFilter) {
            return ((ItemFilter)f).isDefault();
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.metaData = nbtRoot.func_74764_b("metaData") ? (int)nbtRoot.func_74765_d("metaData") : 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            short ord;
            ItemStack ups;
            NBTTagCompound upTag;
            IItemFilter filter;
            NBTTagCompound filterTag;
            String key = "inFilts." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                this.inputFilters[dir.ordinal()] = filter = FilterRegister.loadFilterFromNbt(filterTag);
            }
            if (nbtRoot.func_74764_b(key = "speedUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                this.speedUpgrades[dir.ordinal()] = ups = ItemStack.func_77949_a((NBTTagCompound)upTag);
            }
            if (nbtRoot.func_74764_b(key = "functionUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                this.functionUpgrades[dir.ordinal()] = ups = ItemStack.func_77949_a((NBTTagCompound)upTag);
            }
            if (nbtRoot.func_74764_b(key = "inputFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                this.inputFilterUpgrades[dir.ordinal()] = ups = ItemStack.func_77949_a((NBTTagCompound)upTag);
            }
            if (nbtRoot.func_74764_b(key = "outputFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                this.outputFilterUpgrades[dir.ordinal()] = ups = ItemStack.func_77949_a((NBTTagCompound)upTag);
            }
            if (nbtRoot.func_74764_b(key = "outFilts." + dir.name())) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                this.outputFilters[dir.ordinal()] = filter = FilterRegister.loadFilterFromNbt(filterTag);
            }
            if (nbtRoot.func_74764_b(key = "extRM." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < RedstoneControlMode.MODES.length) {
                this.extractionModes[dir.ordinal()] = RedstoneControlMode.MODES[ord];
            }
            if (nbtRoot.func_74764_b(key = "extSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.COLORS.length) {
                this.extractionColors[dir.ordinal()] = DyeColor.COLORS[ord];
            }
            if (nbtRoot.func_74764_b(key = "selfFeed." + dir.name())) {
                boolean val = nbtRoot.func_74767_n(key);
                this.selfFeed[dir.ordinal()] = val;
            }
            if (nbtRoot.func_74764_b(key = "roundRobin." + dir.name())) {
                boolean val = nbtRoot.func_74767_n(key);
                this.roundRobin[dir.ordinal()] = val;
            }
            if (nbtRoot.func_74764_b(key = "priority." + dir.name())) {
                int val = nbtRoot.func_74762_e(key);
                this.priority[dir.ordinal()] = val;
            }
            if (nbtRoot.func_74764_b(key = "inSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.COLORS.length) {
                this.inputColors[dir.ordinal()] = DyeColor.COLORS[ord];
            }
            if (!nbtRoot.func_74764_b(key = "outSC." + dir.name()) || (ord = nbtRoot.func_74765_d(key)) < 0 || ord >= DyeColor.COLORS.length) continue;
            this.outputColors[dir.ordinal()] = DyeColor.COLORS[ord];
        }
        if (nbtRoot.func_74764_b("metaData")) {
            this.updateFromNonUpgradeableVersion();
        }
        if (nbtVersion == 0 && !nbtRoot.func_74764_b("conModes")) {
            for (ForgeDirection dir : this.externalConnections) {
                this.conectionModes.put(dir, ConnectionMode.OUTPUT);
            }
        }
    }
}

