/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class LFPacketBatchRedstoneUpdate
implements IMessage {
    private List<BlockCoord> affectedPipes;
    private boolean isActive;

    public LFPacketBatchRedstoneUpdate() {
    }

    public LFPacketBatchRedstoneUpdate(List<BlockCoord> affectedPipes, boolean isActive) {
        this.affectedPipes = affectedPipes;
        this.isActive = isActive;
    }

    public void fromBytes(ByteBuf buf) {
        int pipesCount = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.affectedPipes = Lists.newArrayListWithCapacity((int)pipesCount);
        for (int i = 0; i < pipesCount; ++i) {
            this.affectedPipes.add(new BlockCoord(ByteBufUtils.readVarInt((ByteBuf)buf, (int)5), ByteBufUtils.readVarInt((ByteBuf)buf, (int)5), ByteBufUtils.readVarInt((ByteBuf)buf, (int)5)));
        }
        this.isActive = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.affectedPipes.size(), (int)5);
        for (BlockCoord pipe : this.affectedPipes) {
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)pipe.x, (int)5);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)pipe.y, (int)5);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)pipe.z, (int)5);
        }
        buf.writeBoolean(this.isActive);
    }

    public static class CHandler
    implements IMessageHandler<LFPacketBatchRedstoneUpdate, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(LFPacketBatchRedstoneUpdate message, MessageContext ctx) {
            WorldClient w = Minecraft.func_71410_x().field_71441_e;
            if (w == null) {
                return null;
            }
            Iterator it = message.affectedPipes.iterator();
            while (it.hasNext()) {
                IRedstoneConduit redPipe;
                BlockCoord pos = (BlockCoord)it.next();
                TileEntity t = w.func_147438_o(pos.x, pos.y, pos.z);
                if (!(t instanceof TileConduitBundle) || (redPipe = ((TileConduitBundle)t).getConduit(IRedstoneConduit.class)) == null) continue;
                if (redPipe.isActive() == message.isActive) {
                    it.remove();
                    continue;
                }
                redPipe.setActive(message.isActive);
            }
            CHandler.updateRenderForAffectedPipes((World)w, message.affectedPipes);
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private static void updateRenderForAffectedPipes(World world, List<BlockCoord> affectedPipes) {
            if (affectedPipes.isEmpty()) {
                return;
            }
            int minX = affectedPipes.get((int)0).x;
            int minY = affectedPipes.get((int)0).y;
            int minZ = affectedPipes.get((int)0).z;
            int maxX = affectedPipes.get((int)0).x;
            int maxY = affectedPipes.get((int)0).y;
            int maxZ = affectedPipes.get((int)0).z;
            for (BlockCoord coord : affectedPipes) {
                if (coord.x < minX) {
                    minX = coord.x;
                }
                if (coord.y < minY) {
                    minY = coord.y;
                }
                if (coord.z < minZ) {
                    minZ = coord.z;
                }
                if (coord.x > maxX) {
                    maxX = coord.x;
                }
                if (coord.y > maxY) {
                    maxY = coord.y;
                }
                if (coord.z <= maxZ) continue;
                maxZ = coord.z;
            }
            world.func_147458_c(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }
}

