/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import com.google.common.collect.Lists;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import java.util.List;
import java.util.Locale;
import net.minecraft.tileentity.TileEntity;

public enum RedstoneControlMode implements CycleButton.ICycleEnum
{
    IGNORE(IconEIO.REDSTONE_MODE_ALWAYS),
    ON(IconEIO.REDSTONE_MODE_WITH_SIGNAL),
    OFF(IconEIO.REDSTONE_MODE_WITHOUT_SIGNAL),
    NEVER(IconEIO.REDSTONE_MODE_NEVER);

    private final IWidgetIcon icon;
    public static final RedstoneControlMode[] MODES;

    private RedstoneControlMode(IWidgetIcon icon) {
        this.icon = icon;
    }

    public String getTooltip() {
        return EnderIO.lang.localize("gui.tooltip.redstoneControlMode." + this.name().toLowerCase(Locale.US));
    }

    public IWidgetIcon getIcon() {
        return this.icon;
    }

    public List<String> getTooltipLines() {
        return Lists.newArrayList((Object[])new String[]{this.getTooltip()});
    }

    public static boolean isConditionMet(RedstoneControlMode redstoneControlMode, int powerLevel) {
        boolean redstoneCheckPassed = true;
        if (redstoneControlMode == NEVER) {
            redstoneCheckPassed = false;
        } else if (redstoneControlMode == ON) {
            if (powerLevel < 1) {
                redstoneCheckPassed = false;
            }
        } else if (redstoneControlMode == OFF && powerLevel > 0) {
            redstoneCheckPassed = false;
        }
        return redstoneCheckPassed;
    }

    public static boolean isConditionMet(RedstoneControlMode redstoneControlMode, TileEntity te) {
        return RedstoneControlMode.isConditionMet(redstoneControlMode, te.func_145831_w().func_94572_D(te.field_145851_c, te.field_145848_d, te.field_145849_e));
    }

    public RedstoneControlMode next() {
        int ord = this.ordinal();
        ord = ord == MODES.length - 1 ? 0 : ++ord;
        return MODES[ord];
    }

    public RedstoneControlMode previous() {
        int ord = this.ordinal();
        if (--ord < 0) {
            ord = MODES.length - 1;
        }
        return MODES[ord];
    }

    static {
        MODES = RedstoneControlMode.values();
    }
}

