/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ClientProxy;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.tank.BlockItemTank;
import crazypants.enderio.machine.tank.ContainerTank;
import crazypants.enderio.machine.tank.GuiTank;
import crazypants.enderio.machine.tank.PacketTankFluid;
import crazypants.enderio.machine.tank.PacketTankVoidMode;
import crazypants.enderio.machine.tank.TileTank;
import crazypants.enderio.network.PacketHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class BlockTank
extends AbstractMachineBlock<TileTank>
implements IAdvancedTooltipProvider {
    public static BlockTank create() {
        PacketHandler.INSTANCE.registerMessage(PacketTankFluid.class, PacketTankFluid.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketTankVoidMode.class, PacketTankVoidMode.class, PacketHandler.nextID(), Side.SERVER);
        BlockTank res = new BlockTank();
        res.init();
        return res;
    }

    protected BlockTank() {
        super(ModObject.blockTank, TileTank.class);
        this.func_149672_a(Block.field_149778_k);
        this.func_149713_g(0);
    }

    @Override
    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemTank.class, (String)this.modObject.unlocalisedName);
        GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.modObject.unlocalisedName + "TileEntity"));
        EnderIO.guiHandler.registerGuiHandler(this.getGuiId(), this);
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs p_149666_2_, List list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileTank(metadata);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileTank)) {
            return null;
        }
        return new ContainerTank(player.field_71071_by, (TileTank)te);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileTank)) {
            return null;
        }
        return new GuiTank(player.field_71071_by, (TileTank)te);
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    protected int getGuiId() {
        return 86;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntity te = world.func_147438_o(x, y, z);
        short facing = 0;
        if (te instanceof AbstractMachineEntity) {
            AbstractMachineEntity me = (AbstractMachineEntity)te;
            facing = me.facing;
        }
        int meta = world.func_72805_g(x, y, z);
        if ((meta = MathHelper.func_76125_a((int)meta, (int)0, (int)1)) == 1) {
            return this.iconBuffer[0][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing] + 6];
        }
        return this.iconBuffer[0][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing]];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int blockSide, int blockMeta) {
        int offset = MathHelper.func_76125_a((int)blockMeta, (int)0, (int)1) == 0 ? 0 : 6;
        return this.iconBuffer[0][blockSide + offset];
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tank = world.func_147438_o(x, y, z);
        if (tank instanceof TileTank) {
            FluidStack stack = ((TileTank)tank).tank.getFluid();
            return stack == null || stack.amount <= 0 ? 0 : stack.getFluid().getLuminosity(stack);
        }
        return super.getLightValue(world, x, y, z);
    }

    @Override
    protected String getMachineFrontIconKey(boolean pressurized) {
        if (pressurized) {
            return "enderio:blockTankAdvanced";
        }
        return "enderio:blockTank";
    }

    @Override
    protected String getSideIconKey(boolean active) {
        return this.getMachineFrontIconKey(active);
    }

    @Override
    protected String getBackIconKey(boolean active) {
        return this.getMachineFrontIconKey(active);
    }

    @Override
    protected String getTopIconKey(boolean pressurized) {
        if (pressurized) {
            return "enderio:blockTankTopAdvanced";
        }
        return "enderio:machineTop";
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta = MathHelper.func_76125_a((int)meta, (int)0, (int)1)) == 1) {
            return 2000.0f;
        }
        return super.func_149638_a(par1Entity);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World w, int x, int y, int z, int side) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileTank) {
            return ((TileTank)te).getComparatorOutput();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        FluidStack fl;
        if (itemstack.field_77990_d != null && itemstack.field_77990_d.func_74764_b("tankContents") && (fl = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)itemstack.field_77990_d.func_74781_a("tankContents")))) != null && fl.getFluid() != null) {
            String str = fl.amount + " " + EnderIO.lang.localize("fluid.millibucket.abr") + " " + PowerDisplayUtil.ofStr() + " " + fl.getFluid().getLocalizedName();
            list.add(str);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources((List)list, (ItemStack)itemstack);
        if (itemstack.func_77960_j() == 1) {
            list.add(EnumChatFormatting.ITALIC + EnderIO.lang.localize("blastResistant"));
        }
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        System.out.println("BlockTank.getUnlocalizedNameForTooltip: ");
        return stack.func_77977_a();
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTank) {
            TileTank tank = (TileTank)te;
            FluidStack stored = tank.tank.getFluid();
            String fluid = stored == null ? EnderIO.lang.localize("tooltip.none") : stored.getFluid().getLocalizedName(stored);
            int amount = stored == null ? 0 : stored.amount;
            tooltip.add(String.format("%s%s : %s (%d %s)", EnumChatFormatting.WHITE, EnderIO.lang.localize("tooltip.fluidStored"), fluid, amount, EnderIO.lang.localize("fluid.millibucket.abr")));
        }
    }
}

