/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.Lists;
import extracells.15_09_2024__02_32_46.k\u043ck;
import extracells.15_09_2024__02_32_46.\u0443i\u043e;
import extracells.api.ECApi;
import extracells.api.IFluidStorageCell;
import extracells.api.IHandlerFluidStorage;
import extracells.container.ContainerFluidStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class HandlerItemStorageFluid
implements IMEInventoryHandler<IAEFluidStack>,
IHandlerFluidStorage {
    private NBTTagCompound stackTag;
    protected ArrayList<FluidStack> fluidStacks = new ArrayList();
    private ArrayList<Fluid> prioritizedFluids = new ArrayList();
    private int totalTypes;
    private int totalBytes;
    private List<ContainerFluidStorage> containers = new ArrayList<ContainerFluidStorage>();
    private ISaveProvider saveProvider;

    public HandlerItemStorageFluid(ItemStack itemStack, ISaveProvider iSaveProvider2) {
        ISaveProvider iSaveProvider2;
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
         .stackTag = itemStack.func_77978_p();
         .totalTypes = ((IFluidStorageCell)itemStack.func_77973_b()).getMaxTypes(itemStack);
         .totalBytes = ((IFluidStorageCell)itemStack.func_77973_b()).getMaxBytes(itemStack) * 250;
        for (int i = 0; i <  .totalTypes; ++i) {
             .fluidStacks.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound) .stackTag.func_74775_l(\u0443i\u043e."l \u0441v" + i)));
        }
         .saveProvider = iSaveProvider2;
    }

    public HandlerItemStorageFluid(ItemStack itemStack, ISaveProvider iSaveProvider, ArrayList<Fluid> arrayList) {
         (itemStack, iSaveProvider);
        if (arrayList != null) {
             .prioritizedFluids = arrayList;
        }
    }

    private boolean allowedByFormat(Fluid fluid) {
        return !\u000a\u000a .isFormatted() || \u000a\u000a .prioritizedFluids.contains(fluid);
    }

    public boolean canAccept(IAEFluidStack iAEFluidStack) {
        if (iAEFluidStack == null) {
            return false;
        }
        if (!ECApi.instance().canStoreFluid(iAEFluidStack.getFluid())) {
            return false;
        }
        for (FluidStack fluidStack : \u000a\u000a\u000a\u000a\u000a .fluidStacks) {
            if (fluidStack != null && fluidStack.getFluid() != iAEFluidStack.getFluid()) continue;
            return \u000a\u000a\u000a\u000a\u000a .allowedByFormat(iAEFluidStack.getFluid());
        }
        return false;
    }

    public IAEFluidStack extractItems(IAEFluidStack iAEFluidStack, Actionable actionable, BaseActionSource baseActionSource) {
        if (iAEFluidStack == null || !\u000a .allowedByFormat(iAEFluidStack.getFluid())) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList(\u000a .fluidStacks);
        for (int i = 0; i < \u000a .fluidStacks.size(); ++i) {
            FluidStack fluidStack = \u000a .fluidStacks.get(i);
            if (fluidStack == null || fluidStack.getFluidID() != iAEFluidStack.getFluid().getID()) continue;
            long \u000a 2 = (long)fluidStack.amount - iAEFluidStack.getStackSize();
            if (\u000a 2 >= 0L) {
                IAEFluidStack iAEFluidStack2 = iAEFluidStack.copy();
                FluidStack \u000a 3 = new FluidStack(fluidStack.getFluid(), (int)\u000a 2);
                arrayList.set(i, \u000a 3);
                if (actionable == Actionable.MODULATE) {
                    \u000a .writeFluidToSlot(i, \u000a 3);
                }
            } else {
                iAEFluidStack2 = AEApi.instance().storage().createFluidStack(fluidStack.copy());
                if (actionable == Actionable.MODULATE) {
                    \u000a .writeFluidToSlot(i, null);
                }
            }
            if (iAEFluidStack2 != null && iAEFluidStack2.getStackSize() > 0L) {
                \u000a .requestSave();
            }
            return iAEFluidStack2;
        }
        return null;
    }

    public int freeBytes() {
        HandlerItemStorageFluid handlerItemStorageFluid;
        long l = 0L;
        NBTBase \u000a2 = handlerItemStorageFluid.stackTag.func_74781_a(k\u043ck."\u0443 in");
        if (\u000a2 instanceof NBTTagCompound) {
            for (String string : ((NBTTagCompound)\u000a2).func_150296_c()) {
                l += ((NBTTagCompound)\u000a2).func_74763_f(string);
            }
            return (int)Math.max((long)handlerItemStorageFluid.totalBytes - l, 0L);
        }
        for (FluidStack \u000a3 : handlerItemStorageFluid.fluidStacks) {
            if (\u000a3 == null) continue;
            l += (long)\u000a3.amount;
        }
        return (int)Math.max((long)handlerItemStorageFluid.totalBytes - l, 0L);
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> iItemList2) {
        IItemList<IAEFluidStack> iItemList2;
        for (FluidStack fluidStack :  .fluidStacks) {
            if (fluidStack == null) continue;
            iItemList2.add((IAEStack)AEApi.instance().storage().createFluidStack(fluidStack));
        }
        return iItemList2;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public IAEFluidStack injectItems(IAEFluidStack iAEFluidStack, Actionable actionable, BaseActionSource baseActionSource) {
        FluidStack fluidStack;
        int n;
        if (iAEFluidStack == null || ! .allowedByFormat(iAEFluidStack.getFluid())) {
            return iAEFluidStack;
        }
        IAEFluidStack iAEFluidStack2 = iAEFluidStack.copy();
        ArrayList  2 = Lists.newArrayList( .fluidStacks);
        for (n = 0; n <  2.size(); ++n) {
            fluidStack = (FluidStack) 2.get(n);
            if (iAEFluidStack2 == null || fluidStack == null || iAEFluidStack.getFluid() != fluidStack.getFluid()) continue;
            if (iAEFluidStack2.getStackSize() <= (long) .freeBytes()) {
                 3 = new FluidStack(fluidStack.getFluid(), fluidStack.amount + (int)iAEFluidStack2.getStackSize());
                 2.set(n,  3);
                if (actionable == Actionable.MODULATE) {
                     .writeFluidToSlot(n,  3);
                }
                iAEFluidStack2 = null;
                continue;
            }
             3 = new FluidStack(fluidStack.getFluid(), fluidStack.amount +  .freeBytes());
             2.set(n,  3);
            if (actionable == Actionable.MODULATE) {
                 .writeFluidToSlot(n,  3);
            }
            iAEFluidStack2.setStackSize(iAEFluidStack2.getStackSize() - (long) .freeBytes());
        }
        for (n = 0; n <  2.size(); ++n) {
            fluidStack = (FluidStack) 2.get(n);
            if (iAEFluidStack2 == null || fluidStack != null) continue;
            if (iAEFluidStack.getStackSize() <= (long) .freeBytes()) {
                 3 = iAEFluidStack2.getFluidStack();
                 2.set(n,  3);
                if (actionable == Actionable.MODULATE) {
                     .writeFluidToSlot(n,  3);
                }
                iAEFluidStack2 = null;
                continue;
            }
            FluidStack  3 = new FluidStack(iAEFluidStack2.getFluid(),  .freeBytes());
             2.set(n,  3);
            if (actionable == Actionable.MODULATE) {
                 .writeFluidToSlot(n,  3);
            }
            iAEFluidStack2.setStackSize(iAEFluidStack2.getStackSize() - (long) .freeBytes());
        }
        if (iAEFluidStack2 == null || !iAEFluidStack2.equals(iAEFluidStack)) {
             .requestSave();
        }
        return iAEFluidStack2;
    }

    @Override
    public boolean isFormatted() {
        HandlerItemStorageFluid handlerItemStorageFluid;
        if (handlerItemStorageFluid.prioritizedFluids.isEmpty()) {
            return false;
        }
        for (Fluid fluid : handlerItemStorageFluid.prioritizedFluids) {
            if (fluid == null) continue;
            return true;
        }
        return false;
    }

    public boolean isPrioritized(IAEFluidStack iAEFluidStack) {
        return iAEFluidStack != null &&  .prioritizedFluids.contains(iAEFluidStack.getFluid());
    }

    private void requestSave() {
        HandlerItemStorageFluid handlerItemStorageFluid;
        if (handlerItemStorageFluid.saveProvider != null) {
            handlerItemStorageFluid.saveProvider.saveChanges((IMEInventory)handlerItemStorageFluid);
        }
    }

    @Override
    public int totalBytes() {
        HandlerItemStorageFluid handlerItemStorageFluid;
        return handlerItemStorageFluid.totalBytes;
    }

    @Override
    public int totalTypes() {
        HandlerItemStorageFluid handlerItemStorageFluid;
        return handlerItemStorageFluid.totalTypes;
    }

    @Override
    public int usedBytes() {
        HandlerItemStorageFluid handlerItemStorageFluid;
        return handlerItemStorageFluid.totalBytes - handlerItemStorageFluid.freeBytes();
    }

    @Override
    public int usedTypes() {
        HandlerItemStorageFluid $;
        NBTBase $2 = $.stackTag.func_74781_a(k\u043ck."\u0443 in");
        if ($2 instanceof NBTTagCompound) {
            return ((NBTTagCompound)$2).func_150296_c().size();
        }
        int $3 = 0;
        for (FluidStack $4 : $.fluidStacks) {
            if ($4 == null) continue;
            ++$3;
        }
        return $3;
    }

    public boolean validForPass(int n) {
        return true;
    }

    protected void writeFluidToSlot(int n, FluidStack fluidStack) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        if (fluidStack != null && fluidStack.getFluidID() > 0 && fluidStack.amount > 0) {
            fluidStack.writeToNBT(nBTTagCompound);
             .stackTag.func_74782_a(\u0443i\u043e."l \u0441v" + n, (NBTBase)nBTTagCompound);
        } else {
             .stackTag.func_82580_o(\u0443i\u043e."l \u0441v" + n);
        }
         .fluidStacks.set(n, fluidStack);
    }
}

