/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.Lists;
import extracells.15_09_2024__02_32_46.\u0443i\u043e;
import extracells.api.ECApi;
import extracells.api.IGasStorageCell;
import extracells.api.IHandlerFluidStorage;
import extracells.container.ContainerFluidStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class HandlerItemStorageGas
implements IMEInventoryHandler<IAEFluidStack>,
IHandlerFluidStorage {
    private NBTTagCompound stackTag;
    protected ArrayList<FluidStack> fluidStacks = new ArrayList();
    private ArrayList<Fluid> prioritizedFluids = new ArrayList();
    private int totalTypes;
    private int totalBytes;
    private List<ContainerFluidStorage> containers = new ArrayList<ContainerFluidStorage>();
    private ISaveProvider saveProvider;

    public HandlerItemStorageGas(ItemStack itemStack, ISaveProvider iSaveProvider2) {
        ISaveProvider iSaveProvider2;
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
         .stackTag = itemStack.func_77978_p();
         .totalTypes = ((IGasStorageCell)itemStack.func_77973_b()).getMaxTypes(itemStack);
         .totalBytes = ((IGasStorageCell)itemStack.func_77973_b()).getMaxBytes(itemStack) * 250;
        for (int i = 0; i <  .totalTypes; ++i) {
             .fluidStacks.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound) .stackTag.func_74775_l(\u0443i\u043e."l \u0441v" + i)));
        }
         .saveProvider = iSaveProvider2;
    }

    public HandlerItemStorageGas(ItemStack itemStack, ISaveProvider iSaveProvider, ArrayList<Fluid> arrayList) {
         (itemStack, iSaveProvider);
        if (arrayList != null) {
             .prioritizedFluids = arrayList;
        }
    }

    private boolean allowedByFormat(Fluid fluid) {
        return ! $.isFormatted() ||  $.prioritizedFluids.contains(fluid);
    }

    public boolean canAccept(IAEFluidStack iAEFluidStack) {
        if (iAEFluidStack == null) {
            return false;
        }
        if (!ECApi.instance().isGasStack(iAEFluidStack)) {
            return false;
        }
        for (FluidStack fluidStack :  .fluidStacks) {
            if (fluidStack != null && fluidStack.getFluid() != iAEFluidStack.getFluid()) continue;
            return  .allowedByFormat(iAEFluidStack.getFluid());
        }
        return false;
    }

    public IAEFluidStack extractItems(IAEFluidStack iAEFluidStack, Actionable actionable, BaseActionSource baseActionSource) {
        if (iAEFluidStack == null || ! .allowedByFormat(iAEFluidStack.getFluid())) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList( .fluidStacks);
        for (int i = 0; i <  .fluidStacks.size(); ++i) {
            FluidStack fluidStack =  .fluidStacks.get(i);
            if (fluidStack == null || fluidStack.getFluidID() != iAEFluidStack.getFluid().getID()) continue;
            long  2 = (long)fluidStack.amount - iAEFluidStack.getStackSize();
            if ( 2 >= 0L) {
                IAEFluidStack iAEFluidStack2 = iAEFluidStack.copy();
                FluidStack  3 = new FluidStack(fluidStack.getFluid(), (int) 2);
                arrayList.set(i,  3);
                if (actionable == Actionable.MODULATE) {
                     .writeFluidToSlot(i,  3);
                }
            } else {
                iAEFluidStack2 = AEApi.instance().storage().createFluidStack(fluidStack.copy());
                if (actionable == Actionable.MODULATE) {
                     .writeFluidToSlot(i, null);
                }
            }
            if (iAEFluidStack2 != null && iAEFluidStack2.getStackSize() > 0L) {
                 .requestSave();
            }
            return iAEFluidStack2;
        }
        return null;
    }

    public int freeBytes() {
        HandlerItemStorageGas handlerItemStorageGas;
        int n = 0;
        for (FluidStack fluidStack : handlerItemStorageGas.fluidStacks) {
            if (fluidStack == null) continue;
            n += fluidStack.amount;
        }
        return handlerItemStorageGas.totalBytes - n;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> iItemList2) {
        IItemList<IAEFluidStack> iItemList2;
        for (FluidStack fluidStack :  .fluidStacks) {
            if (fluidStack == null) continue;
            iItemList2.add((IAEStack)AEApi.instance().storage().createFluidStack(fluidStack));
        }
        return iItemList2;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public IAEFluidStack injectItems(IAEFluidStack iAEFluidStack, Actionable actionable, BaseActionSource baseActionSource) {
        FluidStack fluidStack;
        int n;
        if (iAEFluidStack == null || ! .allowedByFormat(iAEFluidStack.getFluid())) {
            return iAEFluidStack;
        }
        IAEFluidStack iAEFluidStack2 = iAEFluidStack.copy();
        ArrayList  2 = Lists.newArrayList( .fluidStacks);
        for (n = 0; n <  2.size(); ++n) {
            fluidStack = (FluidStack) 2.get(n);
            if (iAEFluidStack2 == null || fluidStack == null || iAEFluidStack.getFluid() != fluidStack.getFluid()) continue;
            if (iAEFluidStack2.getStackSize() <= (long) .freeBytes()) {
                 3 = new FluidStack(fluidStack.getFluid(), fluidStack.amount + (int)iAEFluidStack2.getStackSize());
                 2.set(n,  3);
                if (actionable == Actionable.MODULATE) {
                     .writeFluidToSlot(n,  3);
                }
                iAEFluidStack2 = null;
                continue;
            }
             3 = new FluidStack(fluidStack.getFluid(), fluidStack.amount +  .freeBytes());
             2.set(n,  3);
            if (actionable == Actionable.MODULATE) {
                 .writeFluidToSlot(n,  3);
            }
            iAEFluidStack2.setStackSize(iAEFluidStack2.getStackSize() - (long) .freeBytes());
        }
        for (n = 0; n <  2.size(); ++n) {
            fluidStack = (FluidStack) 2.get(n);
            if (iAEFluidStack2 == null || fluidStack != null) continue;
            if (iAEFluidStack.getStackSize() <= (long) .freeBytes()) {
                 3 = iAEFluidStack2.getFluidStack();
                 2.set(n,  3);
                if (actionable == Actionable.MODULATE) {
                     .writeFluidToSlot(n,  3);
                }
                iAEFluidStack2 = null;
                continue;
            }
            FluidStack  3 = new FluidStack(iAEFluidStack2.getFluid(),  .freeBytes());
             2.set(n,  3);
            if (actionable == Actionable.MODULATE) {
                 .writeFluidToSlot(n,  3);
            }
            iAEFluidStack2.setStackSize(iAEFluidStack2.getStackSize() - (long) .freeBytes());
        }
        if (iAEFluidStack2 == null || !iAEFluidStack2.equals(iAEFluidStack)) {
             .requestSave();
        }
        return iAEFluidStack2;
    }

    @Override
    public boolean isFormatted() {
        HandlerItemStorageGas handlerItemStorageGas;
        if (handlerItemStorageGas.prioritizedFluids.isEmpty()) {
            return false;
        }
        for (Fluid fluid : handlerItemStorageGas.prioritizedFluids) {
            if (fluid == null) continue;
            return true;
        }
        return false;
    }

    public boolean isPrioritized(IAEFluidStack $) {
        HandlerItemStorageGas $2;
        return $ != null && $2.prioritizedFluids.contains($.getFluid());
    }

    private void requestSave() {
        HandlerItemStorageGas handlerItemStorageGas;
        if (handlerItemStorageGas.saveProvider != null) {
            handlerItemStorageGas.saveProvider.saveChanges((IMEInventory)handlerItemStorageGas);
        }
    }

    @Override
    public int totalBytes() {
        HandlerItemStorageGas handlerItemStorageGas;
        return handlerItemStorageGas.totalBytes;
    }

    @Override
    public int totalTypes() {
        HandlerItemStorageGas handlerItemStorageGas;
        return handlerItemStorageGas.totalTypes;
    }

    @Override
    public int usedBytes() {
        HandlerItemStorageGas $;
        return $.totalBytes - $.freeBytes();
    }

    @Override
    public int usedTypes() {
        int n = 0;
        for (FluidStack fluidStack : \u000a\u000a\u000a\u000a\u000a .fluidStacks) {
            if (fluidStack == null) continue;
            ++n;
        }
        return n;
    }

    public boolean validForPass(int n) {
        return true;
    }

    protected void writeFluidToSlot(int n, FluidStack fluidStack) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        if (fluidStack != null && fluidStack.getFluidID() > 0 && fluidStack.amount > 0) {
            fluidStack.writeToNBT(nBTTagCompound);
             .stackTag.func_74782_a(\u0443i\u043e."l \u0441v" + n, (NBTBase)nBTTagCompound);
        } else {
             .stackTag.func_82580_o(\u0443i\u043e."l \u0441v" + n);
        }
         .fluidStacks.set(n, fluidStack);
    }
}

