/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet.part;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEFluidStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerFluidStorage;
import extracells.container.ContainerGasStorage;
import extracells.gui.GuiFluidStorage;
import extracells.gui.GuiGasStorage;
import extracells.integration.Integration;
import extracells.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PacketFluidStorage
extends AbstractPacket {
    private IItemList<IAEFluidStack> fluidStackList;
    private Fluid currentFluid;
    private boolean hasTermHandler;
    IAEFluidStack fluidDiff;

    public PacketFluidStorage() {
        PacketFluidStorage packetFluidStorage;
    }

    public PacketFluidStorage(EntityPlayer entityPlayer) {
        super(entityPlayer);
         .mode = (byte)2;
    }

    public PacketFluidStorage(EntityPlayer entityPlayer, boolean bl) {
        super(entityPlayer);
        \u000a\u000a\u000a
        .mode = (byte)3;
        \u000a\u000a\u000a
        .hasTermHandler = bl;
    }

    public PacketFluidStorage(EntityPlayer entityPlayer, Fluid fluid) {
        super(entityPlayer);
         .mode = 1;
         .currentFluid = fluid;
    }

    public PacketFluidStorage(EntityPlayer entityPlayer, IItemList<IAEFluidStack> iItemList) {
        super(entityPlayer);
         .mode = 0;
         .fluidStackList = iItemList;
    }

    @Override
    public void execute() {
        PacketFluidStorage packetFluidStorage;
        switch (packetFluidStorage.mode) {
            case 0: {
                packetFluidStorage.case0();
                break;
            }
            case 1: {
                if (packetFluidStorage.player != null && packetFluidStorage.player.field_71070_bA instanceof ContainerFluidStorage) {
                    ((ContainerFluidStorage)packetFluidStorage.player.field_71070_bA).receiveSelectedFluid(packetFluidStorage.currentFluid);
                    break;
                }
                if (packetFluidStorage.player == null || !Integration.Mods.MEKANISMGAS.isEnabled() || !(packetFluidStorage.player.field_71070_bA instanceof ContainerGasStorage)) break;
                ((ContainerGasStorage)packetFluidStorage.player.field_71070_bA).receiveSelectedFluid(packetFluidStorage.currentFluid);
                break;
            }
            case 2: {
                if (packetFluidStorage.player == null || packetFluidStorage.player.field_70170_p.field_72995_K) break;
                if (packetFluidStorage.player.field_71070_bA instanceof ContainerFluidStorage) {
                    ((ContainerFluidStorage)packetFluidStorage.player.field_71070_bA).forceFluidUpdate();
                    ((ContainerFluidStorage)packetFluidStorage.player.field_71070_bA).doWork();
                    break;
                }
                if (!Integration.Mods.MEKANISMGAS.isEnabled() || !(packetFluidStorage.player.field_71070_bA instanceof ContainerGasStorage)) break;
                ((ContainerGasStorage)packetFluidStorage.player.field_71070_bA).forceFluidUpdate();
                ((ContainerGasStorage)packetFluidStorage.player.field_71070_bA).doWork();
                break;
            }
            case 3: {
                packetFluidStorage.case3();
                break;
            }
            case 4: {
                if (packetFluidStorage.fluidDiff == null || Minecraft.func_71410_x().field_71439_g == null) break;
                if (Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof ContainerFluidStorage) {
                    ContainerFluidStorage containerFluidStorage = (ContainerFluidStorage)Minecraft.func_71410_x().field_71439_g.field_71070_bA;
                    IItemList<IAEFluidStack>  2 = containerFluidStorage.getFluidStackList();
                     2.add((IAEStack)packetFluidStorage.fluidDiff);
                    containerFluidStorage.updateFluidList( 2);
                    break;
                }
                if (!Integration.Mods.MEKANISMGAS.isEnabled() || !(Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof ContainerGasStorage)) break;
                ContainerGasStorage containerGasStorage = (ContainerGasStorage)Minecraft.func_71410_x().field_71439_g.field_71070_bA;
                IItemList<IAEFluidStack>  3 = containerGasStorage.getFluidStackList();
                 3.add((IAEStack)packetFluidStorage.fluidDiff);
                containerGasStorage.updateFluidList( 3);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void case0() {
        PacketFluidStorage packetFluidStorage;
        if (packetFluidStorage.player != null && packetFluidStorage.player.func_70613_aW()) {
            GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
            if (guiScreen instanceof GuiFluidStorage) {
                ContainerFluidStorage containerFluidStorage = (ContainerFluidStorage)((GuiFluidStorage)guiScreen).field_147002_h;
                containerFluidStorage.updateFluidList(packetFluidStorage.fluidStackList);
            } else if (Integration.Mods.MEKANISMGAS.isEnabled() && guiScreen instanceof GuiGasStorage) {
                ContainerGasStorage containerGasStorage = (ContainerGasStorage)((GuiGasStorage)guiScreen).field_147002_h;
                containerGasStorage.updateFluidList(packetFluidStorage.fluidStackList);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void case3() {
        PacketFluidStorage packetFluidStorage;
        if (packetFluidStorage.player != null && packetFluidStorage.player.func_70613_aW()) {
            GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
            if (guiScreen instanceof GuiFluidStorage) {
                ContainerFluidStorage containerFluidStorage = (ContainerFluidStorage)((GuiFluidStorage)guiScreen).field_147002_h;
                containerFluidStorage.hasWirelessTermHandler = packetFluidStorage.hasTermHandler;
                ((GuiFluidStorage)guiScreen).refreshGUI();
            } else if (Integration.Mods.MEKANISMGAS.isEnabled() && guiScreen instanceof GuiGasStorage) {
                ContainerGasStorage containerGasStorage = (ContainerGasStorage)((GuiGasStorage)guiScreen).field_147002_h;
                containerGasStorage.hasWirelessTermHandler = packetFluidStorage.hasTermHandler;
            }
        }
    }

    @Override
    public void readData(ByteBuf byteBuf) {
        switch ( .mode) {
            case 0: {
                 .fluidStackList = AEApi.instance().storage().createFluidList();
                while (byteBuf.readableBytes() > 0) {
                    Fluid fluid = PacketFluidStorage.readFluid(byteBuf);
                    long  2 = byteBuf.readLong();
                    boolean  3 = byteBuf.readBoolean();
                    if (fluid == null) continue;
                    IAEFluidStack  4 = AEApi.instance().storage().createFluidStack(new FluidStack(fluid, 1));
                     4.setStackSize( 2);
                     4.setCraftable( 3);
                     .fluidStackList.add((IAEStack) 4);
                }
                break;
            }
            case 1: {
                 .currentFluid = PacketFluidStorage.readFluid(byteBuf);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                 .hasTermHandler = byteBuf.readBoolean();
                break;
            }
            case 4: {
                 .fluidDiff = (IAEFluidStack)AEFluidStack.create((Object)new FluidStack(PacketFluidStorage.readFluid(byteBuf), 1)).setStackSize(byteBuf.readLong());
            }
        }
    }

    @Override
    public void writeData(ByteBuf byteBuf2) {
        switch (packetFluidStorage.mode) {
            case 0: {
                for (IAEFluidStack iAEFluidStack : packetFluidStorage.fluidStackList) {
                    FluidStack fluidStack = iAEFluidStack.getFluidStack();
                    PacketFluidStorage.writeFluid(fluidStack.getFluid(), byteBuf2);
                    byteBuf2.writeLong((long)fluidStack.amount);
                    byteBuf2.writeBoolean(iAEFluidStack.isCraftable());
                }
                break;
            }
            case 1: {
                PacketFluidStorage packetFluidStorage;
                PacketFluidStorage.writeFluid(packetFluidStorage.currentFluid, byteBuf2);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                ByteBuf byteBuf2;
                byteBuf2.writeBoolean(packetFluidStorage.hasTermHandler);
            }
        }
    }
}

