/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.15_09_2024__02_32_46.mbd;
import extracells.15_09_2024__02_32_46.p\u043c\u0440;
import extracells.15_09_2024__02_32_46.zvo;
import extracells.network.AbstractPacket;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class PartBattery
extends PartECBase
implements IAEPowerStorage,
IInventoryUpdateReceiver {
    private IIcon batteryIcon = TextureManager.BATTERY_FRONT.getTexture();
    private ItemStack battery;
    IAEItemPowerStorage handler;
    private ECPrivateInventory inventory;

    public PartBattery() {
        PartBattery partBattery;
        partBattery.inventory = new ECPrivateInventory(mbd."\u0440\u0430 h", 1, 1){

            @Override
            public boolean func_94041_b(int n, ItemStack itemStack) {
                return itemStack != null && itemStack.func_77973_b() instanceof IAEItemPowerStorage;
            }
        };
    }

    @Override
    public void getDrops(List<ItemStack> list, boolean bl) {
        for (ItemStack itemStack : \u000a\u000a\u000a\u000a
        .inventory.slots) {
            if (itemStack == null) continue;
            list.add(itemStack);
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 2;
    }

    public double extractAEPower(double d, Actionable actionable, PowerMultiplier powerMultiplier) {
        if ( .handler == null ||  .battery == null) {
            return 0.0;
        }
        return  .handler.extractAEPower(actionable == Actionable.MODULATE ?  .battery :  .battery.func_77946_l(), powerMultiplier.multiply(d));
    }

    public double getAECurrentPower() {
        PartBattery partBattery;
        if (partBattery.handler == null || partBattery.battery == null) {
            return 0.0;
        }
        return partBattery.handler.getAECurrentPower(partBattery.battery);
    }

    public double getAEMaxPower() {
        PartBattery partBattery;
        if (partBattery.handler == null || partBattery.battery == null) {
            return 0.0;
        }
        return partBattery.handler.getAEMaxPower(partBattery.battery);
    }

    @Override
    public void getBoxes(IPartCollisionHelper iPartCollisionHelper) {
        iPartCollisionHelper.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    public AccessRestriction getPowerFlow() {
        PartBattery partBattery;
        if (partBattery.handler == null || partBattery.battery == null) {
            return AccessRestriction.NO_ACCESS;
        }
        return partBattery.handler.getPowerFlow(partBattery.battery);
    }

    public double injectAEPower(double d, Actionable actionable) {
        if ( .handler == null ||  .battery == null) {
            return 0.0;
        }
        return  .handler.injectAEPower(actionable == Actionable.MODULATE ?  .battery :  .battery.func_77946_l(), d);
    }

    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public void onInventoryChanged() {
        PartBattery partBattery;
        partBattery.battery = partBattery.inventory.func_70301_a(0);
        if (partBattery.battery != null && partBattery.battery.func_77973_b() instanceof IAEItemPowerStorage) {
            partBattery.batteryIcon = partBattery.battery.func_77954_c();
            partBattery.handler = (IAEItemPowerStorage)partBattery.battery.func_77973_b();
        } else {
            partBattery.batteryIcon = null;
            partBattery.handler = null;
        }
        IGridNode  $ 2 = partBattery.getGridNode();
        if ( $ 2 != null) {
            IGrid iGrid =  $ 2.getGrid();
            if (iGrid != null) {
                iGrid.postEvent((MENetworkEvent)new MENetworkPowerStorage((IAEPowerStorage)partBattery, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            partBattery.getHost().markForUpdate();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
         .inventory.readFromNBT(nBTTagCompound.func_150295_c(p\u043c\u0440." elh", 10));
         .onInventoryChanged();
    }

    @Override
    public boolean readFromStream(ByteBuf byteBuf) throws IOException {
        super.readFromStream(byteBuf);
        String string = AbstractPacket.readString(byteBuf);
        \u000a\u000a\u000a .batteryIcon = !string.equals(zvo."jr e") ? ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b(string) : TextureManager.BATTERY_FRONT.getTexture();
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper $, RenderBlocks $2) {
        PartBattery $3;
        IIcon $4 = TextureManager.BUS_SIDE.getTexture();
        $.setTexture($4, $4, $4, TextureManager.BATTERY_FRONT.getTextures()[0], $4, $4);
        $.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        $.renderInventoryBox($2);
        $.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        $3.renderInventoryBusLights($, $2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int $, int $2, int $3, IPartRenderHelper $4, RenderBlocks $5) {
        PartBattery $6;
        IIcon $7 = TextureManager.BUS_SIDE.getTexture();
        $4.setTexture($7, $7, $7, $6.batteryIcon, $7, $7);
        $4.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        $4.renderBlock($, $2, $3, $5);
        $4.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        $6.renderStaticBusLights($, $2, $3, $4, $5);
    }

    @Override
    public void writeToNBT(NBTTagCompound $) {
        PartBattery $2;
        super.writeToNBT($);
        $.func_74782_a(p\u043c\u0440." elh", (NBTBase)$2.inventory.writeToNBT());
    }

    @Override
    public void writeToStream(ByteBuf byteBuf) throws IOException {
        super.writeToStream(byteBuf);
        AbstractPacket.writeString(\u000a\u000a\u000a\u000a\u000a .battery != null ? \u000a\u000a\u000a\u000a\u000a .battery.func_77973_b().func_77650_f(\u000a\u000a\u000a\u000a\u000a .battery).func_94215_i() : zvo."jr e", byteBuf);
    }
}

